/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.parties.command;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import xaero.pac.common.claims.player.IPlayerChunkClaim;
import xaero.pac.common.claims.player.IPlayerClaimPosList;
import xaero.pac.common.claims.player.IPlayerDimensionClaims;
import xaero.pac.common.parties.party.IPartyPlayerInfo;
import xaero.pac.common.parties.party.ally.IPartyAlly;
import xaero.pac.common.parties.party.api.IPartyPlayerInfoAPI;
import xaero.pac.common.parties.party.member.IPartyMember;
import xaero.pac.common.server.IServerData;
import xaero.pac.common.server.ServerData;
import xaero.pac.common.server.claims.IServerClaimsManager;
import xaero.pac.common.server.claims.IServerDimensionClaimsManager;
import xaero.pac.common.server.claims.IServerRegionClaims;
import xaero.pac.common.server.claims.player.IServerPlayerClaimInfo;
import xaero.pac.common.server.parties.party.IServerParty;
import xaero.pac.common.server.parties.party.api.IPartyManagerAPI;

public class PartyCommands {
    private static SuggestionProvider<class_2168> getPartyPlayerSuggestor(boolean members, boolean invites) {
        return (context, builder) -> {
            class_3222 commandPlayer = ((class_2168)context.getSource()).method_9207();
            IServerData<IServerClaimsManager<IPlayerChunkClaim, IServerPlayerClaimInfo<IPlayerDimensionClaims<IPlayerClaimPosList>>, IServerDimensionClaimsManager<IServerRegionClaims>>, IServerParty<IPartyMember, IPartyPlayerInfo, IPartyAlly>> serverData = ServerData.from(((class_2168)context.getSource()).method_9211());
            IPartyManagerAPI partyManager = serverData.getPartyManager();
            IServerParty playerParty = (IServerParty)partyManager.getPartyByMember(commandPlayer.method_5667());
            String lowercaseInput = builder.getRemainingLowerCase();
            int maxIterationSize = (members ? playerParty.getMemberCount() : 0) + (invites ? playerParty.getInviteCount() : 0);
            if (maxIterationSize > 1024) {
                IPartyMember exactMember = members ? (IPartyMember)playerParty.getMemberInfo(lowercaseInput) : null;
                Object exactInvite = invites ? (Object)playerParty.getInvite(lowercaseInput) : null;
                return class_2172.method_9264(Stream.concat(Stream.ofNullable(exactMember), Stream.ofNullable(exactInvite)).map(IPartyPlayerInfoAPI::getUsername), (SuggestionsBuilder)builder);
            }
            Stream<IPartyPlayerInfo> stream = Stream.concat(members ? playerParty.getMemberInfoStream() : Stream.empty(), invites ? playerParty.getInvitedPlayersStream() : Stream.empty());
            return class_2172.method_9264(stream.map(IPartyPlayerInfoAPI::getUsername).filter(name -> name.toLowerCase().startsWith(lowercaseInput)).limit(16L), (SuggestionsBuilder)builder);
        };
    }

    public static SuggestionProvider<class_2168> getPartyMemberSuggestor() {
        return PartyCommands.getPartyPlayerSuggestor(true, false);
    }

    public static SuggestionProvider<class_2168> getPartyInviteSuggestor() {
        return PartyCommands.getPartyPlayerSuggestor(false, true);
    }

    public static SuggestionProvider<class_2168> getPartyMemberOrInviteSuggestor() {
        return PartyCommands.getPartyPlayerSuggestor(true, true);
    }
}

