/*
 * Decompiled with CFR 0.152.
 */
package net.projectile_damage.mixin;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.projectile_damage.api.EntityAttributes_ProjectileDamage;
import net.projectile_damage.api.IProjectileWeapon;
import net.projectile_damage.api.RangedWeaponKind;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3218.class})
class ServerWorldMixin {
    ServerWorldMixin() {
    }

    @Inject(method={"spawnEntity"}, at={@At(value="HEAD")})
    private void pre_spawnEntity(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        class_1665 projectile;
        if (entity instanceof class_1665 && (projectile = (class_1665)entity).method_24921() != null && projectile.method_24921() instanceof class_1309) {
            class_1309 owner = (class_1309)projectile.method_24921();
            class_1268 usedHand = null;
            class_1799 usedStack = null;
            RangedWeaponKind weaponKind = this.getWeaponKind(owner.method_6047());
            if (weaponKind != null) {
                usedStack = owner.method_6047();
                usedHand = class_1268.field_5808;
            } else {
                weaponKind = this.getWeaponKind(owner.method_6079());
                if (weaponKind != null) {
                    usedStack = owner.method_6079();
                    usedHand = class_1268.field_5810;
                }
            }
            if (usedStack != null) {
                owner.method_6127().method_26854(usedStack.method_7926(usedHand == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171));
            }
            double projectileDamage = owner.method_26825(EntityAttributes_ProjectileDamage.GENERIC_PROJECTILE_DAMAGE);
            if (weaponKind != null && projectileDamage > 0.0) {
                IProjectileWeapon projectileWeapon;
                Double customLaunchVelocity;
                class_1792 class_17922;
                double defaultDamage = weaponKind.damage();
                double defaultVelocity = weaponKind.launchVelocity();
                double velocityMultiplier = 1.0;
                if (usedStack != null && (class_17922 = usedStack.method_7909()) instanceof IProjectileWeapon && (customLaunchVelocity = (projectileWeapon = (IProjectileWeapon)class_17922).getCustomLaunchVelocity()) != null) {
                    velocityMultiplier = defaultVelocity / customLaunchVelocity;
                }
                projectile.method_7438(projectile.method_7448() * (projectileDamage / defaultDamage) * velocityMultiplier * weaponKind.adjustingMultiplier());
            }
        }
    }

    @Nullable
    private RangedWeaponKind getWeaponKind(class_1799 itemStack) {
        if (itemStack == null) {
            return null;
        }
        class_1792 item = itemStack.method_7909();
        if (item == null) {
            return null;
        }
        if (item instanceof IProjectileWeapon) {
            IProjectileWeapon weapon = (IProjectileWeapon)item;
            return weapon.getRangeWeaponKind();
        }
        return null;
    }
}

