/*
 * Decompiled with CFR 0.152.
 */
package fr.hugman.promenade.entity;

import com.mojang.serialization.Dynamic;
import fr.hugman.promenade.entity.CapybaraBrain;
import fr.hugman.promenade.entity.CapybaraState;
import fr.hugman.promenade.entity.CapybaraVariant;
import fr.hugman.promenade.entity.CapybaraVariants;
import fr.hugman.promenade.entity.data.PromenadeTrackedData;
import fr.hugman.promenade.registry.PromenadeRegistries;
import fr.hugman.promenade.registry.content.AnimalContent;
import fr.hugman.promenade.registry.tag.PromenadeItemTags;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5863;
import net.minecraft.class_5865;
import net.minecraft.class_6017;
import net.minecraft.class_6333;
import net.minecraft.class_7094;
import net.minecraft.class_7988;
import org.jetbrains.annotations.Nullable;

public class CapybaraEntity
extends class_1429
implements class_7988<CapybaraVariant> {
    private static final class_5863 FART_CHANCE_PROVIDER = class_5865.method_33926((float)0.1f, (float)0.55f, (float)0.2f);
    public static final long FALL_TO_SLEEP_LENGTH = 38L;
    public static final long WAKE_UP_LENGTH = 115L;
    public static final long FART_LENGTH = 76L;
    private static final int EAR_WIGGLE_LENGHT = 4;
    private static final class_6017 EAR_WIGGLE_COOLDOWN_PROVIDER = class_6333.method_36249((int)4, (int)64);
    public final class_7094 walkingAnimationState = new class_7094();
    public final class_7094 earWiggleAnimState = new class_7094();
    public final class_7094 fallToSleepAnimState = new class_7094();
    public final class_7094 sleepingAnimState = new class_7094();
    public final class_7094 wakeUpAnimState = new class_7094();
    public final class_7094 fartAnimState = new class_7094();
    private int earWiggleCooldown = 0;
    private static final class_2940<CapybaraVariant> VARIANT = class_2945.method_12791(CapybaraEntity.class, PromenadeTrackedData.CAPYBARA_VARIANT);
    private static final class_2940<Float> FART_CHANCE = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Long> LAST_STATE_TICK = class_2945.method_12791(CapybaraEntity.class, (class_2941)class_2943.field_39965);
    protected static final class_2940<CapybaraState> STATE = class_2945.method_12791(CapybaraEntity.class, PromenadeTrackedData.CAPYBARA_STATE);
    public static final String VARIANT_KEY = "Variant";
    public static final String FART_CHANCE_KEY = "FartChance";
    public static final String LAST_STATE_TICK_KEY = "LastStateTick";
    public static final String FARTING_KEY = "IsFarting";
    public static final String SLEEPING_KEY = "IsSleeping";

    public CapybaraEntity(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5942().method_6354(true);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.updateAnimations();
        }
        this.updateState();
    }

    protected void method_5958() {
        this.method_37908().method_16107().method_15396("capybaraBrain");
        class_4095 brain = this.method_18868();
        brain.method_19542((class_3218)this.method_37908(), (class_1309)this);
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("capybaraActivityUpdate");
        CapybaraBrain.updateActivities(this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        CapybaraBrain.method_45367(this, world.method_8409());
        this.setVariant(CapybaraVariants.getRandom(this.field_5974));
        this.field_6011.method_12778(LAST_STATE_TICK, (Object)(world.method_8410().method_8510() - 115L));
        this.field_6011.method_12778(FART_CHANCE, (Object)Float.valueOf(FART_CHANCE_PROVIDER.method_33920(this.field_5974)));
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected class_4095.class_5303<CapybaraEntity> method_28306() {
        return CapybaraBrain.createProfile();
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return CapybaraBrain.create((class_4095<CapybaraEntity>)this.method_28306().method_28335(dynamic));
    }

    public static class_5132.class_5133 createCapybaraAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.2);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(PromenadeItemTags.BREEDING_CAPYBARA);
    }

    public void method_6091(class_243 movementInput) {
        if (!this.method_5805()) {
            return;
        }
        if (this.isStationary() && this.method_24828()) {
            this.method_18799(this.method_18798().method_18805(0.0, 1.0, 0.0));
            movementInput = movementInput.method_18805(0.0, 1.0, 0.0);
        }
        super.method_6091(movementInput);
    }

    public boolean isStationary() {
        return this.isFarting() || this.isAsleep() || this.isWakingUp() || this.isFallingToSleep();
    }

    public boolean isPanicking() {
        return this.method_18868().method_18876(class_4140.field_39408, class_4141.field_18456);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return size.field_18068 * 13.0f / 14.0f;
    }

    protected class_1330 method_5963() {
        return new CapybaraBodyControl(this);
    }

    private void updateState() {
        if (this.isFarting() && this.getLastStateTickDelta() > 76L) {
            this.standUp();
        }
        if (this.isFallingToSleep() && this.getLastStateTickDelta() > 38L) {
            if (this.canSleep()) {
                this.sleep();
            } else if (this.canStopSleeping()) {
                this.stopSleeping();
            } else {
                this.standUp();
            }
        }
        if (this.isWakingUp() && this.getLastStateTickDelta() > 115L) {
            this.standUp();
        }
    }

    public boolean isFallingToSleep() {
        return this.getState() == CapybaraState.FALL_TO_SLEEP;
    }

    public boolean canFallToSleep() {
        return this.isStanding() && !this.isPanicking() && !this.isFarting();
    }

    public void fallToSleep() {
        this.setState(CapybaraState.FALL_TO_SLEEP);
        this.setLastStateTick(this.method_37908().method_8510());
    }

    public boolean isAsleep() {
        return this.getState() == CapybaraState.SLEEPING;
    }

    public boolean canSleep() {
        return this.isFallingToSleep();
    }

    public void sleep() {
        this.setState(CapybaraState.SLEEPING);
        this.setLastStateTick(this.method_37908().method_8510());
    }

    private boolean isWakingUp() {
        return this.getState() == CapybaraState.WAKE_UP;
    }

    public boolean canStopSleeping() {
        return this.isAsleep() && this.method_37908().method_8530();
    }

    public void stopSleeping() {
        this.setState(CapybaraState.WAKE_UP);
        this.setLastStateTick(this.method_37908().method_8510());
    }

    public boolean isStanding() {
        return this.getState() == CapybaraState.STANDING;
    }

    public void standUp() {
        this.setState(CapybaraState.STANDING);
        this.setLastStateTick(this.method_37908().method_8510() - 115L);
    }

    public boolean isFarting() {
        return this.getState() == CapybaraState.FARTING;
    }

    public boolean canFart() {
        return !this.isFarting() && !this.isPanicking() && !this.isAsleep() && this.field_5974.method_43057() < this.getFartChance();
    }

    public void fart() {
        this.method_5783(AnimalContent.CAPYBARA_FART_SOUND, this.method_6107(), this.method_6017());
        this.setState(CapybaraState.FARTING);
        this.setLastStateTick(this.method_37908().method_8510());
    }

    @Environment(value=EnvType.CLIENT)
    private void updateAnimations() {
        if (this.earWiggleCooldown <= 0) {
            this.earWiggleCooldown = class_3532.method_15340((int)EAR_WIGGLE_COOLDOWN_PROVIDER.method_35008(this.field_5974), (int)((int)(4.0f / this.getEarWiggleSpeed())), (int)Integer.MAX_VALUE);
            this.earWiggleAnimState.method_41322(this.field_6012);
        } else {
            --this.earWiggleCooldown;
        }
        switch (this.getState()) {
            case STANDING: {
                this.walkingAnimationState.method_45317((this.method_24828() || this.method_42148()) && this.method_18798().method_37268() > 1.0E-6, this.field_6012);
                this.fallToSleepAnimState.method_41325();
                this.sleepingAnimState.method_41325();
                this.wakeUpAnimState.method_41325();
                this.fartAnimState.method_41325();
                break;
            }
            case FALL_TO_SLEEP: {
                this.walkingAnimationState.method_41325();
                this.fallToSleepAnimState.method_41324(this.field_6012);
                this.sleepingAnimState.method_41325();
                this.wakeUpAnimState.method_41325();
                this.fartAnimState.method_41325();
                break;
            }
            case SLEEPING: {
                this.walkingAnimationState.method_41325();
                this.fallToSleepAnimState.method_41325();
                this.sleepingAnimState.method_41324(this.field_6012);
                this.wakeUpAnimState.method_41325();
                this.fartAnimState.method_41325();
                break;
            }
            case WAKE_UP: {
                this.walkingAnimationState.method_41325();
                this.fallToSleepAnimState.method_41325();
                this.sleepingAnimState.method_41325();
                this.wakeUpAnimState.method_41324(this.field_6012);
                this.fartAnimState.method_41325();
                break;
            }
            case FARTING: {
                this.walkingAnimationState.method_41325();
                this.fallToSleepAnimState.method_41325();
                this.sleepingAnimState.method_41325();
                this.wakeUpAnimState.method_41325();
                this.fartAnimState.method_41324(this.field_6012);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasLargeEyes() {
        boolean surprisedByFart = this.isFarting() && this.getLastStateTickDelta() < 40L;
        return this.method_6109() || surprisedByFart;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean hasClosedEyes() {
        boolean aboutToStartToSleep = this.isFallingToSleep() && this.getLastStateTickDelta() > 31L;
        boolean shakingHead = this.isFarting() && 40L < this.getLastStateTickDelta() && this.getLastStateTickDelta() < 65L;
        boolean wakingUp = this.isWakingUp() && (this.getLastStateTickDelta() < 5L || 18L < this.getLastStateTickDelta() && this.getLastStateTickDelta() < 34L);
        return aboutToStartToSleep || this.isAsleep() || shakingHead || wakingUp;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canAngleHead() {
        return !this.isAsleep() && !this.isFallingToSleep() && !this.isWakingUp();
    }

    @Environment(value=EnvType.CLIENT)
    public float getEarWiggleSpeed() {
        return this.isAsleep() ? 0.3f : 1.0f;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (this.isAsleep()) {
            return null;
        }
        if (this.method_6109()) {
            return AnimalContent.CAPYBARA_AMBIENT_BABY_SOUND;
        }
        return AnimalContent.CAPYBARA_AMBIENT_SOUND;
    }

    public int method_5970() {
        return this.method_6109() ? 20 : super.method_5970();
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)AnimalContent.CAPYBARA.method_5883(this.method_37908());
    }

    public CapybaraVariant getVariant() {
        return (CapybaraVariant)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(CapybaraVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public float getFartChance() {
        return ((Float)this.field_6011.method_12789(FART_CHANCE)).floatValue();
    }

    public void setFartChance(float frequency) {
        this.field_6011.method_12778(FART_CHANCE, (Object)Float.valueOf(frequency));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)CapybaraVariants.getDefault());
        this.field_6011.method_12784(FART_CHANCE, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(STATE, (Object)CapybaraState.STANDING);
        this.field_6011.method_12784(LAST_STATE_TICK, (Object)-115L);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(VARIANT_KEY, PromenadeRegistries.CAPYBARA_VARIANT.method_10221((Object)this.getVariant()).toString());
        nbt.method_10548(FART_CHANCE_KEY, this.getFartChance());
        nbt.method_10544(LAST_STATE_TICK_KEY, ((Long)this.field_6011.method_12789(LAST_STATE_TICK)).longValue());
        nbt.method_10556(FARTING_KEY, this.isFarting());
        nbt.method_10556(SLEEPING_KEY, this.isAsleep());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        CapybaraVariant variant = (CapybaraVariant)PromenadeRegistries.CAPYBARA_VARIANT.method_10223(class_2960.method_12829((String)nbt.method_10558(VARIANT_KEY)));
        if (variant != null) {
            this.setVariant(variant);
        }
        if (nbt.method_10577(FARTING_KEY)) {
            this.setState(CapybaraState.FARTING);
        }
        if (nbt.method_10577(SLEEPING_KEY)) {
            this.setState(CapybaraState.SLEEPING);
        }
        this.setFartChance(nbt.method_10583(FART_CHANCE_KEY));
    }

    public void setLastStateTick(long t) {
        this.field_6011.method_12778(LAST_STATE_TICK, (Object)t);
    }

    public long getLastStateTickDelta() {
        return this.method_37908().method_8510() - (Long)this.field_6011.method_12789(LAST_STATE_TICK);
    }

    public CapybaraState getState() {
        return (CapybaraState)((Object)this.field_6011.method_12789(STATE));
    }

    public void setState(CapybaraState state) {
        this.field_6011.method_12778(STATE, (Object)state);
    }

    class CapybaraBodyControl
    extends class_1330 {
        public CapybaraBodyControl(CapybaraEntity capybara) {
            super((class_1308)capybara);
        }

        public void method_6224() {
            if (!CapybaraEntity.this.isStationary()) {
                super.method_6224();
            }
        }
    }
}

