/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4559;
import net.minecraft.class_6885;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BlockStateCondition
implements Operation<class_2680, Boolean> {
    private final Optional<class_6885<class_2248>> optBlockEntries;
    private final Optional<class_4559> optState;

    private BlockStateCondition(Optional<class_6885<class_2248>> optBlockEntries, Optional<class_4559> optState) {
        this.optBlockEntries = optBlockEntries;
        this.optState = optState;
    }

    public static void register() {
        BuiltinPrototypes.BLOCK_STATE.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, BlockStateCondition::parse);
    }

    public static Result<BlockStateCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(BlockStateCondition::parse);
    }

    public static Result<BlockStateCondition, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<class_6885<class_2248>> optBlock = rootObject.get("block").getSuccess().flatMap(idElement -> BuiltinJson.parseBlockOrBlockTag(idElement).ifFailure(problems::add).getSuccess());
        Optional<class_4559> optState = rootObject.get("state").getSuccess().flatMap(stateElement -> BuiltinJson.parseStatePredicate(stateElement).ifFailure(problems::add).getSuccess());
        if (problems.isEmpty()) {
            return Result.success(new BlockStateCondition(optBlock, optState));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(class_2680 blockState) {
        return Optional.of(this.optBlockEntries.map(arg_0 -> ((class_2680)blockState).method_40143(arg_0)).orElse(true) != false && this.optState.map(state -> state.method_22514(blockState)).orElse(true) != false);
    }
}

