/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class IconConfig {
    private final String type;
    private final JsonElement data;

    private IconConfig(String type, JsonElement data) {
        this.type = type;
        this.data = data;
    }

    public static Result<IconConfig, Problem> parse(net.puffish.skillsmod.api.json.JsonElement rootElement) {
        return rootElement.getAsObject().andThen(IconConfig::parse);
    }

    public static Result<IconConfig, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<String> type = rootObject.getString("type").ifFailure(problems::add).getSuccess();
        Optional<net.puffish.skillsmod.api.json.JsonElement> data = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new IconConfig(type.orElseThrow(), data.orElseThrow().getJson()));
        }
        return Result.failure(Problem.combine(problems));
    }

    public String getType() {
        return this.type;
    }

    public JsonElement getData() {
        return this.data;
    }
}

