/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class PackConfig {
    private final List<String> categories;

    private PackConfig(List<String> categories) {
        this.categories = categories;
    }

    public static Result<PackConfig, Problem> parse(String name, JsonElement rootElement) {
        return rootElement.getAsObject().andThen(rootObject -> PackConfig.parse(name, rootObject));
    }

    public static Result<PackConfig, Problem> parse(String name, JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Integer version = rootObject.getInt("version").getSuccessOrElse(e -> Integer.MIN_VALUE);
        if (version < 1) {
            return Result.failure(Problem.message("Data pack `" + name + "` is outdated. Check out the mod's wiki to learn how to update the data pack."));
        }
        if (version > 2) {
            return Result.failure(Problem.message("Data pack `" + name + "` is for a newer version of the mod. Please update the mod."));
        }
        Optional optCategories = rootObject.getArray("categories").andThen(array -> array.getAsList((i, element) -> BuiltinJson.parseIdentifierPath(element)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new PackConfig((List)optCategories.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    public List<String> getCategories() {
        return this.categories;
    }
}

