/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.skill.SkillConnectionConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.skill.SkillConnection;
import net.puffish.skillsmod.skill.SkillPair;

public class SkillConnectionsGroupConfig {
    private final List<SkillConnection> connections;
    private final Map<String, Collection<String>> neighbors;

    private SkillConnectionsGroupConfig(List<SkillConnection> connections, Map<String, Collection<String>> neighbors) {
        this.connections = connections;
        this.neighbors = neighbors;
    }

    public static SkillConnectionsGroupConfig empty() {
        return new SkillConnectionsGroupConfig(List.of(), Map.of());
    }

    public static Result<SkillConnectionsGroupConfig, Problem> parse(JsonElement rootElement, SkillsConfig skills) {
        return rootElement.getAsObject().andThen(rootObject -> SkillConnectionsGroupConfig.parse(rootObject, skills));
    }

    private static Result<SkillConnectionsGroupConfig, Problem> parse(JsonObject rootObject, SkillsConfig skills) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        List bidirectional = rootObject.getArray("bidirectional").getSuccess().flatMap(array -> array.getAsList((i, element) -> SkillConnectionConfig.parse(element, skills)).mapFailure(Problem::combine).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        List unidirectional = rootObject.getArray("unidirectional").getSuccess().flatMap(array -> array.getAsList((i, element) -> SkillConnectionConfig.parse(element, skills)).mapFailure(Problem::combine).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        if (problems.isEmpty()) {
            return Result.success(SkillConnectionsGroupConfig.build(bidirectional, unidirectional));
        }
        return Result.failure(Problem.combine(problems));
    }

    public static Result<SkillConnectionsGroupConfig, Problem> parseLegacy(JsonArray rootArray, SkillsConfig skills) {
        return rootArray.getAsList((i, element) -> SkillConnectionConfig.parse(element, skills)).mapFailure(Problem::combine).mapSuccess(bidirectional -> SkillConnectionsGroupConfig.build(bidirectional, List.of()));
    }

    private static SkillConnectionsGroupConfig build(List<SkillConnectionConfig> bidirectional, List<SkillConnectionConfig> unidirectional) {
        int order;
        String b;
        String a;
        HashMap<String, Collection<String>> neighbors = new HashMap<String, Collection<String>>();
        HashMap<SkillPair, SkillPair.Direction> directions = new HashMap<SkillPair, SkillPair.Direction>();
        for (SkillConnectionConfig connection : unidirectional) {
            a = connection.getSkillAId();
            order = a.compareTo(b = connection.getSkillBId());
            if (order == 0) continue;
            neighbors.computeIfAbsent(b, k -> new HashSet()).add(a);
            directions.compute(order > 0 ? new SkillPair(a, b) : new SkillPair(b, a), (k, v) -> {
                SkillPair.Direction dir;
                SkillPair.Direction direction = dir = order > 0 ? SkillPair.Direction.A_TO_B : SkillPair.Direction.B_TO_A;
                if (v == null || v == dir) {
                    return dir;
                }
                return SkillPair.Direction.BOTH;
            });
        }
        for (SkillConnectionConfig connection : bidirectional) {
            a = connection.getSkillAId();
            order = a.compareTo(b = connection.getSkillBId());
            if (order == 0) continue;
            neighbors.computeIfAbsent(a, k -> new HashSet()).add(b);
            neighbors.computeIfAbsent(b, k -> new HashSet()).add(a);
            directions.compute(order > 0 ? new SkillPair(a, b) : new SkillPair(b, a), (k, v) -> SkillPair.Direction.BOTH);
        }
        return new SkillConnectionsGroupConfig(directions.entrySet().stream().map(entry -> {
            String a = ((SkillPair)entry.getKey()).skillAId();
            String b = ((SkillPair)entry.getKey()).skillBId();
            return switch ((SkillPair.Direction)((Object)((Object)entry.getValue()))) {
                default -> throw new IncompatibleClassChangeError();
                case SkillPair.Direction.A_TO_B -> SkillConnection.createUnidirectional(a, b);
                case SkillPair.Direction.B_TO_A -> SkillConnection.createUnidirectional(b, a);
                case SkillPair.Direction.BOTH -> SkillConnection.createBidirectional(a, b);
            };
        }).toList(), neighbors);
    }

    public List<SkillConnection> getAll() {
        return this.connections;
    }

    public Optional<Collection<String>> getNeighborsFor(String skillId) {
        return Optional.ofNullable(this.neighbors.get(skillId));
    }
}

