/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.experience.source.builtin;

import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.operation.OperationFactory;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.Prototype;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSourceDisposeContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyCalculation;
import net.puffish.skillsmod.calculation.operation.LegacyOperationRegistry;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.ItemStackCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyItemTagCondition;

public class EatFoodExperienceSource
implements ExperienceSource {
    private static final class_2960 ID = SkillsMod.createIdentifier("eat_food");
    private static final Prototype<Data> PROTOTYPE = Prototype.create(ID);
    private final Calculation<Data> calculation;

    private EatFoodExperienceSource(Calculation<Data> calculation) {
        this.calculation = calculation;
    }

    public static void register() {
        SkillsAPI.registerExperienceSource(ID, EatFoodExperienceSource::parse);
    }

    private static Result<EatFoodExperienceSource, Problem> parse(ExperienceSourceConfigContext context) {
        return context.getData().andThen(rootElement -> LegacyCalculation.parse(rootElement, PROTOTYPE, (ConfigContext)context).mapSuccess(EatFoodExperienceSource::new));
    }

    public int getValue(class_3222 player, class_1799 itemStack) {
        return (int)Math.round(this.calculation.evaluate(new Data(player, itemStack)));
    }

    @Override
    public void dispose(ExperienceSourceDisposeContext context) {
    }

    static {
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("player"), BuiltinPrototypes.PLAYER, OperationFactory.create(Data::player));
        PROTOTYPE.registerOperation(SkillsMod.createIdentifier("eaten_item_stack"), BuiltinPrototypes.ITEM_STACK, OperationFactory.create(Data::itemStack));
        LegacyOperationRegistry<Data> legacy = new LegacyOperationRegistry<Data>(PROTOTYPE);
        legacy.registerBooleanFunction("item", ItemStackCondition::parse, Data::itemStack);
        legacy.registerBooleanFunction("item_nbt", ItemStackCondition::parse, Data::itemStack);
        legacy.registerBooleanFunction("item_tag", LegacyItemTagCondition::parse, Data::itemStack);
        legacy.registerNumberFunction("player_effect", effect -> effect.method_5578() + 1, EffectOperation::parse, Data::player);
        legacy.registerNumberFunction("player_attribute", class_1324::method_6194, AttributeOperation::parse, Data::player);
        legacy.registerNumberFunction("food_hunger", data -> {
            class_4174 fc = data.itemStack().method_7909().method_19264();
            return fc == null ? 0.0 : (double)fc.method_19230();
        });
        legacy.registerNumberFunction("food_saturation", data -> {
            class_4174 fc = data.itemStack().method_7909().method_19264();
            return fc == null ? 0.0 : (double)fc.method_19231();
        });
    }

    private record Data(class_3222 player, class_1799 itemStack) {
    }
}

