/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1928;
import net.minecraft.class_2168;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.mixin.GameRulesAccessor;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

public class FabricMain
implements ModInitializer {
    public void onInitialize() {
        SkillsMod.setup(FabricLoader.getInstance().getConfigDir(), new ServerRegistrarImpl(), new ServerEventReceiverImpl(), new ServerPacketSenderImpl());
    }

    private static class ServerRegistrarImpl
    implements ServerRegistrar {
        private ServerRegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(class_2378<V> registry, class_2960 id, T entry) {
            class_2378.method_10230(registry, (class_2960)id, entry);
        }

        @Override
        public <T extends class_1928.class_4315<T>> void registerGameRule(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
            GameRulesAccessor.getRuleTypes().put(key, type);
        }

        @Override
        public <A extends ArgumentType<?>, T extends class_2314.class_7217<A>> void registerArgumentType(class_2960 id, Class<A> clazz, class_2314<A, T> serializer) {
            ArgumentTypeRegistry.registerArgumentType((class_2960)id, clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(class_2960 id, Function<class_2540, T> reader, ServerPacketHandler<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler2, buf, responseSender) -> {
                InPacket packet = (InPacket)reader.apply(buf);
                server.execute(() -> handler.handle(player, packet));
            });
        }

        @Override
        public void registerOutPacket(class_2960 id) {
        }
    }

    private static class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            ServerLifecycleEvents.SERVER_STARTING.register(eventListener::onServerStarting);
            ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> eventListener.onServerReload(server));
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> eventListener.onPlayerJoin(handler.field_14140));
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> eventListener.onCommandsRegister((CommandDispatcher<class_2168>)dispatcher));
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(class_3222 player, OutPacket packet) {
            ServerPlayNetworking.send((class_3222)player, (class_2960)packet.getIdentifier(), (class_2540)packet.getBuf());
        }
    }
}

