/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5135;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class AttributeReward
implements Reward {
    public static final class_2960 ID = SkillsMod.createIdentifier("attribute");
    private final List<UUID> uuids = new ArrayList<UUID>();
    private final class_1320 attribute;
    private final float value;
    private final class_1322.class_1323 operation;

    private AttributeReward(class_1320 attribute, float value, class_1322.class_1323 operation) {
        this.attribute = attribute;
        this.value = value;
        this.operation = operation;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, AttributeReward::parse);
    }

    private static Result<AttributeReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(AttributeReward::parse);
    }

    private static Result<AttributeReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optAttribute = rootObject.get("attribute").andThen(attributeElement -> BuiltinJson.parseAttribute(attributeElement).andThen(attribute -> {
            if (class_5135.method_26873((class_1299)class_1299.field_6097).method_27310(attribute)) {
                return Result.success(attribute);
            }
            return Result.failure(attributeElement.getPath().createProblem("Expected a valid player attribute"));
        })).ifFailure(problems::add).getSuccess();
        Optional<Float> optValue = rootObject.getFloat("value").ifFailure(problems::add).getSuccess();
        Optional optOperation = rootObject.get("operation").andThen(BuiltinJson::parseAttributeOperation).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new AttributeReward((class_1320)optAttribute.orElseThrow(), optValue.orElseThrow().floatValue(), (class_1322.class_1323)optOperation.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    private void createMissingUUIDs(int count) {
        while (this.uuids.size() < count) {
            this.uuids.add(UUID.randomUUID());
        }
    }

    @Override
    public void update(RewardUpdateContext context) {
        int count = context.getCount();
        class_1324 instance = Objects.requireNonNull(context.getPlayer().method_5996(this.attribute));
        this.createMissingUUIDs(count);
        for (int i = 0; i < this.uuids.size(); ++i) {
            UUID uuid = this.uuids.get(i);
            if (instance.method_6199(uuid) == null) {
                if (i >= count) continue;
                instance.method_26835(new class_1322(uuid, "", (double)this.value, this.operation));
                continue;
            }
            if (i < count) continue;
            instance.method_6200(uuid);
        }
    }

    @Override
    public void dispose(RewardDisposeContext context) {
        for (class_3222 player : context.getServer().method_3760().method_14571()) {
            class_1324 instance = Objects.requireNonNull(player.method_5996(this.attribute));
            for (UUID uuid : this.uuids) {
                instance.method_6200(uuid);
            }
        }
        this.uuids.clear();
    }
}

