/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.seasonhud.client.minimaps;

import club.iananderson.seasonhud.config.Config;
import club.iananderson.seasonhud.impl.fabricseasons.CurrentSeason;
import club.iananderson.seasonhud.impl.minimaps.CurrentMinimap;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_757;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.ui.MapAtlasesHUD;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class MapAtlases
implements HudRenderCallback {
    public static MapAtlases HUD_INSTANCE;
    private final class_310 mc = class_310.method_1551();

    public static void init() {
        HUD_INSTANCE = new MapAtlases();
        HudRenderCallback.EVENT.register((Object)HUD_INSTANCE);
    }

    public static void drawMapComponentSeason(class_332 poseStack, int x, int y, int originOffsetWidth, int originOffsetHeight, float textScaling) {
        if (CurrentMinimap.loadedMinimap("map_atlases")) {
            String seasonToDisplay = CurrentSeason.getSeasonName().get(0).getString();
            MapAtlasesHUD.drawScaledText((class_332)poseStack, (int)x, (int)y, (String)seasonToDisplay, (float)textScaling, (int)originOffsetWidth, (int)originOffsetHeight);
        }
    }

    private boolean shouldDraw(class_310 mc) {
        if (CurrentMinimap.loadedMinimap("map_atlases")) {
            if (mc.field_1724 == null) {
                return false;
            }
            if (MapAtlasesMod.CONFIG != null && !MapAtlasesMod.CONFIG.drawMiniMapHUD) {
                return false;
            }
            if (mc.field_1690.field_1866) {
                return false;
            }
            class_1799 atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((class_1657)mc.field_1724);
            if (atlas.method_7960()) {
                return false;
            }
            if (atlas.method_7960()) {
                return false;
            }
            if (MapAtlasesClient.currentMapStateId == null) {
                return false;
            }
            return atlas.method_7969() != null && atlas.method_7969().method_10545("maps") && Arrays.stream(atlas.method_7969().method_10561("maps")).anyMatch(i -> i == MapAtlasesAccessUtils.getMapIntFromString((String)MapAtlasesClient.currentMapStateId));
        }
        return false;
    }

    public void onHudRender(class_332 seasonStack, float alpha) {
        if (CurrentMinimap.loadedMinimap("map_atlases") && this.mc.field_1687 != null && this.mc.field_1724 != null) {
            int textHeightOffset;
            int y;
            int mapBgScaledSize = (int)Math.floor(0.2 * (double)this.mc.method_22683().method_4502());
            if (MapAtlasesMod.CONFIG != null) {
                mapBgScaledSize = (int)Math.floor((double)MapAtlasesMod.CONFIG.forceMiniMapScaling / 100.0 * (double)this.mc.method_22683().method_4502());
            }
            String anchorLocation = "UpperLeft";
            if (MapAtlasesMod.CONFIG != null) {
                anchorLocation = MapAtlasesMod.CONFIG.miniMapAnchoring;
            }
            int x = anchorLocation.contains("Left") ? 0 : this.mc.method_22683().method_4486() - mapBgScaledSize;
            int n = y = anchorLocation.contains("Lower") ? this.mc.method_22683().method_4502() - mapBgScaledSize : 0;
            if (MapAtlasesMod.CONFIG != null) {
                x += MapAtlasesMod.CONFIG.miniMapHorizontalOffset;
                y += MapAtlasesMod.CONFIG.miniMapVerticalOffset;
            }
            if (anchorLocation.contentEquals("UpperRight")) {
                boolean hasBeneficial = this.mc.field_1724.method_6026().stream().anyMatch(p -> p.method_5579().method_5573());
                boolean hasNegative = this.mc.field_1724.method_6026().stream().anyMatch(p -> !p.method_5579().method_5573());
                textHeightOffset = 26;
                if (MapAtlasesMod.CONFIG != null) {
                    textHeightOffset = MapAtlasesMod.CONFIG.activePotionVerticalOffset;
                }
                if (hasNegative && y < 2 * textHeightOffset) {
                    y += 2 * textHeightOffset - y;
                } else if (hasBeneficial && y < textHeightOffset) {
                    y += textHeightOffset - y;
                }
            }
            if (((Boolean)Config.enableMod.get()).booleanValue() && this.shouldDraw(this.mc)) {
                float textScaling = MapAtlasesMod.CONFIG.minimapCoordsAndBiomeScale;
                textHeightOffset = mapBgScaledSize + 4;
                if (anchorLocation.contains("Lower")) {
                    textHeightOffset = (int)(-24.0f * textScaling);
                }
                if (MapAtlasesMod.CONFIG.drawMinimapCoords) {
                    textHeightOffset = (int)((float)textHeightOffset + 12.0f * textScaling);
                }
                if (MapAtlasesMod.CONFIG.drawMinimapBiome) {
                    textHeightOffset = (int)((float)textHeightOffset + 12.0f * textScaling);
                }
                class_327 font = this.mc.field_1772;
                String seasonToDisplay = CurrentSeason.getSeasonName().get(0).getString();
                float textWidth = (float)font.method_1727(seasonToDisplay) * textScaling;
                Objects.requireNonNull(font);
                float stringHeight = 9.0f;
                float textX = (float)((double)x + (double)mapBgScaledSize / 2.0 - (double)textWidth / 2.0);
                float textY = y + textHeightOffset;
                if (textX + textWidth >= (float)this.mc.method_22683().method_4486()) {
                    textX = (float)this.mc.method_22683().method_4486() - textWidth;
                }
                int iconDim = (int)stringHeight;
                MapAtlases.drawMapComponentSeason(seasonStack, x, y, mapBgScaledSize, textHeightOffset, textScaling);
                seasonStack.method_51448().method_22903();
                seasonStack.method_51448().method_22904((double)textX, (double)textY, 0.0);
                seasonStack.method_51448().method_22905(textScaling, textScaling, 1.0f);
                class_2960 SEASON = CurrentSeason.getSeasonResource();
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (class_2960)SEASON);
                seasonStack.method_25290(SEASON, 0, 0, 0.0f, 0.0f, iconDim, iconDim, iconDim, iconDim);
                seasonStack.method_51448().method_22909();
            }
        }
    }
}

