/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.compat.ProminenceInternalAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ProminenceAbilities {
    public static int getAscendancyPoints(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (FabricLoader.getInstance().isModLoaded("prominent") && class_7923.field_41190.method_10223(new class_2960("eldritch_end:corruption")) != null) {
                return (int)player.method_26825((class_1320)class_7923.field_41190.method_10223(new class_2960("eldritch_end:corruption")));
            }
            return HelperMethods.countUnlockedSkills("ascendancy", serverPlayer);
        }
        return 0;
    }

    public static boolean boneArmor(class_1657 player) {
        class_3218 world = (class_3218)player.method_37908();
        class_238 box = HelperMethods.createBoxHeight((class_1297)player, 12);
        AtomicInteger count = new AtomicInteger();
        player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157).stream().filter(Objects::nonNull).filter(entity -> entity instanceof class_1309).filter(entity -> player instanceof class_3222).forEach(entity -> {
            class_1309 le = (class_1309)entity;
            class_3222 playerEntity = (class_3222)player;
            if (HelperMethods.checkFriendlyFire(le, (class_1657)playerEntity)) {
                SimplyStatusEffectInstance tauntedEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, 160 + ProminenceAbilities.getAscendancyPoints(player), 0, false, false, true);
                if (ProminenceAbilities.getAscendancyPoints(player) > 29) {
                    le.method_6092(new class_1293(class_1294.field_5911, 300 + ProminenceAbilities.getAscendancyPoints(player), 1, false, false, true));
                }
                tauntedEffect.setSourceEntity((class_1309)player);
                le.method_6092((class_1293)tauntedEffect);
                count.getAndIncrement();
                HelperMethods.spawnWaistHeightParticles(world, (class_2394)class_2398.field_11251, (class_1297)player, (class_1297)le, 20);
            }
        });
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, class_3419.field_15248, 0.2f, 1.0f);
        player.method_6092(new class_1293(EffectRegistry.BONEARMOR, 400, Math.min(6, count.get()), false, false, true));
        player.method_6092(new class_1293(class_1294.field_5914, 400, Math.min(6, count.get()), false, false, true));
        return true;
    }

    public static void boneArmorEffect(class_3222 player) {
        class_1293 boneArmorEffect;
        if (HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.ascendancyBoneArmor, (class_1309)player) && player.method_6059(EffectRegistry.BONEARMOR) && (boneArmorEffect = player.method_6112(EffectRegistry.BONEARMOR)) != null) {
            HelperMethods.decrementStatusEffect((class_1309)player, EffectRegistry.BONEARMOR);
            player.method_6092(new class_1293(class_1294.field_5924, 40, 2, false, false, true));
        }
    }

    public static void focusEffect(class_1657 player, class_2960 spellId) {
        if (HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.promFocus, (class_1309)player) && spellId.toString().contains("archers:barrage")) {
            if (player.method_6047().method_7909() instanceof class_1753) {
                player.method_6092(new class_1293(EffectRegistry.FOCUS, 220, 0, false, false, true));
            } else if (player.method_6047().method_7909() instanceof class_1764) {
                player.method_6016(EffectRegistry.REVEALED);
                HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.MARKSMANSHIP, 80, 8, 15);
                player.method_6092(new class_1293(EffectRegistry.STEALTH, 80, 0, false, false, true));
            }
        }
    }

    public static void promTwinstrike(class_1657 player, class_1309 target) {
        int effectChance = SimplySkills.warriorConfig.passiveWarriorTwinstrikeChance;
        int effectDamage = (int)player.method_26825(class_5134.field_23721);
        class_1282 damageSource = player.method_48923().method_48802(player);
        if (HelperMethods.isDualWielding((class_1309)player)) {
            effectChance *= 2;
        }
        if (player.method_6051().method_43048(100) < effectChance) {
            target.field_6008 = 0;
            target.method_5643(damageSource, (float)effectDamage);
            target.field_6008 = 0;
        }
    }

    public static void warriorsDevotion(class_1657 player) {
        if (player.field_6012 % 20 == 0 && HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.promWarriorsDevotion, (class_1309)player)) {
            class_1799 mainhand = player.method_6047();
            class_1799 offhand = player.method_6079();
            if ((mainhand.method_7960() || offhand.method_7960()) && (mainhand.method_7909() instanceof class_1829 || mainhand.method_7909() instanceof class_1743 || offhand.method_7909() instanceof class_1829 || offhand.method_7909() instanceof class_1743)) {
                player.method_6092(new class_1293(EffectRegistry.TITANSGRIP, 30, 0, false, false, true));
            }
        }
    }

    public static float melodyOfProtection(float amount) {
        return amount - amount / 10.0f;
    }

    public static boolean promDissonance(class_1657 player) {
        List<class_1291> statusEffects;
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 world = (class_3218)class_19372;
        int corruption = AscendancyAbilities.getAscendancyPoints(player);
        int radius = 6;
        int frequency = 20;
        int duration = 160 + corruption;
        int stunDuration = 40 + corruption / 2;
        class_1291 stunEffect = class_1294.field_5909;
        class_1291 minecellsStunned = (class_1291)class_7923.field_41174.method_10223(new class_2960("minecells:stunned"));
        if (minecellsStunned != null) {
            stunEffect = minecellsStunned;
        }
        if ((statusEffects = player.method_6026().stream().map(class_1293::method_5579).toList()).contains(EffectRegistry.MELODYOFBLOODLUST)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5901, 0, class_1294.field_5911, 0);
        }
        if (statusEffects.contains(EffectRegistry.MELODYOFPROTECTION)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5911, 0, null, 1);
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, 20, null, 0, null, 0, null, 0, class_1294.field_5921, 1);
        }
        if (statusEffects.contains(EffectRegistry.MELODYOFCONCENTRATION)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5901, 0, class_1294.field_5909, 0);
        }
        if (statusEffects.contains(EffectRegistry.MELODYOFWAR)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5911, 0, class_1294.field_5920, 1);
        }
        if (statusEffects.contains(EffectRegistry.MELODYOFSAFETY)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5920, 3, null, 0);
        }
        if (statusEffects.contains(EffectRegistry.MELODYOFSWIFTNESS)) {
            ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, duration, null, 0, null, 0, class_1294.field_5909, 2, null, 0);
        }
        ProminenceInternalAbilities.giveAreaBuffs(player, radius, frequency, stunDuration, null, 0, null, 0, stunEffect, 0, null, 0);
        HelperMethods.spawnOrbitParticles(world, player.method_19538(), (class_2394)class_2398.field_11224, radius, 20);
        HelperMethods.spawnOrbitParticles(world, player.method_19538(), (class_2394)class_2398.field_11205, radius, 16);
        HelperMethods.spawnOrbitParticles(world, player.method_19538(), (class_2394)class_2398.field_11224, 0.5, 8);
        player.method_37908().method_43129(null, (class_1297)player, SoundRegistry.ACTIVATE_PLINTH_01, class_3419.field_15248, 0.4f, 1.0f);
        return true;
    }
}

