/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities.compat;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1829;
import net.minecraft.class_3419;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsRequiredMethods;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;

public class SimplySwordsGemEffects {
    public static boolean passVersionCheck() {
        if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
            if (FabricLoader.getInstance().getModContainer("simplyswords").isPresent()) {
                String blacklistedVersion1 = "1.50";
                String blacklistedVersion2 = "1.48";
                String version = ((ModContainer)FabricLoader.getInstance().getModContainer("simplyswords").get()).getMetadata().getVersion().toString();
                if (version.contains(blacklistedVersion1) || version.contains(blacklistedVersion2)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void doGenericAbilityGemEffects(class_1657 user) {
        if (FabricLoader.getInstance().isModLoaded("simplyswords") && SimplySwordsGemEffects.passVersionCheck()) {
            int procChance;
            String allNetherEffects;
            String mainHandNetherEffect = "";
            String offHandNetherEffect = "";
            if (user.method_6047().method_7909() instanceof class_1829) {
                mainHandNetherEffect = user.method_6047().method_7948().method_10558("nether_power");
            }
            if (user.method_6079().method_7909() instanceof class_1829) {
                offHandNetherEffect = user.method_6079().method_7948().method_10558("nether_power");
            }
            if ((allNetherEffects = offHandNetherEffect + mainHandNetherEffect).contains("precise")) {
                procChance = SimplySwordsRequiredMethods.preciseChance;
                if (user.method_6051().method_43048(100) < procChance) {
                    user.method_6092(new class_1293(EffectRegistry.PRECISION, 200, 5, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
            if (allNetherEffects.contains("mighty")) {
                procChance = SimplySwordsRequiredMethods.mightyChance;
                if (user.method_6051().method_43048(100) < procChance) {
                    user.method_6092(new class_1293(EffectRegistry.MIGHT, 200, 3, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
            if (allNetherEffects.contains("stealthy")) {
                procChance = SimplySwordsRequiredMethods.stealthyChance;
                if (user.method_6051().method_43048(100) < procChance) {
                    user.method_6092(new class_1293(EffectRegistry.STEALTH, 600, 0, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
        }
    }

    public static boolean doSignatureGemEffects(class_1657 user, String nether_power) {
        if (FabricLoader.getInstance().isModLoaded("simplyswords") && SimplySwordsGemEffects.passVersionCheck()) {
            String mainHandNetherEffect = "";
            String offHandNetherEffect = "";
            if (user.method_6047().method_7909() instanceof class_1829) {
                mainHandNetherEffect = user.method_6047().method_7948().method_10558("nether_power");
            }
            if (user.method_6079().method_7909() instanceof class_1829 && !nether_power.contains("spellforged")) {
                offHandNetherEffect = user.method_6079().method_7948().method_10558("nether_power");
            }
            String allNetherEffects = offHandNetherEffect + mainHandNetherEffect;
            return allNetherEffects.contains(nether_power);
        }
        return false;
    }

    public static void doSound(class_1657 user) {
        user.method_37908().method_43129(null, (class_1297)user, SoundRegistry.FX_UI_UNLOCK3, class_3419.field_15248, 1.0f, 1.6f);
    }

    public static int renewed(class_1657 player, int cooldown, int minimumCD) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "renewed")) {
            int procChance = SimplySwordsRequiredMethods.renewedChance;
            if (player.method_6051().method_43048(100) < procChance) {
                SimplySwordsGemEffects.doSound(player);
                return minimumCD;
            }
        }
        return cooldown;
    }

    public static int accelerant(class_1657 player, int cooldown, int minimumCD) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "accelerant")) {
            SimplySwordsGemEffects.doSound(player);
            return cooldown - 12000;
        }
        return cooldown;
    }

    public static void spellshield(class_1657 player) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "spellshield")) {
            int procChance = SimplySwordsRequiredMethods.spellshieldChance;
            if (player.method_6051().method_43048(100) < procChance) {
                player.method_6092(new class_1293(EffectRegistry.BARRIER, 100, 0, false, false, true));
                SimplySwordsGemEffects.doSound(player);
            }
        }
    }

    public static void spellforged(class_1657 player) {
        if (player.field_6012 % 20 == 0 && SimplySwordsGemEffects.doSignatureGemEffects(player, "spellforged")) {
            player.method_6092(new class_1293(EffectRegistry.SPELLFORGED, 25, 0, false, false, true));
        }
    }

    public static void soulshock(class_1657 player) {
        if (player.field_6012 % 20 == 0 && SimplySwordsGemEffects.doSignatureGemEffects(player, "soulshock")) {
            player.method_6092(new class_1293(EffectRegistry.SOULSHOCK, 25, 0, false, false, true));
        }
    }

    public static void spellStandard(class_1657 user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "spell_Standard")) {
            SimplySwordsRequiredMethods.spawnSpellStandard(user);
        }
    }

    public static void warStandard(class_1657 user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "war_standard")) {
            SimplySwordsRequiredMethods.spawnWarStandard(user);
            SimplySwordsGemEffects.doSound(user);
        }
    }

    public static void deception(class_1657 user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "deception")) {
            int chance = SimplySwordsRequiredMethods.deceptionChance;
            if (user.method_6051().method_43048(100) < chance && user.method_6059(EffectRegistry.REVEALED)) {
                user.method_6016(EffectRegistry.REVEALED);
                SimplySwordsGemEffects.doSound(user);
            }
        }
    }
}

