/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.client.renderer.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.talhanation.smallships.client.model.CannonModel;
import com.talhanation.smallships.client.model.ShipModel;
import com.talhanation.smallships.client.model.sail.BriggSailModel;
import com.talhanation.smallships.client.model.sail.CogSailModel;
import com.talhanation.smallships.client.model.sail.GalleySailModel;
import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.BriggEntity;
import com.talhanation.smallships.world.entity.ship.CogEntity;
import com.talhanation.smallships.world.entity.ship.GalleyEntity;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Leashable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1088;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2499;
import net.minecraft.class_2573;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_823;
import net.minecraft.class_897;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public abstract class ShipRenderer<T extends Ship>
extends class_897<T> {
    protected final Map<class_1690.class_1692, Pair<class_2960, ShipModel<T>>> boatResources;
    private static final class_630 bannerModel;
    private static final Map<Class<? extends Ship>, SailModel> sailModels;

    public ShipRenderer(class_5617.class_5618 context) {
        super(context);
        this.field_4673 = 0.8f;
        this.boatResources = (Map)Stream.of(class_1690.class_1692.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)this.getTextureLocation((class_1690.class_1692)type), this.createBoatModel(context, (class_1690.class_1692)type))));
    }

    protected abstract ShipModel<T> createBoatModel(class_5617.class_5618 var1, class_1690.class_1692 var2);

    protected abstract class_2960 getTextureLocation(class_1690.class_1692 var1);

    @NotNull
    public class_2960 getTextureLocation(@NotNull T shipEntity) {
        return (class_2960)this.boatResources.get(shipEntity.method_47885()).getFirst();
    }

    public void render(T shipEntity, float entityYaw, float partialTicks, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        float l;
        float k;
        Attributes shipAttributes = ((Ship)((Object)shipEntity)).getAttributes();
        float h = ((float)shipEntity.method_7533() - partialTicks) / (shipAttributes.maxHealth * shipEntity.method_17681() / 40.0f);
        float j = shipEntity.method_7554() - partialTicks;
        if (j < 0.0f) {
            j = 0.0f;
        } else if (j > shipAttributes.maxHealth * 0.5f) {
            shipEntity.method_37908().method_8406((class_2394)class_2398.field_11237, shipEntity.method_23322(0.5), shipEntity.method_23318() + 1.0, shipEntity.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        if (h > 0.0f) {
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)shipEntity.method_7543()));
        }
        if (!class_3532.method_15347((float)(k = shipEntity.method_7547(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(new Quaternionf().rotateX(k * ((float)Math.PI / 180)).rotateZ(k * ((float)Math.PI / 180)));
        }
        if (!class_3532.method_15347((float)(l = ((Ship)((Object)shipEntity)).getWaveAngle(partialTicks)), (float)0.0f)) {
            poseStack.method_22907(this.getWaveAngleRotation().rotationDegrees(l));
        }
        Pair<class_2960, ShipModel<T>> pair = this.boatResources.get(shipEntity.method_47885());
        class_2960 resourceLocation = (class_2960)pair.getFirst();
        ShipModel shipModel = (ShipModel)((Object)pair.getSecond());
        poseStack.method_22905(-1.3f, -1.3f, 1.3f);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(270.0f));
        shipModel.method_2819((class_1297)shipEntity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        if (shipEntity instanceof Cannonable) {
            Cannonable cannonShipEntity = (Cannonable)shipEntity;
            this.renderCannon(cannonShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Bannerable) {
            Bannerable bannerShipEntity = (Bannerable)shipEntity;
            this.renderBanner(bannerShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Paddleable) {
            Paddleable paddleShipEntity = (Paddleable)shipEntity;
            this.renderPaddle(paddleShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        if (shipEntity instanceof Sailable) {
            Sailable sailShipEntity = (Sailable)shipEntity;
            this.renderSail(sailShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
        class_4588 vertexConsumer = multiBufferSource.getBuffer(shipModel.method_23500(resourceLocation));
        shipModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.method_22909();
        super.method_3936(shipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        if (shipEntity instanceof Leashable) {
            Leashable leashShipEntity = (Leashable)shipEntity;
            this.renderLeash(leashShipEntity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
        }
    }

    private void renderCannon(Cannonable cannonShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        for (byte i = 0; i < cannonShipEntity.self().getCannonCount(); i = (byte)(i + 1)) {
            Cannon cannon = new Cannon(cannonShipEntity.self(), cannonShipEntity.getCannonPosition(i));
            poseStack.method_22903();
            poseStack.method_22907(class_7833.field_40715.rotationDegrees(this.getCannonAngleOffset() + cannon.getAngle()));
            poseStack.method_22904(cannon.isRightSided() ? -cannon.getOffsetX() : cannon.getOffsetX(), -cannon.getOffsetY() + (double)this.getCannonHeightOffset(), -cannon.getOffsetZ());
            poseStack.method_22905(0.6f, 0.6f, 0.6f);
            CannonModel cannonModel = new CannonModel();
            cannonModel.setupAnim((Ship)((Object)cannonShipEntity), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
            class_4588 vertexConsumer = multiBufferSource.getBuffer(cannonModel.method_23500(cannonShipEntity.getTextureLocation()));
            cannonModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.method_22909();
        }
    }

    protected float getCannonAngleOffset() {
        return 0.0f;
    }

    protected float getCannonHeightOffset() {
        return 0.0f;
    }

    private void renderBanner(Bannerable bannerShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        class_1799 item = bannerShipEntity.self().getData(Ship.BANNER);
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1746) {
            class_1746 bannerItem = (class_1746)class_17922;
            poseStack.method_22903();
            Bannerable.BannerPosition pos = bannerShipEntity.getBannerPosition();
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(pos.yp));
            poseStack.method_22907(class_7833.field_40718.rotationDegrees(pos.zp));
            poseStack.method_22904(pos.x, pos.y, pos.z);
            poseStack.method_22905(0.5f, 0.5f, 0.5f);
            float bannerWaveAngle = bannerShipEntity.getBannerWaveAngle(partialTicks);
            if (!class_3532.method_15347((float)bannerWaveAngle, (float)0.0f)) {
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(bannerWaveAngle));
            }
            List patterns = class_2573.method_24280((class_1767)bannerItem.method_7706(), (class_2499)class_2573.method_24281((class_1799)item));
            class_823.method_29999((class_4587)poseStack, (class_4597)multiBufferSource, (int)packedLight, (int)class_4608.field_21444, (class_630)bannerModel, (class_4730)class_1088.field_20847, (boolean)true, (List)patterns);
            poseStack.method_22909();
        }
    }

    public class_7833 getWaveAngleRotation() {
        return class_7833.field_40713;
    }

    private void renderPaddle(Paddleable paddleShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
    }

    private void renderSail(Sailable sailShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        SailModel sailModel = sailModels.get(sailShipEntity.getClass());
        sailModel.method_2819((class_1297)((Ship)((Object)sailShipEntity)), partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        class_4588 vertexConsumer = multiBufferSource.getBuffer(sailModel.method_23500(SailModel.getSailColor((String)sailShipEntity.self().getData(Ship.SAIL_COLOR)).location));
        sailModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public boolean shouldRender(T ship, class_4604 frustum, double d, double e, double f) {
        if (super.method_3933(ship, frustum, d, e, f)) {
            return true;
        }
        if (ship instanceof Leashable) {
            class_1297 entity = ((BoatLeashAccess)ship).getLeashHolder();
            return entity != null ? frustum.method_23093(entity.method_5830()) : false;
        }
        return false;
    }

    private void renderLeash(Leashable leashShipEntity, float entityYaw, float partialTicks, class_4587 poseStack, @NotNull class_4597 multiBufferSource, int packedLight) {
        int v;
        class_1297 leashHolderEntity = ((BoatLeashAccess)((Object)leashShipEntity)).getLeashHolder();
        if (leashHolderEntity == null) {
            return;
        }
        poseStack.method_22903();
        class_243 vec3 = leashHolderEntity.method_30951(partialTicks);
        double d = class_3532.method_16436((double)partialTicks, (double)0.0, (double)0.0) * 0.01745329238474369 + 1.5707963267948966;
        class_243 vec32 = ((Ship)((Object)leashShipEntity)).method_45321(0.0f);
        double e = Math.cos(d) * vec32.field_1350 + Math.sin(d) * vec32.field_1352;
        double g = Math.sin(d) * vec32.field_1350 - Math.cos(d) * vec32.field_1352;
        double h = class_3532.method_16436((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).field_6014, (double)((Ship)((Object)leashShipEntity)).method_23317()) + e;
        double i = class_3532.method_16436((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).field_6036, (double)((Ship)((Object)leashShipEntity)).method_23318()) + vec32.field_1351;
        double j = class_3532.method_16436((double)partialTicks, (double)((Ship)((Object)leashShipEntity)).field_5969, (double)((Ship)((Object)leashShipEntity)).method_23321()) + g;
        poseStack.method_22904(e, vec32.field_1351, g);
        float k = (float)(vec3.field_1352 - h);
        float l = (float)(vec3.field_1351 - i);
        float m = (float)(vec3.field_1350 - j);
        float n = 0.025f;
        class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23587());
        Matrix4f matrix4f = poseStack.method_23760().method_23761();
        float o = class_3532.method_23278((float)(k * k + m * m)) * n / 2.0f;
        float p = m * o;
        float q = k * o;
        Function<class_243, class_2382> vec3ToVec3i = vec3d -> new class_2382(Math.round(Double.valueOf(vec3d.field_1352).floatValue()), Math.round(Double.valueOf(vec3d.field_1351).floatValue()), Math.round(Double.valueOf(vec3d.field_1350).floatValue()));
        class_2338 blockPos = new class_2338(vec3ToVec3i.apply(((Ship)((Object)leashShipEntity)).method_5836(partialTicks)));
        class_2338 blockPos2 = new class_2338(vec3ToVec3i.apply(leashHolderEntity.method_5836(partialTicks)));
        int r = this.method_24087((class_1297)((Ship)((Object)leashShipEntity)), blockPos);
        int s = this.field_4676.method_3953(leashHolderEntity).method_24087(leashHolderEntity, blockPos2);
        int t = ((Ship)((Object)leashShipEntity)).method_37908().method_8314(class_1944.field_9284, blockPos);
        int u = ((Ship)((Object)leashShipEntity)).method_37908().method_8314(class_1944.field_9284, blockPos2);
        for (v = 0; v <= 24; ++v) {
            class_927.method_23187((class_4588)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)n, (float)p, (float)q, (int)v, (boolean)false);
        }
        for (v = 24; v >= 0; --v) {
            class_927.method_23187((class_4588)vertexConsumer, (Matrix4f)matrix4f, (float)k, (float)l, (float)m, (int)r, (int)s, (int)t, (int)u, (float)n, (float)0.0f, (float)p, (float)q, (int)v, (boolean)true);
        }
        poseStack.method_22909();
    }

    public static String getNameFromType(class_1690.class_1692 type) {
        return type.method_7559().replace(":", "/");
    }

    static {
        class_630 model = class_823.method_32135().method_32109();
        model.method_32086((String)"pole").field_3665 = false;
        model.method_32086((String)"bar").field_3665 = false;
        bannerModel = model;
        sailModels = new HashMap<Class<? extends Ship>, SailModel>();
        sailModels.put(CogEntity.class, new CogSailModel());
        sailModels.put(BriggEntity.class, new BriggSailModel());
        sailModels.put(GalleyEntity.class, new GalleySailModel());
    }
}

