/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.google.common.collect.ImmutableSet;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.math.Kalkuel;
import com.talhanation.smallships.mixin.controlling.BoatAccessor;
import com.talhanation.smallships.network.ModPackets;
import com.talhanation.smallships.world.entity.projectile.Cannon;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5498;
import net.minecraft.class_5712;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Ship
extends class_1690 {
    public static final class_2940<class_2487> ATTRIBUTES = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13318);
    public static final class_2940<Float> SPEED = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> ROT_SPEED = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Byte> SAIL_STATE = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    public static final class_2940<String> SAIL_COLOR = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13326);
    public static final class_2940<class_1799> BANNER = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13322);
    public static final class_2940<Float> CANNON_POWER = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Byte> CANNON_COUNT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> FORWARD = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BACKWARD = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LEFT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> RIGHT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13323);
    private float prevWaveAngle;
    private float waveAngle;
    public float prevBannerWaveAngle;
    public float bannerWaveAngle;
    protected boolean cannonKeyPressed;
    public int sailStateCooldown = 0;
    private float setPoint;
    public final List<Cannon> CANNONS = new ArrayList<Cannon>();
    public float maxSpeed;
    private class_5498 previousCameraType;
    public static final ImmutableSet<class_5321<class_1959>> COLD_BIOMES = ImmutableSet.of((Object)class_1972.field_9467, (Object)class_1972.field_9470, (Object)class_1972.field_9435, (Object)class_1972.field_9418, (Object)class_1972.field_9463);
    public static final ImmutableSet<class_5321<class_1959>> WARM_BIOMES = ImmutableSet.of((Object)class_1972.field_9408, (Object)class_1972.field_9441, (Object)class_1972.field_9439);
    public static final ImmutableSet<class_5321<class_1959>> NEUTRAL_BIOMES = ImmutableSet.of((Object)class_1972.field_9423, (Object)class_1972.field_9446, (Object)class_1972.field_9438);

    public Ship(class_1299<? extends class_1690> entityType, class_1937 level) {
        super(entityType, level);
        if (this.method_5797() == null) {
            this.method_5665((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)class_1299.method_5890((class_1299)this.method_5864()).method_12832())));
        }
        this.method_49477(0.6f);
    }

    public void method_5773() {
        Ship ship;
        super.method_5773();
        if (this.method_7554() > 0.0f) {
            this.method_7542(this.method_7554() + 1.0f);
        }
        if ((ship = this) instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.tickSailShip();
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.tickBannerShip();
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.tickCannonShip();
        }
        if ((ship = this) instanceof Paddleable) {
            Paddleable paddleShip = (Paddleable)((Object)ship);
            paddleShip.tickPaddleShip();
        }
        boolean isCruising = this.getSpeed() > 0.085f || this.getSpeed() < -0.085f;
        this.updateShipAmbience(isCruising);
        this.updateCollision(isCruising);
        this.updateWaveAngle();
        this.updateWaterMobs();
        this.floatUp();
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(SPEED, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(ROT_SPEED, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(ATTRIBUTES, (Object)this.createDefaultAttributes());
        this.method_5841().method_12784(FORWARD, (Object)false);
        this.method_5841().method_12784(BACKWARD, (Object)false);
        this.method_5841().method_12784(LEFT, (Object)false);
        this.method_5841().method_12784(RIGHT, (Object)false);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.defineSailShipSynchedData();
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.defineBannerShipSynchedData();
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.defineCannonShipSynchedData();
        }
    }

    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(tag, this);
        this.setData(ATTRIBUTES, attributes.getSaveData());
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.readSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.readBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.readCannonShipSaveData(tag);
        }
    }

    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        attributes.addSaveData(tag);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.addSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.addBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.addCannonShipSaveData(tag);
        }
    }

    public <T> T getData(class_2940<T> accessor) {
        return (T)this.method_5841().method_12789(accessor);
    }

    public <T> void setData(class_2940<T> accessor, T value) {
        this.method_5841().method_12778(accessor, value);
    }

    protected void method_7549() {
        class_1657 player;
        float f;
        float f2;
        Attributes attributes = this.getAttributes();
        float f3 = this.getBiomesModifier() / 100.0f;
        Ship ship = this;
        if (ship instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            f2 = cannonShip.getCannonModifier() / 100.0f;
        } else {
            f2 = 0.0f;
        }
        float f4 = f3 + f2 + this.getContainerModifier() / 100.0f;
        ship = this;
        if (ship instanceof Paddleable) {
            Paddleable paddleShip = (Paddleable)((Object)ship);
            f = paddleShip.getPaddlingModifier() / 100.0f;
        } else {
            f = 0.0f;
        }
        float modifier = 1.0f - (f4 + f);
        this.maxSpeed = attributes.maxSpeed / 69.0f * modifier;
        float maxRotSp = attributes.maxRotationSpeed * 0.1f + 1.8f;
        float acceleration = attributes.acceleration;
        float rotAcceleration = attributes.rotationAcceleration;
        if (this.method_37908().method_8608() && (player = this.getDriver()) != null) {
            this.updateControls(((BoatAccessor)((Object)this)).isInputUp(), ((BoatAccessor)((Object)this)).isInputDown(), ((BoatAccessor)((Object)this)).isInputLeft(), ((BoatAccessor)((Object)this)).isInputRight(), player);
        }
        if (this.method_5799() && !((BoatLeashAccess)((Object)this)).isLeashed()) {
            Sailable sailShip;
            Ship ship2;
            if (this instanceof Paddleable && (ship2 = this) instanceof Sailable) {
                Sailable sailShip2 = (Sailable)((Object)ship2);
                if (this.isForward() && this.getDriver() != null) {
                    this.setPoint = this.maxSpeed * 12.0f / 16.0f * (1.0f + (float)(1 + sailShip2.getSailState()) * 0.1f);
                } else {
                    switch (sailShip2.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            } else {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    switch (sailShip.getSailState()) {
                        case 0: {
                            this.setPoint = 0.0f;
                            break;
                        }
                        case 1: {
                            this.setPoint = this.maxSpeed * 4.0f / 16.0f;
                            break;
                        }
                        case 2: {
                            this.setPoint = this.maxSpeed * 8.0f / 16.0f;
                            break;
                        }
                        case 3: {
                            this.setPoint = this.maxSpeed * 12.0f / 16.0f;
                            break;
                        }
                        case 4: {
                            this.setPoint = this.maxSpeed * 16.0f / 16.0f;
                        }
                    }
                }
            }
            this.calculateSpeed(acceleration);
            float rotationSpeed = Kalkuel.subtractToZero(this.getRotSpeed(), this.getVelocityResistance() * 2.5f);
            if (this.getDriver() != null) {
                if (this.isRight() && rotationSpeed < maxRotSp) {
                    rotationSpeed = Math.min(rotationSpeed + rotAcceleration * 1.0f / 8.0f, maxRotSp);
                }
                if (this.isLeft() && rotationSpeed > -maxRotSp) {
                    rotationSpeed = Math.max(rotationSpeed - rotAcceleration * 1.0f / 8.0f, -maxRotSp);
                }
            }
            this.setRotSpeed(rotationSpeed);
            ((BoatAccessor)((Object)this)).setDeltaRotation(rotationSpeed);
            this.method_36456(this.method_36454() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            if (this.getDriver() != null) {
                ship2 = this;
                if (ship2 instanceof Sailable) {
                    sailShip = (Sailable)((Object)ship2);
                    sailShip.controlBoatSailShip();
                }
                if ((ship2 = this) instanceof Paddleable) {
                    Paddleable paddleShip = (Paddleable)((Object)ship2);
                    paddleShip.controlBoatPaddleShip();
                }
            }
            this.method_18800(Kalkuel.calculateMotionX(this.getSpeed(), this.method_36454()), 0.0, Kalkuel.calculateMotionZ(this.getSpeed(), this.method_36454()));
        } else {
            this.setForward(false);
            this.setBackward(false);
            this.setLeft(false);
            this.setRight(false);
        }
    }

    private void calculateSpeed(float acceleration) {
        float speed = this.getSpeed();
        speed = speed < this.setPoint ? Kalkuel.addToSetPoint(speed, acceleration, this.setPoint) : Kalkuel.subtractToZero(speed, this.getVelocityResistance() * 0.8f);
        if (this.isLeft() || this.isRight()) {
            speed *= 1.0f - class_3532.method_15379((float)this.getRotSpeed()) * 0.02f;
        }
        this.setSpeed(speed);
    }

    public float getSpeed() {
        return ((Float)this.field_6011.method_12789(SPEED)).floatValue();
    }

    public float getRotSpeed() {
        return ((Float)this.field_6011.method_12789(ROT_SPEED)).floatValue();
    }

    public void setSpeed(float f) {
        this.field_6011.method_12778(SPEED, (Object)Float.valueOf(f));
    }

    public void setRotSpeed(float f) {
        this.field_6011.method_12778(ROT_SPEED, (Object)Float.valueOf(f));
    }

    public void setCannonCount(byte x) {
        this.field_6011.method_12778(CANNON_COUNT, (Object)x);
    }

    public byte getCannonCount() {
        return (Byte)this.field_6011.method_12789(CANNON_COUNT);
    }

    public void setForward(boolean forward) {
        this.field_6011.method_12778(FORWARD, (Object)forward);
    }

    public void setBackward(boolean backward) {
        this.field_6011.method_12778(BACKWARD, (Object)backward);
    }

    public void setLeft(boolean left) {
        this.field_6011.method_12778(LEFT, (Object)left);
    }

    public void setRight(boolean right) {
        this.field_6011.method_12778(RIGHT, (Object)right);
    }

    public boolean isForward() {
        if (this.method_5642() == null) {
            return false;
        }
        return (Boolean)this.field_6011.method_12789(FORWARD);
    }

    public boolean isBackward() {
        if (this.method_5642() == null) {
            return false;
        }
        return (Boolean)this.field_6011.method_12789(BACKWARD);
    }

    public boolean isLeft() {
        return (Boolean)this.field_6011.method_12789(LEFT);
    }

    public boolean isRight() {
        return (Boolean)this.field_6011.method_12789(RIGHT);
    }

    public float getBiomesModifier() {
        int biomeType = this.getBiomesModifierType();
        if (biomeType == -1) {
            return 0.0f;
        }
        class_2338 pos = new class_2338(Double.valueOf(this.method_23317()).intValue(), Double.valueOf(this.method_23318() - 0.1).intValue(), Double.valueOf(this.method_23321()).intValue());
        Optional biome = this.method_37908().method_30349().method_30530(class_7924.field_41236).method_29113((Object)((class_1959)this.method_37908().method_23753(pos).comp_349()));
        if (biome.isPresent()) {
            boolean warmType;
            boolean coldBiomes = COLD_BIOMES.contains(biome.get());
            boolean neutralBiomes = NEUTRAL_BIOMES.contains(biome.get());
            boolean warmBiomes = WARM_BIOMES.contains(biome.get());
            boolean coldType = biomeType == 0;
            boolean neutralType = biomeType == 1;
            boolean bl = warmType = biomeType == 2;
            if (coldBiomes && coldType || warmBiomes && warmType || neutralBiomes && neutralType) {
                return -20.0f;
            }
            if (coldBiomes && warmType || warmBiomes && coldType || (coldBiomes || warmBiomes) && neutralType) {
                return 20.0f;
            }
            if (neutralBiomes && warmType || neutralBiomes && coldType) {
                return 10.0f;
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @NotNull
    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        Bannerable bannerShip;
        Sailable sailShip;
        Cannonable cannonShip;
        Ship ship = this;
        if (ship instanceof Cannonable && (cannonShip = (Cannonable)((Object)ship)).interactCannon(player, interactionHand)) {
            return class_1269.field_5812;
        }
        ship = this;
        if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).interactSail(player, interactionHand)) {
            return class_1269.field_5812;
        }
        ship = this;
        if (ship instanceof Bannerable && (bannerShip = (Bannerable)((Object)ship)).interactBanner(player, interactionHand)) {
            return class_1269.field_5812;
        }
        return super.method_5688(player, interactionHand);
    }

    @NotNull
    public class_243 method_24829(@NotNull class_1309 livingEntity) {
        Sailable sailShip;
        Ship ship = this;
        if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).getSailState() != 0) {
            sailShip.toggleSail();
        }
        return super.method_24829(livingEntity);
    }

    protected void method_5627(class_1297 entity) {
        if (this.method_37908().method_8608() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(class_310.method_1551().field_1724, entity)) {
            this.previousCameraType = class_310.method_1551().field_1690.method_31044();
            class_310.method_1551().field_1690.method_31043(class_5498.field_26665);
        }
        super.method_5627(entity);
    }

    protected void method_5793(class_1297 entity) {
        if (this.method_37908().method_8608() && ((Boolean)SmallShipsConfig.Client.shipGeneralCameraAutoThirdPerson.get()).booleanValue() && Objects.equals(class_310.method_1551().field_1724, entity)) {
            class_310.method_1551().field_1690.method_31043(this.previousCameraType);
        }
        super.method_5793(entity);
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.75;
    }

    private void updateWaveAngle() {
        this.prevWaveAngle = this.waveAngle;
        this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.field_6012) * this.getWaveFactor();
    }

    private float getWaveFactor() {
        return this.method_37908().method_8419() ? 3.0f : 1.25f;
    }

    private float getWaveSpeed() {
        return this.method_37908().method_8419() ? 0.12f : 0.03f;
    }

    public float getWaveAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        return attributes;
    }

    public void setCannonKeyPressed(boolean b) {
        this.cannonKeyPressed = b;
    }

    public boolean isCannonKeyPressed() {
        return this.cannonKeyPressed;
    }

    @NotNull
    public class_238 method_5830() {
        return this.method_5829().method_1014(5.0);
    }

    protected abstract int method_42281();

    @NotNull
    public abstract class_1792 method_7557();

    public abstract int getBiomesModifierType();

    public abstract float getContainerModifier();

    public abstract class_2487 createDefaultAttributes();

    public float getVelocityResistance() {
        return 0.007f;
    }

    protected void waterSplash() {
    }

    private void updateShipAmbience(boolean isSwimming) {
        if (isSwimming && this.method_5799()) {
            this.waterSplash();
            this.method_37908().method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14818, this.method_5634(), 0.05f, 0.8f + 0.4f * this.field_5974.method_43057());
        }
    }

    private void updateWaterMobs() {
        double radius = (Double)SmallShipsConfig.Common.waterAnimalFleeRadius.get();
        List waterAnimals = this.method_37908().method_18467(class_1480.class, new class_238(this.method_23317() - radius, this.method_23318() - radius, this.method_23321() - radius, this.method_23317() + radius, this.method_23318() + radius, this.method_23321() + radius));
        for (class_1480 waterAnimal : waterAnimals) {
            this.fleeEntity((class_1308)waterAnimal);
        }
    }

    private void fleeEntity(class_1308 entity) {
        double fleeDistance = (Double)SmallShipsConfig.Common.waterAnimalFleeDistance.get();
        double fleeSpeed = (Double)SmallShipsConfig.Common.waterAnimalFleeSpeed.get();
        class_243 vecBoat = new class_243(this.method_23317(), this.method_23318(), this.method_23321());
        class_243 vecEntity = new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321());
        class_243 fleeDir = vecEntity.method_1020(vecBoat);
        fleeDir = fleeDir.method_1029();
        class_243 fleePos = new class_243(vecEntity.field_1352 + fleeDir.field_1352 * fleeDistance, vecEntity.field_1351 + fleeDir.field_1351 * fleeDistance, vecEntity.field_1350 + fleeDir.field_1350 * fleeDistance);
        entity.method_5942().method_6337(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350, fleeSpeed);
    }

    protected void floatUp() {
        if (this.method_5777(class_3486.field_15517)) {
            this.method_18800(this.method_18798().field_1352, 0.2, this.method_18798().field_1350);
        }
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (!this.method_37908().method_8608() && !this.method_31481()) {
            boolean bl;
            this.method_7542(this.method_7554() + f);
            this.method_5785();
            this.method_32875(class_5712.field_28736, damageSource.method_5529());
            boolean bl2 = bl = damageSource.method_5529() instanceof class_1657 && ((class_1657)damageSource.method_5529()).method_31549().field_7477;
            if (bl || this.method_7554() > this.getAttributes().maxHealth) {
                if (!bl && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                    this.method_42279(damageSource);
                }
                this.method_31472();
            }
            return true;
        }
        return true;
    }

    private void knockBack(class_1297 entity, double speed, class_238 boundingBox) {
        double d0 = (boundingBox.field_1323 + boundingBox.field_1320) / 2.0;
        double d1 = (boundingBox.field_1321 + boundingBox.field_1324) / 2.0;
        if (entity instanceof class_1309) {
            double d2 = entity.method_23317() - d0;
            double d3 = entity.method_23321() - d1;
            double d4 = Math.max(d2 * d2 + d3 * d3, 0.1);
            entity.method_18799(this.method_18798().method_1031(d2 / d4 * (1.0 + speed * 1.1), 0.0, d3 / d4 * (1.0 + speed * 1.1)));
        }
    }

    private void updateCollision(boolean isCruising) {
        if (isCruising) {
            class_238 boundingBox = this.method_5829().method_1009(2.25, 1.25, 2.25).method_989(0.0, -2.0, 0.0);
            List list = this.method_37908().method_8333((class_1297)this, boundingBox, class_1301.method_5911((class_1297)this));
            for (class_1297 entity : list) {
                if (!(entity instanceof class_1309) || this.method_5685().contains(entity)) continue;
                this.knockBack(entity, this.getSpeed(), boundingBox);
                this.collisionDamage(entity, this.getSpeed());
            }
        }
    }

    private void collisionDamage(class_1297 entity, float speed) {
        if (speed > 0.1f) {
            float damage = speed * ((Double)SmallShipsConfig.Common.shipGeneralCollisionDamage.get()).floatValue();
            entity.method_5643(this.method_48923().method_48819((class_1297)this, (class_1297)this.method_5642()), damage);
        }
    }

    @Nullable
    public class_1657 getDriver() {
        List passengers = this.method_5685();
        if (passengers.size() == 0) {
            return null;
        }
        Object e = passengers.get(0);
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (this.method_37908().field_9236) {
                class_310 minecraft = class_310.method_1551();
                class_746 instancePlayer = minecraft.field_1724;
                return player.equals((Object)instancePlayer) ? player : null;
            }
            return (class_1657)passengers.get(0);
        }
        return null;
    }

    public void updateControls(boolean forward, boolean backward, boolean left, boolean right, class_1657 player) {
        boolean needsUpdate = false;
        if (this.isForward() != forward) {
            this.setForward(forward);
            needsUpdate = true;
        }
        if (this.isBackward() != backward) {
            this.setBackward(backward);
            needsUpdate = true;
        }
        if (this.isLeft() != left) {
            this.setLeft(left);
            needsUpdate = true;
        }
        if (this.isRight() != right) {
            this.setRight(right);
            needsUpdate = true;
        }
        if (this.method_37908().field_9236 && needsUpdate) {
            ModPackets.clientSendPacket(player, ModPackets.serverUpdateShipControl.apply(forward, backward, left, right));
        }
    }
}

