/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.client.model.sail.SailModel;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.duck.BoatLeashAccess;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3417;

public interface Sailable
extends Ability {
    default public void tickSailShip() {
        if (this.self().sailStateCooldown > 0) {
            --this.self().sailStateCooldown;
        }
    }

    default public void defineSailShipSynchedData() {
        this.self().method_5841().method_12784(Ship.SAIL_STATE, (Object)0);
        this.self().method_5841().method_12784(Ship.SAIL_COLOR, (Object)SailModel.Color.WHITE.toString());
    }

    default public void readSailShipSaveData(class_2487 tag) {
        class_2487 compoundTag = tag.method_10562("Sail");
        this.self().setData(Ship.SAIL_STATE, compoundTag.method_10571("State"));
        this.self().setData(Ship.SAIL_COLOR, compoundTag.method_10558("Color"));
    }

    default public void addSailShipSaveData(class_2487 tag) {
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10569("State", (int)this.self().getData(Ship.SAIL_STATE).byteValue());
        compoundTag.method_10582("Color", this.self().getData(Ship.SAIL_COLOR));
        tag.method_10566("Sail", (class_2520)compoundTag);
    }

    default public void controlBoatSailShip() {
        byte sailState = this.getSailState();
        if (sailState != 0) {
            if (this.self().isForward() && sailState != 4 && this.self().sailStateCooldown == 0) {
                sailState = (byte)(sailState + 1);
                if (!this.self().method_37908().method_8608()) {
                    this.playSailSound(sailState);
                }
                this.self().sailStateCooldown = this.getSailStateCooldown();
                this.setSailState(sailState);
            }
            if (this.self().isBackward() && sailState != 1 && this.self().sailStateCooldown == 0) {
                sailState = (byte)(sailState - 1);
                if (!this.self().method_37908().method_8608()) {
                    this.playSailSound(sailState);
                }
                this.self().sailStateCooldown = this.getSailStateCooldown();
                this.setSailState(sailState);
            }
        }
    }

    default public boolean interactSail(class_1657 player, class_1268 interactionHand) {
        class_1799 item = player.method_5998(interactionHand);
        class_1792 class_17922 = item.method_7909();
        if (class_17922 instanceof class_1769) {
            class_1769 dyeItem = (class_1769)class_17922;
            String color = dyeItem.method_7802().method_7792();
            if (color.equals(this.self().getData(Ship.SAIL_COLOR))) {
                return false;
            }
            this.self().setData(Ship.SAIL_COLOR, color);
            if (!player.method_7337()) {
                item.method_7934(1);
            }
            this.self().method_37908().method_43128(player, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_14628, this.self().method_5634(), 15.0f, 1.5f);
            return true;
        }
        return false;
    }

    default public void toggleSail() {
        if (!((BoatLeashAccess)((Object)this)).isLeashed()) {
            byte state = this.getSailState();
            state = state > 0 ? (byte)0 : 1;
            this.setSailState(state);
            this.playSailSound(state);
        }
    }

    default public void playSailSound(int state) {
        if (state != 0) {
            this.self().method_5783(ModSoundTypes.SAIL_MOVE, 15.0f, Math.max(0.5f, 1.4f - (float)state / 5.0f));
        } else {
            this.self().method_5783(ModSoundTypes.SAIL_PULL, 10.0f, 1.0f);
        }
    }

    default public int getSailStateCooldown() {
        return (Integer)SmallShipsConfig.Common.shipGeneralSailCooldown.get();
    }

    default public void setSailState(byte state) {
        this.self().setData(Ship.SAIL_STATE, state);
    }

    default public byte getSailState() {
        return this.self().getData(Ship.SAIL_STATE);
    }
}

