/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gui;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.data.fingerprint.HashedFingerprint;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptionPages;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.gui.console.Console;
import me.jellysquid.mods.sodium.client.gui.console.message.MessageLevel;
import me.jellysquid.mods.sodium.client.gui.options.Option;
import me.jellysquid.mods.sodium.client.gui.options.OptionFlag;
import me.jellysquid.mods.sodium.client.gui.options.OptionGroup;
import me.jellysquid.mods.sodium.client.gui.options.OptionImpact;
import me.jellysquid.mods.sodium.client.gui.options.OptionPage;
import me.jellysquid.mods.sodium.client.gui.options.control.Control;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.options.storage.OptionStorage;
import me.jellysquid.mods.sodium.client.gui.prompt.ScreenPrompt;
import me.jellysquid.mods.sodium.client.gui.prompt.ScreenPromptable;
import me.jellysquid.mods.sodium.client.gui.screen.ConfigCorruptedScreen;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.gui.widgets.FlatButtonWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_446;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class SodiumOptionsGUI
extends class_437
implements ScreenPromptable {
    private final List<OptionPage> pages = new ArrayList<OptionPage>();
    private final List<ControlElement<?>> controls = new ArrayList();
    private final class_437 prevScreen;
    private OptionPage currentPage;
    private FlatButtonWidget applyButton;
    private FlatButtonWidget closeButton;
    private FlatButtonWidget undoButton;
    private FlatButtonWidget donateButton;
    private FlatButtonWidget hideDonateButton;
    private boolean hasPendingChanges;
    private ControlElement<?> hoveredElement;
    @Nullable
    private ScreenPrompt prompt;
    private static final List<class_5348> DONATION_PROMPT_MESSAGE = List.of(class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"Hello!")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"It seems that you've been enjoying "), class_2561.method_43470((String)"Sodium").method_10862(class_2583.field_24360.method_36139(2616210)), class_2561.method_43470((String)", the free and open-source optimization mod for Minecraft.")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"Mods like these are complex. They require "), class_2561.method_43470((String)"thousands of hours").method_10862(class_2583.field_24360.method_36139(16739840)), class_2561.method_43470((String)" of development, debugging, and tuning to create the experience that players have come to expect.")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"If you'd like to show your token of appreciation, and support the development of our mod in the process, then consider "), class_2561.method_43470((String)"buying us a coffee").method_10862(class_2583.field_24360.method_36139(15550926)), class_2561.method_43470((String)".")}), class_5348.method_29433((class_5348[])new class_5348[]{class_2561.method_43470((String)"And thanks again for using our mod! We hope it helps you (and your computer.)")}));

    private SodiumOptionsGUI(class_437 prevScreen) {
        super((class_2561)class_2561.method_43470((String)"Sodium Renderer Settings"));
        this.prevScreen = prevScreen;
        this.pages.add(SodiumGameOptionPages.general());
        this.pages.add(SodiumGameOptionPages.quality());
        this.pages.add(SodiumGameOptionPages.performance());
        this.pages.add(SodiumGameOptionPages.advanced());
        this.checkPromptTimers();
    }

    private void checkPromptTimers() {
        Instant threshold;
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return;
        }
        SodiumGameOptions options = SodiumClientMod.options();
        if (options.notifications.hasSeenDonationPrompt) {
            return;
        }
        HashedFingerprint fingerprint = null;
        try {
            fingerprint = HashedFingerprint.loadFromDisk();
        }
        catch (Throwable t) {
            SodiumClientMod.logger().error("Failed to read the fingerprint from disk", t);
        }
        if (fingerprint == null) {
            return;
        }
        Instant now = Instant.now();
        if (now.isAfter(threshold = Instant.ofEpochSecond(fingerprint.timestamp()).plus(3L, ChronoUnit.DAYS))) {
            this.openDonationPrompt(options);
        }
    }

    private void openDonationPrompt(SodiumGameOptions options) {
        ScreenPrompt prompt = new ScreenPrompt(this, DONATION_PROMPT_MESSAGE, 320, 190, new ScreenPrompt.Action((class_2561)class_2561.method_43470((String)"Buy us a coffee"), this::openDonationPage));
        prompt.method_25365(true);
        options.notifications.hasSeenDonationPrompt = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            SodiumClientMod.logger().error("Failed to update config file", (Throwable)e);
        }
    }

    public static class_437 createScreen(class_437 currentScreen) {
        if (SodiumClientMod.options().isReadOnly()) {
            return new ConfigCorruptedScreen(currentScreen, SodiumOptionsGUI::new);
        }
        return new SodiumOptionsGUI(currentScreen);
    }

    public void setPage(OptionPage page) {
        this.currentPage = page;
        this.rebuildGUI();
    }

    protected void method_25426() {
        super.method_25426();
        this.rebuildGUI();
        if (this.prompt != null) {
            this.prompt.init();
        }
    }

    private void rebuildGUI() {
        this.controls.clear();
        this.method_37067();
        if (this.currentPage == null) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("No pages are available?!");
            }
            this.currentPage = this.pages.get(0);
        }
        this.rebuildGUIPages();
        this.rebuildGUIOptions();
        this.undoButton = new FlatButtonWidget(new Dim2i(this.field_22789 - 211, this.field_22790 - 30, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.undo"), this::undoChanges);
        this.applyButton = new FlatButtonWidget(new Dim2i(this.field_22789 - 142, this.field_22790 - 30, 65, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.apply"), this::applyChanges);
        this.closeButton = new FlatButtonWidget(new Dim2i(this.field_22789 - 73, this.field_22790 - 30, 65, 20), (class_2561)class_2561.method_43471((String)"gui.done"), this::method_25419);
        this.donateButton = new FlatButtonWidget(new Dim2i(this.field_22789 - 128, 6, 100, 20), (class_2561)class_2561.method_43471((String)"sodium.options.buttons.donate"), this::openDonationPage);
        this.hideDonateButton = new FlatButtonWidget(new Dim2i(this.field_22789 - 26, 6, 20, 20), (class_2561)class_2561.method_43470((String)"x"), this::hideDonationButton);
        if (SodiumClientMod.options().notifications.hasClearedDonationButton) {
            this.setDonationButtonVisibility(false);
        }
        this.method_37063(this.undoButton);
        this.method_37063(this.applyButton);
        this.method_37063(this.closeButton);
        this.method_37063(this.donateButton);
        this.method_37063(this.hideDonateButton);
    }

    private void setDonationButtonVisibility(boolean value) {
        this.donateButton.setVisible(value);
        this.hideDonateButton.setVisible(value);
    }

    private void hideDonationButton() {
        SodiumGameOptions options = SodiumClientMod.options();
        options.notifications.hasClearedDonationButton = true;
        try {
            SodiumGameOptions.writeToDisk(options);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save configuration", e);
        }
        this.setDonationButtonVisibility(false);
    }

    private void rebuildGUIPages() {
        int x = 6;
        int y = 6;
        for (OptionPage page : this.pages) {
            int width = 12 + this.field_22793.method_27525((class_5348)page.getName());
            FlatButtonWidget button = new FlatButtonWidget(new Dim2i(x, y, width, 18), page.getName(), () -> this.setPage(page));
            button.setSelected(this.currentPage == page);
            x += width + 6;
            this.method_37063(button);
        }
    }

    private void rebuildGUIOptions() {
        int x = 6;
        int y = 28;
        for (OptionGroup group : this.currentPage.getGroups()) {
            for (Option option : group.getOptions()) {
                Control control = option.getControl();
                ControlElement element = control.createElement(new Dim2i(x, y, 200, 18));
                this.method_37063(element);
                this.controls.add(element);
                y += 18;
            }
            y += 4;
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.updateControls();
        super.method_25420(drawContext);
        super.method_25394(drawContext, this.prompt != null ? -1 : mouseX, this.prompt != null ? -1 : mouseY, delta);
        if (this.hoveredElement != null) {
            this.renderOptionTooltip(drawContext, this.hoveredElement);
        }
        if (this.prompt != null) {
            this.prompt.method_25394(drawContext, mouseX, mouseY, delta);
        }
    }

    private void updateControls() {
        ControlElement hovered = this.getActiveControls().filter(AbstractWidget::isHovered).findFirst().orElse(this.getActiveControls().filter(AbstractWidget::method_25370).findFirst().orElse(null));
        boolean hasChanges = this.getAllOptions().anyMatch(Option::hasChanged);
        for (OptionPage page : this.pages) {
            for (Option option : page.getOptions()) {
                if (!option.hasChanged()) continue;
                hasChanges = true;
            }
        }
        this.applyButton.setEnabled(hasChanges);
        this.undoButton.setVisible(hasChanges);
        this.closeButton.setEnabled(!hasChanges);
        this.hasPendingChanges = hasChanges;
        this.hoveredElement = hovered;
    }

    private Stream<Option<?>> getAllOptions() {
        return this.pages.stream().flatMap(s -> s.getOptions().stream());
    }

    private Stream<ControlElement<?>> getActiveControls() {
        return this.controls.stream();
    }

    private void renderOptionTooltip(class_332 drawContext, ControlElement<?> element) {
        int boxYCutoff;
        int boxHeight;
        int boxYLimit;
        Dim2i dim = element.getDimensions();
        int textPadding = 3;
        int boxPadding = 3;
        int boxWidth = 200;
        int boxY = dim.y();
        int boxX = dim.getLimitX() + boxPadding;
        Option<?> option = element.getOption();
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>(this.field_22793.method_1728((class_5348)option.getTooltip(), boxWidth - textPadding * 2));
        OptionImpact impact = option.getImpact();
        if (impact != null) {
            tooltip.add(class_2477.method_10517().method_30934((class_5348)class_2561.method_43469((String)"sodium.options.performance_impact_string", (Object[])new Object[]{impact.getLocalizedName()}).method_27692(class_124.field_1080)));
        }
        if ((boxYLimit = boxY + (boxHeight = tooltip.size() * 12 + boxPadding)) > (boxYCutoff = this.field_22790 - 40)) {
            boxY -= boxYLimit - boxYCutoff;
        }
        drawContext.method_25296(boxX, boxY, boxX + boxWidth, boxY + boxHeight, -536870912, -536870912);
        for (int i = 0; i < tooltip.size(); ++i) {
            drawContext.method_35720(this.field_22793, (class_5481)tooltip.get(i), boxX + textPadding, boxY + textPadding + i * 12, -1);
        }
    }

    private void applyChanges() {
        HashSet dirtyStorages = new HashSet();
        EnumSet<OptionFlag> flags = EnumSet.noneOf(OptionFlag.class);
        this.getAllOptions().forEach(option -> {
            if (!option.hasChanged()) {
                return;
            }
            option.applyChanges();
            flags.addAll(option.getFlags());
            dirtyStorages.add(option.getStorage());
        });
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null) {
            if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_RELOAD)) {
                client.field_1769.method_3279();
            } else if (flags.contains((Object)OptionFlag.REQUIRES_RENDERER_UPDATE)) {
                client.field_1769.method_3292();
            }
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_ASSET_RELOAD)) {
            client.method_24041(((Integer)client.field_1690.method_42563().method_41753()).intValue());
            client.method_1513();
        }
        if (flags.contains((Object)OptionFlag.REQUIRES_GAME_RESTART)) {
            Console.instance().logMessage(MessageLevel.WARN, (class_2561)class_2561.method_43471((String)"sodium.console.game_restart"), 10.0);
        }
        for (OptionStorage storage : dirtyStorages) {
            storage.save();
        }
    }

    private void undoChanges() {
        this.getAllOptions().forEach(Option::reset);
    }

    private void openDonationPage() {
        class_156.method_668().method_670("https://caffeinemc.net/donate");
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.prompt != null && this.prompt.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.prompt == null && keyCode == 80 && (modifiers & 1) != 0) {
            class_310.method_1551().method_1507((class_437)new class_446(this.prevScreen, class_310.method_1551().field_1690));
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.prompt != null) {
            return this.prompt.method_25402(mouseX, mouseY, button);
        }
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (!clicked) {
            this.method_25395(null);
            return true;
        }
        return clicked;
    }

    public boolean method_25422() {
        return !this.hasPendingChanges;
    }

    public void method_25419() {
        this.field_22787.method_1507(this.prevScreen);
    }

    public List<? extends class_364> method_25396() {
        return this.prompt == null ? super.method_25396() : this.prompt.getWidgets();
    }

    @Override
    public void setPrompt(@Nullable ScreenPrompt prompt) {
        this.prompt = prompt;
    }

    @Override
    @Nullable
    public ScreenPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Dim2i getDimensions() {
        return new Dim2i(0, 0, this.field_22789, this.field_22790);
    }
}

