/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.api.trickweapon;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.soulsweaponry.SoulsWeaponry;
import org.jetbrains.annotations.Nullable;

public class TrickWeaponUtil {
    public static Map<class_2960, class_2960> itemMappings = new HashMap<class_2960, class_2960>();
    public static final String MAPPED_TRICK_WEAPON = "mapped_trick_weapon";

    public static void loadMappings(class_3300 manager) {
        try {
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, Object>>(){}.getType();
            HashMap<class_2960, class_2960> newMappings = new HashMap<class_2960, class_2960>();
            List resources = manager.method_14489(new class_2960("soulsweapons", "trickweapons/item_mappings.json"));
            boolean shouldReplace = false;
            for (class_3298 resource : resources) {
                InputStream stream = resource.method_14482();
                try (InputStreamReader reader = new InputStreamReader(stream);){
                    Map rawJson = (Map)gson.fromJson((Reader)reader, type);
                    Object replaceValue = rawJson.get("replace");
                    if (replaceValue instanceof Boolean && ((Boolean)replaceValue).booleanValue()) {
                        shouldReplace = true;
                        newMappings.clear();
                    }
                    for (Map.Entry entry : rawJson.entrySet()) {
                        if ("replace".equals(entry.getKey())) continue;
                        String key = (String)entry.getKey();
                        String value = entry.getValue().toString();
                        class_2960 keyId = class_2960.method_12829((String)key);
                        class_2960 valueId = class_2960.method_12829((String)value);
                        if (keyId != null && valueId != null) {
                            newMappings.put(keyId, valueId);
                            continue;
                        }
                        SoulsWeaponry.LOGGER.warn("Invalid identifier in item mappings: {}", entry);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            if (shouldReplace) {
                itemMappings.clear();
            }
            itemMappings.putAll(newMappings);
        }
        catch (Exception e) {
            SoulsWeaponry.LOGGER.error("Failed to load trick weapon item mappings.", (Throwable)e);
        }
    }

    public static void loadMappings(MinecraftServer server) {
        TrickWeaponUtil.loadMappings(server.method_34864());
    }

    @Nullable
    public static class_1792 getMappedItem(class_1792 heldItem) {
        class_2960 heldItemId = class_7923.field_41178.method_10221((Object)heldItem);
        class_2960 itemId = itemMappings.get(heldItemId);
        if (itemId != null) {
            return (class_1792)class_7923.field_41178.method_10223(itemId);
        }
        return null;
    }

    @Nullable
    public static class_1792 getMappedItem(class_1799 heldStack) {
        if (heldStack.method_7985() && heldStack.method_7969().method_10545(MAPPED_TRICK_WEAPON)) {
            return (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)heldStack.method_7969().method_10558(MAPPED_TRICK_WEAPON)));
        }
        return TrickWeaponUtil.getMappedItem(heldStack.method_7909());
    }

    @Nullable
    public static class_2561 getMappedItemName(class_1799 heldItem) {
        class_1792 mappedItem = TrickWeaponUtil.getMappedItem(heldItem);
        if (mappedItem != null) {
            return mappedItem.method_7848();
        }
        return null;
    }

    @Nullable
    public static class_1799 getMappedStack(class_1799 heldStack) {
        class_1792 item = TrickWeaponUtil.getMappedItem(heldStack);
        if (item == null) {
            return null;
        }
        class_1799 stack = item.method_7854();
        stack.method_7939(heldStack.method_7947());
        if (heldStack.method_7985()) {
            stack.method_7980(heldStack.method_7969().method_10553());
        }
        stack.method_7948().method_10582(MAPPED_TRICK_WEAPON, class_7923.field_41178.method_10221((Object)heldStack.method_7909()).toString());
        return stack;
    }
}

