/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import org.jetbrains.annotations.Nullable;

public class DraugrBossGoal
extends class_1366 {
    private final DraugrBoss boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int postureBreakTimer;
    private boolean hasPostureBroken;

    public DraugrBossGoal(DraugrBoss boss) {
        super((class_1314)boss, 1.0, false);
        this.boss = boss;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public void reset(float cooldownModifier, boolean shieldUp) {
        this.attackStatus = 0;
        this.attackCooldown = (int)Math.floor((float)ConfigConstructor.old_champions_remains_attack_cooldown_ticks * cooldownModifier / this.boss.method_6032() <= this.boss.method_6063() / 2.0f ? 2.0 : 1.0);
        this.boss.setState(DraugrBoss.States.IDLE);
        this.boss.updateDisableShield(false);
        this.boss.setShielding(shieldUp);
    }

    public boolean applyDamage(class_1309 target, float baseDamage) {
        float modified = baseDamage * ConfigConstructor.old_champions_remains_damage_modifier;
        if (this.boss.method_6059(class_1294.field_5910)) {
            modified += (float)(4 + Objects.requireNonNull(this.boss.method_6112(class_1294.field_5910)).method_5578() * 4);
        }
        return target.method_5643(this.boss.method_37908().method_48963().method_48812((class_1309)this.boss), modified);
    }

    public void method_6270() {
        super.method_6270();
        this.boss.method_19540(false);
        this.boss.updateDisableShield(false);
        this.reset(0.0f, false);
    }

    protected boolean isInMeleeRange(class_1309 target) {
        double distanceToEntity = this.boss.method_5858((class_1297)target);
        return distanceToEntity <= this.method_6289(target) * 2.0;
    }

    protected boolean isTargetRanged(class_1309 target) {
        return ((class_1799)target.method_5877().iterator().next()).method_7909() instanceof class_1811;
    }

    protected boolean isTargetHealing(class_1309 target) {
        class_1799 stack = (class_1799)target.method_5877().iterator().next();
        if (target.method_6115()) {
            switch (stack.method_7976()) {
                case field_8950: 
                case field_8946: {
                    return true;
                }
            }
        }
        return false;
    }

    private void randomAttack(@Nullable DraugrBoss.States specificAttack, class_1309 target, boolean ignoreChecks) {
        block15: {
            double distanceToEntity;
            DraugrBoss.States attack;
            block14: {
                if (target == null || specificAttack == DraugrBoss.States.IDLE) {
                    this.boss.setState(DraugrBoss.States.IDLE);
                    return;
                }
                int rand = this.boss.method_6051().method_43048(DraugrBoss.States.values().length);
                attack = DraugrBoss.States.values()[rand];
                if (specificAttack != null) {
                    attack = specificAttack;
                }
                distanceToEntity = this.boss.method_5858((class_1297)target);
                if (!this.boss.isShielding()) break block14;
                switch (attack) {
                    case COUNTER: 
                    case SHIELD_BASH: 
                    case GROUND_SLAM: 
                    case PARRY: {
                        if (this.isInMeleeRange(target)) {
                            this.boss.setState(attack);
                            break;
                        }
                        break block15;
                    }
                    case SHIELD_VAULT: 
                    case LEAP: {
                        if (distanceToEntity < 100.0 && !this.isInMeleeRange(target) || ignoreChecks) {
                            this.boss.setState(attack);
                            break;
                        }
                        break block15;
                    }
                    default: {
                        this.boss.setState(DraugrBoss.States.IDLE);
                        break;
                    }
                }
                break block15;
            }
            switch (attack) {
                case SWIPES: 
                case HEAVY: {
                    if (!this.isInMeleeRange(target)) break;
                    this.boss.setState(attack);
                    break;
                }
                case BACKSTEP: {
                    if (!this.isTargetRanged(target) && !this.isInMeleeRange(target)) break;
                    this.boss.setState(attack);
                    break;
                }
                case BATTLE_CRY: {
                    if (!(distanceToEntity < 240.0) || this.specialCooldown >= 0) break;
                    this.boss.setState(attack);
                    break;
                }
                case RUN_THRUST: {
                    if (!(distanceToEntity < 100.0 && !this.isInMeleeRange(target)) && !ignoreChecks) break;
                    this.boss.setState(attack);
                    break;
                }
                default: {
                    this.boss.setState(DraugrBoss.States.IDLE);
                }
            }
        }
    }

    public void method_6268() {
        if (this.boss.isSpawning() || this.boss.method_29504()) {
            return;
        }
        --this.attackCooldown;
        --this.specialCooldown;
        --this.postureBreakTimer;
        if (this.postureBreakTimer < -25) {
            this.postureBreakTimer = -5;
        }
        super.method_6268();
        class_1309 target = this.boss.method_5968();
        if (target != null) {
            this.boss.method_19540(true);
            if (this.boss.method_6032() <= this.boss.method_6063() / 2.0f && !this.hasPostureBroken) {
                this.hasPostureBroken = true;
                this.postureBreakTimer = 50;
                this.boss.setPostureBroken(true);
                this.boss.method_6092(new class_1293(class_1294.field_5909, 50, 20));
            }
            if (this.postureBreakTimer < 0) {
                this.boss.setPostureBroken(false);
            }
            if (this.boss.isPostureBroken()) {
                return;
            }
            if (this.isTargetHealing(target) && this.boss.getState().equals((Object)DraugrBoss.States.IDLE) && !this.boss.isPostureBroken()) {
                if (this.boss.isShielding()) {
                    DraugrBoss.States[] leaps = new DraugrBoss.States[]{DraugrBoss.States.LEAP, DraugrBoss.States.SHIELD_VAULT};
                    this.randomAttack(leaps[this.boss.method_6051().method_43048(leaps.length)], target, true);
                } else {
                    this.randomAttack(DraugrBoss.States.RUN_THRUST, target, true);
                }
            }
            if (this.attackCooldown > 0 && !this.boss.isPostureBroken()) {
                this.boss.setState(DraugrBoss.States.IDLE);
            }
            if (this.attackCooldown < 0 && this.boss.getState().equals((Object)DraugrBoss.States.IDLE) && !this.boss.isPostureBroken()) {
                this.randomAttack(null, target, false);
            }
            switch (this.boss.getState()) {
                case COUNTER: {
                    this.singleTarget(target, 30, new int[]{18}, 20.0f, 0.0f, true, true, true);
                    break;
                }
                case SHIELD_BASH: {
                    this.singleTarget(target, 30, new int[]{18}, 10.0f, 4.0f, false, false, true);
                    break;
                }
                case SHIELD_VAULT: {
                    this.leapAttack(target, 10.0f, true);
                    break;
                }
                case SWIPES: {
                    int[] frames = new int[]{10, 18, 26};
                    this.singleTarget(target, 33, frames, 16.0f, 0.0f, false, false, false);
                    break;
                }
                case BACKSTEP: {
                    this.backstep(target);
                    break;
                }
                case HEAVY: {
                    this.heavyBlow(target);
                    break;
                }
                case GROUND_SLAM: {
                    this.aoe(30, 14, 8.0f, 3.0f, new class_1291[0], 4.0, false);
                    break;
                }
                case PARRY: {
                    this.parry(target);
                    break;
                }
                case BATTLE_CRY: {
                    class_1291[] effects = new class_1291[]{class_1294.field_5909, class_1294.field_5911};
                    this.aoe(50, 30, 0.0f, 0.0f, effects, 10.0, true);
                    break;
                }
                case LEAP: {
                    this.leapAttack(target, 18.0f, false);
                    break;
                }
                case RUN_THRUST: {
                    this.runThrust(target);
                    break;
                }
                default: {
                    this.boss.setState(DraugrBoss.States.IDLE);
                }
            }
        }
    }

    private void singleTarget(class_1309 target, int maxTicks, int[] frames, float damage, float knockback, boolean applyBleed, boolean disableShield, boolean shieldUpWhenDone) {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        if (disableShield) {
            this.boss.updateDisableShield(true);
        }
        for (int frame : frames) {
            if (this.attackStatus != frame || !this.isInMeleeRange(target) || !this.applyDamage(target, damage)) continue;
            this.boss.method_37908().method_8396(null, target.method_24515(), class_3417.field_14706, class_3419.field_15251, 1.0f, 1.0f);
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.singleParticle(this.boss.method_37908(), (class_2394)class_2398.field_11227, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
            }
            if (applyBleed) {
                target.method_6092(new class_1293(EffectRegistry.BLEED, 100, 0));
            }
            if (!(knockback > 0.0f)) continue;
            double x = target.method_23317() - this.boss.method_23317();
            double z = target.method_23321() - this.boss.method_23321();
            target.method_6005((double)knockback, -x, -z);
        }
        if (this.attackStatus >= maxTicks) {
            this.reset(1.0f, shieldUpWhenDone);
        }
    }

    private void leapAttack(class_1309 target, float damage, boolean stunTarget) {
        ++this.attackStatus;
        this.boss.updateDisableShield(true);
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        if (this.attackStatus == 18) {
            double e = target.method_23317() - this.boss.method_23317();
            double g = target.method_23321() - this.boss.method_23321();
            this.boss.method_5762(e / 4.0, 0.35, g / 4.0);
        }
        if (this.attackStatus == 26) {
            this.boss.method_37908().method_8396(null, target.method_24515(), class_3417.field_14742, class_3419.field_15251, 1.0f, 1.0f);
            if (this.isInMeleeRange(target) && this.applyDamage(target, damage)) {
                if (stunTarget) {
                    target.method_6092(new class_1293(class_1294.field_5909, 60, 10));
                }
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.particleSphereList(this.boss.method_37908(), 10, target.method_23317(), target.method_23318(), target.method_23321(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
                }
            }
        }
        if (this.attackStatus >= 35) {
            this.reset(0.0f, false);
        }
    }

    private void parry(class_1309 target) {
        int[] frame = new int[]{26};
        this.singleTarget(target, 40, frame, 18.0f, 0.0f, false, true, false);
        if (this.attackStatus == 8 && this.isInMeleeRange(target)) {
            if (!target.method_6059(EffectRegistry.POSTURE_BREAK)) {
                this.boss.method_37908().method_8396(null, target.method_24515(), SoundRegistry.POSTURE_BREAK_EVENT, class_3419.field_15251, 0.5f, 1.0f);
            }
            target.method_6092(new class_1293(EffectRegistry.POSTURE_BREAK, 40, 0));
        }
    }

    private void aoe(int maxTicks, int frame, float damage, float knockback, class_1291[] effects, double boxSize, boolean shieldUpWhenDone) {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        if (effects.length > 0 && (this.attackStatus == 12 || this.attackStatus == 20)) {
            this.boss.method_37908().method_8396(null, this.boss.method_24515(), SoundRegistry.SWORD_HIT_SHIELD_EVENT, class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.attackStatus == frame) {
            if (damage > 0.0f) {
                if (!this.boss.method_37908().field_9236) {
                    ParticleHandler.particleOutburstMap(this.boss.method_37908(), 300, this.boss.method_23317(), this.boss.method_23318(), this.boss.method_23321(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
                this.boss.method_37908().method_8396(null, this.boss.method_24515(), class_3417.field_14742, class_3419.field_15251, 0.8f, 1.0f);
            }
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, this.boss.method_5829().method_1014(boxSize))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                for (class_1291 effect : effects) {
                    living.method_6092(new class_1293(effect, 200, 0));
                }
                if (!(damage > 0.0f)) continue;
                this.applyDamage(living, damage);
                double x = living.method_23317() - this.boss.method_23317();
                double z = living.method_23321() - this.boss.method_23321();
                living.method_6005((double)knockback, -x, -z);
            }
        }
        if (this.attackStatus >= maxTicks) {
            this.reset(2.0f, shieldUpWhenDone);
            if (effects.length > 0) {
                this.specialCooldown = ConfigConstructor.old_champions_remains_special_cooldown_ticks;
            }
        }
    }

    private void backstep(class_1309 target) {
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        if (this.attackStatus == 6) {
            double e = target.method_23317() - this.boss.method_23317();
            double g = target.method_23321() - this.boss.method_23321();
            this.boss.method_5762(-e / 4.0, 0.35, -g / 4.0);
        }
        if (this.attackStatus >= 30) {
            this.reset(0.0f, true);
        }
    }

    private void runThrust(class_1309 target) {
        ++this.attackStatus;
        if (this.attackStatus <= 10) {
            this.boss.method_6092(new class_1293(class_1294.field_5904, 5, 3));
        } else {
            this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        }
        if (this.attackStatus == 13 && this.isInMeleeRange(target) && this.applyDamage(target, 16.0f)) {
            target.method_6092(new class_1293(EffectRegistry.BLEED, 100, 0));
            this.boss.method_37908().method_8396(null, target.method_24515(), class_3417.field_14706, class_3419.field_15251, 1.0f, 1.0f);
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.singleParticle(this.boss.method_37908(), (class_2394)class_2398.field_11227, target.method_23317(), target.method_23320(), target.method_23321(), 0.0, 0.0, 0.0);
            }
        }
        if (this.attackStatus >= 23) {
            this.reset(1.0f, false);
        }
    }

    private void heavyBlow(class_1309 target) {
        class_2338 pos;
        ++this.attackStatus;
        this.boss.method_6092(new class_1293(class_1294.field_5909, 5, 20, false, true));
        if (this.attackStatus == 1 && target.method_24515() != null) {
            this.boss.setTargetPos(target.method_24515());
        }
        if ((pos = this.boss.getTargetPos()) != null && DraugrBossGoal.isPosNotNullish(pos)) {
            this.boss.method_5988().method_20248((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        }
        if (this.attackStatus == 24 && pos != null && DraugrBossGoal.isPosNotNullish(pos)) {
            this.boss.method_37908().method_8396(null, pos, class_3417.field_15236, class_3419.field_15251, 1.0f, 1.0f);
            if (!this.boss.method_37908().field_9236) {
                ParticleHandler.particleSphereList(this.boss.method_37908(), 100, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
            }
            for (class_1297 entity : this.boss.method_37908().method_8335((class_1297)this.boss, new class_238(pos).method_1014(1.0))) {
                if (!(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                this.applyDamage(living, 25.0f);
                living.method_6092(new class_1293(class_1294.field_5909, 80, 1));
            }
        }
        if (this.attackStatus >= 40) {
            this.reset(1.0f, false);
        }
    }

    public static boolean isPosNotNullish(class_2338 pos) {
        return pos.method_10263() != 0 || pos.method_10264() != 0 || pos.method_10260() != 0;
    }

    protected void method_6288(class_1309 target, double squaredDistance) {
    }
}

