/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8111;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.ChaosMonarchGoal;
import net.soulsweaponry.entity.mobs.AccursedLordBoss;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.items.armor.ChaosSet;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChaosMonarch
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private static final class_2940<Integer> ATTACK = class_2945.method_12791(ChaosMonarch.class, (class_2941)class_2943.field_13327);

    public ChaosMonarch(class_1299<? extends BossEntity> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5783);
    }

    private PlayState predicate(AnimationState<?> state) {
        switch (this.getAttack().ordinal()) {
            case 1: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("spawn"));
                break;
            }
            case 2: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("teleport"));
                break;
            }
            case 3: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("swing_staff"));
                break;
            }
            case 4: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("lightning_call"));
                break;
            }
            case 5: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("shoot"));
                break;
            }
            case 6: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("barrage"));
                break;
            }
            case 7: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("death"));
                break;
            }
            default: {
                state.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
            }
        }
        return PlayState.CONTINUE;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new ChaosMonarchGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, AccursedLordBoss.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 60.0).method_26868(class_5134.field_23716, ConfigConstructor.chaos_monarch_health).method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23722, 2.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACK, (Object)0);
    }

    @Override
    public int getTicksUntilDeath() {
        return 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttack(7);
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11237, class_2398.field_11216, ParticleRegistry.PURPLE_FLAME});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.getAttack() == Attack.SPAWN) {
            ++this.spawnTicks;
            class_2400[] dragonParticles = new class_2400[]{class_2398.field_11216, class_2398.field_11216};
            class_2400[] portalParticles = new class_2400[]{class_2398.field_11214};
            if (this.spawnTicks % 2 == 0 && this.spawnTicks < 20) {
                this.particleExplosion(portalParticles, 4.0f);
            }
            if (this.spawnTicks == 40) {
                this.particleExplosion(dragonParticles, 0.5f);
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_15136, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.spawnTicks >= 60) {
                this.setAttack(0);
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source == this.method_37908().method_48963().method_48809()) {
            return false;
        }
        if (source.method_49708(class_8111.field_42350)) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public int getXp() {
        return ConfigConstructor.chaos_monarch_xp;
    }

    @Override
    protected void method_5958() {
        super.method_5958();
        if (this.method_6059(EffectRegistry.DECAY) && this.field_6012 % 10 == 0) {
            this.method_6025(this.method_6112(EffectRegistry.DECAY).method_5578() + 1 + this.getAttackingPlayers().size());
            for (class_1309 target : this.method_37908().method_18467(class_1309.class, this.method_5829().method_1014(3.0))) {
                if (target instanceof class_1657 || target == this) continue;
                target.method_6092(new class_1293(class_1294.field_5920, 80, 3));
            }
        }
        if (this.method_6059(class_1294.field_5902)) {
            this.method_6016(class_1294.field_5902);
        }
        if (this.method_6059(class_1294.field_5920)) {
            this.method_6016(class_1294.field_5920);
        }
        if (ConfigConstructor.chaos_monarch_wither_ground) {
            this.turnBlocks(this.method_37908(), this.method_24515());
        }
    }

    @Override
    public class_3414 getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    private void turnBlocks(class_1937 world, class_2338 blockPos) {
        ChaosSet cape = (ChaosSet)ItemRegistry.CHAOS_ROBES;
        cape.turnBlocks((class_1309)this, world, blockPos, 3);
    }

    private void particleExplosion(class_2400[] particles, float sizeModifier) {
        this.roundParticleOutburst(this.method_37908(), 1000.0, particles, this.method_23317(), this.method_23318() + 3.0, this.method_23321(), sizeModifier);
    }

    public void roundParticleOutburst(class_1937 world, double points, class_2400[] particles, double x, double y, double z, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            for (class_2400 particle : particles) {
                world.method_8466((class_2394)particle, true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            }
            ++i;
        }
    }

    public void setAttack(int attackId) {
        this.field_6011.method_12778(ATTACK, (Object)attackId);
    }

    public Attack getAttack() {
        return Attack.values()[(Integer)this.field_6011.method_12789(ATTACK)];
    }

    public class_243 getRotationVec(float pitch, float yaw) {
        float f = pitch * ((float)Math.PI / 180);
        float g = -yaw * ((float)Math.PI / 180);
        float h = class_3532.method_15362((float)g);
        float i = class_3532.method_15374((float)g);
        float j = class_3532.method_15362((float)f);
        float k = class_3532.method_15374((float)f);
        return new class_243((double)(i * j), (double)(-k), (double)(h * j));
    }

    @Override
    public boolean method_42149() {
        return ConfigConstructor.chaos_monarch_disables_shields;
    }

    @Override
    public boolean method_5753() {
        return ConfigConstructor.chaos_monarch_is_fire_immune;
    }

    @Override
    public boolean method_5999() {
        return ConfigConstructor.chaos_monarch_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.chaos_monarch_group_type;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15163;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14688;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15136;
    }

    public static enum Attack {
        IDLE,
        SPAWN,
        TELEPORT,
        MELEE,
        LIGHTNING,
        SHOOT,
        BARRAGE,
        DEATH;

    }
}

