/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DayStalkerGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DayStalker
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    public int phaseTwoTicks;
    public int spawnTicks;
    public int phaseTwoMaxTransitionTicks = 120;
    public int maxSpawnTicks = 50;
    public int flightTimer = 0;
    public static final int ATTACKS_LENGTH = Attacks.values().length;
    private static final class_2940<Integer> ATTACKS = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> INITIATING_PHASE_2 = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_PHASE_2 = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_FLYING = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> PARTNER_UUID = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> REMAINING_ANI_TICKS = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> CHASE_TARGET = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WAIT_ANIMATION = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SPAWN_PARTICLES_STATE = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> FLAMETHROWER_TARGET = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Float> FLAMES_EDGE_RADIUS = class_2945.method_12791(DayStalker.class, (class_2941)class_2943.field_13320);

    public DayStalker(class_1299<? extends DayStalker> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5782);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new DayStalkerGoal(this, 0.75, true));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true, entity -> !this.isPartner((class_1309)entity)));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
    }

    public void setAttackAnimation(Attacks attack) {
        for (int i = 0; i < ATTACKS_LENGTH; ++i) {
            if (!Attacks.values()[i].equals((Object)attack)) continue;
            this.field_6011.method_12778(ATTACKS, (Object)i);
        }
    }

    public Attacks getAttackAnimation() {
        return Attacks.values()[(Integer)this.field_6011.method_12789(ATTACKS)];
    }

    public boolean isInitiatingPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(INITIATING_PHASE_2);
    }

    public void setInitiatePhaseTwo(boolean bl) {
        this.field_6011.method_12778(INITIATING_PHASE_2, (Object)bl);
    }

    private PlayState chains(AnimationState<?> state) {
        if (!this.isInitiatingPhaseTwo() && this.isPhaseTwo()) {
            if (this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                return PlayState.STOP;
            }
            state.getController().setAnimation(RawAnimation.begin().then("idle_chains_2", Animation.LoopType.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private PlayState idles(AnimationState<?> state) {
        if (this.method_29504() || this.getAttackAnimation().equals((Object)Attacks.DEATH) || this.getDeathTicks() > 0) {
            if (this.isPhaseTwo()) {
                state.getController().setAnimation(RawAnimation.begin().then("death_2", Animation.LoopType.LOOP));
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("death_1", Animation.LoopType.LOOP));
            }
        } else if (!this.isInitiatingPhaseTwo()) {
            if (this.isPhaseTwo()) {
                if (!this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_2", Animation.LoopType.LOOP));
                } else {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_flames_reach_2", Animation.LoopType.LOOP));
                }
            } else if (!this.getAttackAnimation().equals((Object)Attacks.FLAMES_REACH)) {
                if (this.isFlying()) {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_flying_1", Animation.LoopType.LOOP));
                } else {
                    state.getController().setAnimation(RawAnimation.begin().then("idle_1", Animation.LoopType.LOOP));
                }
            } else {
                state.getController().setAnimation(RawAnimation.begin().then("idle_flames_reach_1", Animation.LoopType.LOOP));
            }
        }
        return PlayState.CONTINUE;
    }

    private PlayState attacks(AnimationState<?> state) {
        if (this.method_29504()) {
            return PlayState.STOP;
        }
        if (this.isInitiatingPhaseTwo()) {
            state.getController().setAnimation(RawAnimation.begin().then("start_phase_2", Animation.LoopType.PLAY_ONCE));
        } else if (this.getAttackAnimation().equals((Object)Attacks.SPAWN)) {
            state.getController().setAnimation(RawAnimation.begin().then("spawn_1", Animation.LoopType.PLAY_ONCE));
        } else if (!this.isPhaseTwo()) {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("air_combustion_1", Animation.LoopType.LOOP));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().then("decimate_1", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("dawnbreaker_1", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("chaos_storm_1", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("flamethrower_1", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("sunfire_rush_1", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("conflagration_1", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_edge_1", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_reach_1", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_1", Animation.LoopType.LOOP));
                    break;
                }
            }
        } else {
            switch (this.getAttackAnimation().ordinal()) {
                case 3: {
                    state.getController().setAnimation(RawAnimation.begin().then("air_combustion_2", Animation.LoopType.LOOP));
                    break;
                }
                case 4: {
                    state.getController().setAnimation(RawAnimation.begin().then("decimate_2", Animation.LoopType.LOOP));
                    break;
                }
                case 5: {
                    state.getController().setAnimation(RawAnimation.begin().then("dawnbreaker_2", Animation.LoopType.LOOP));
                    break;
                }
                case 6: {
                    state.getController().setAnimation(RawAnimation.begin().then("chaos_storm_2", Animation.LoopType.LOOP));
                    break;
                }
                case 7: {
                    state.getController().setAnimation(RawAnimation.begin().then("flamethrower_2", Animation.LoopType.LOOP));
                    break;
                }
                case 8: {
                    state.getController().setAnimation(RawAnimation.begin().then("sunfire_rush_2", Animation.LoopType.LOOP));
                    break;
                }
                case 9: {
                    state.getController().setAnimation(RawAnimation.begin().then("conflagration_2", Animation.LoopType.LOOP));
                    break;
                }
                case 10: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_edge_2", Animation.LoopType.LOOP));
                    break;
                }
                case 11: {
                    state.getController().setAnimation(RawAnimation.begin().then("radiance_2", Animation.LoopType.LOOP));
                    break;
                }
                case 12: {
                    state.getController().setAnimation(RawAnimation.begin().then("warmth_2", Animation.LoopType.LOOP));
                    break;
                }
                case 13: {
                    state.getController().setAnimation(RawAnimation.begin().then("overheat_2", Animation.LoopType.LOOP));
                    break;
                }
                case 14: {
                    state.getController().setAnimation(RawAnimation.begin().then("inferno_2", Animation.LoopType.LOOP));
                    break;
                }
                case 15: {
                    state.getController().setAnimation(RawAnimation.begin().then("flames_reach_2", Animation.LoopType.LOOP));
                    break;
                }
                case 17: {
                    state.getController().setAnimation(RawAnimation.begin().then("sky_high_2", Animation.LoopType.LOOP));
                    break;
                }
                default: {
                    state.getController().setAnimation(RawAnimation.begin().then("empty_2", Animation.LoopType.LOOP));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks == this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.DAWNBREAKER_EVENT, new class_2394[]{class_2398.field_11240, class_2398.field_11237});
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    protected class_3414 method_6002() {
        return this.isPhaseTwo() ? SoundRegistry.HARD_BOSS_DEATH_LONG : SoundRegistry.HARD_BOSS_DEATH_SHORT;
    }

    @Override
    public int getTicksUntilDeath() {
        return this.isPhaseTwo() ? 140 : 80;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void setDeath() {
        this.setAttackAnimation(Attacks.DEATH);
    }

    @Override
    public boolean method_5753() {
        return ConfigConstructor.day_stalker_is_fire_immune;
    }

    @Override
    public boolean method_5999() {
        return ConfigConstructor.day_stalker_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.day_stalker_group_type;
    }

    @Override
    public boolean method_42149() {
        return ConfigConstructor.day_stalker_disables_shields;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idles", 0, this::idles)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacks", 0, this::attacks)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "chains", 0, this::chains)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ATTACKS, (Object)0);
        this.field_6011.method_12784(INITIATING_PHASE_2, (Object)false);
        this.field_6011.method_12784(IS_PHASE_2, (Object)false);
        this.field_6011.method_12784(PARTNER_UUID, Optional.empty());
        this.field_6011.method_12784(REMAINING_ANI_TICKS, (Object)0);
        this.field_6011.method_12784(IS_FLYING, (Object)false);
        this.field_6011.method_12784(TARGET_POS, (Object)new class_2338(0, 0, 0));
        this.field_6011.method_12784(CHASE_TARGET, (Object)true);
        this.field_6011.method_12784(WAIT_ANIMATION, (Object)false);
        this.field_6011.method_12784(SPAWN_PARTICLES_STATE, (Object)0);
        this.field_6011.method_12784(FLAMETHROWER_TARGET, (Object)new class_2338(0, 0, 0));
        this.field_6011.method_12784(FLAMES_EDGE_RADIUS, (Object)Float.valueOf(2.0f));
    }

    @Nullable
    public NightProwler getPartner(class_3218 world) {
        return (NightProwler)world.method_14190(this.getPartnerUuid());
    }

    public UUID getPartnerUuid() {
        return ((Optional)this.field_6011.method_12789(PARTNER_UUID)).orElse(null);
    }

    public void setPartnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(PARTNER_UUID, Optional.ofNullable(uuid));
    }

    public boolean isPartner(class_1309 living) {
        return this.getPartnerUuid() != null && living.method_5667() != null && this.getPartnerUuid().equals(living.method_5667());
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 120.0).method_26868(class_5134.field_23716, ConfigConstructor.day_stalker_health).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23718, 10.0).method_26868(class_5134.field_23724, 10.0).method_26868(class_5134.field_23720, 0.8);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.getPartnerUuid() != null) {
            nbt.method_25927("partner_uuid", this.getPartnerUuid());
        }
        nbt.method_10556("phase_two", this.isPhaseTwo());
        nbt.method_10569("remaining_ani_ticks", this.getRemainingAniTicks());
        nbt.method_10556("is_flying", this.isFlying());
        nbt.method_10556("chase_target", this.shouldChaseTarget());
        nbt.method_10569("flight_timer", this.flightTimer);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        UUID uUID = null;
        if (nbt.method_25928("partner_uuid")) {
            uUID = nbt.method_25926("partner_uuid");
        }
        if (uUID != null) {
            try {
                this.setPartnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (nbt.method_10545("phase_two")) {
            this.setPhaseTwo(nbt.method_10577("phase_two"));
        }
        if (nbt.method_10545("remaining_ani_ticks")) {
            this.setRemainingAniTicks(nbt.method_10550("remaining_ani_ticks"));
        }
        if (nbt.method_10545("is_flying")) {
            this.setFlying(nbt.method_10577("is_flying"));
        }
        if (nbt.method_10545("chase_target")) {
            this.setChaseTarget(nbt.method_10577("chase_target"));
        }
        if (nbt.method_10545("flight_timer")) {
            this.flightTimer = nbt.method_10550("flight_timer");
        }
    }

    public boolean isEmpowered() {
        return !this.method_37908().field_9236 && this.method_37908().method_8530() || this.isPhaseTwo();
    }

    @Override
    public int getXp() {
        return ConfigConstructor.day_stalker_xp;
    }

    @Override
    protected void method_5958() {
        NightProwler partner;
        super.method_5958();
        if (!this.method_37908().field_9236) {
            partner = this.getPartner((class_3218)this.method_37908());
            if (!this.isPhaseTwo() && (partner == null || partner.method_29504())) {
                this.method_6012();
                this.setInitiatePhaseTwo(true);
                this.setFlying(false);
            }
        }
        if (this.isEmpowered()) {
            if (this.isPhaseTwo() && this.method_6032() < this.method_6063() && this.field_6012 % 10 == 0) {
                this.method_6025(1.0f);
            }
            this.method_6092(new class_1293(class_1294.field_5907, 40, 1, false, false));
        }
        if (this.isInitiatingPhaseTwo()) {
            ++this.phaseTwoTicks;
            this.setFlying(false);
            int maxHealTicks = this.phaseTwoMaxTransitionTicks - 40;
            float healPerTick = this.method_6063() / (float)maxHealTicks;
            this.method_6025(healPerTick);
            if (this.phaseTwoTicks == 76) {
                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.DAY_STALKER_RADIANCE, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.phaseTwoTicks == 81) {
                if (!this.method_37908().field_9236) {
                    ParticleHandler.particleSphereList(this.method_37908(), 1000, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, new class_2394[]{class_2398.field_11240, class_2398.field_11237});
                }
                DayStalkerGoal placeHolder = new DayStalkerGoal(this, 1.0, true);
                placeHolder.aoe(4.0, 50.0f, 4.0f);
            }
            if (this.phaseTwoTicks >= this.phaseTwoMaxTransitionTicks) {
                this.setPhaseTwo(true);
                this.setInitiatePhaseTwo(false);
            }
        }
        if (this.getAttackAnimation().equals((Object)Attacks.SPAWN)) {
            ++this.spawnTicks;
            if (this.spawnTicks >= this.maxSpawnTicks) {
                this.setAttackAnimation(Attacks.IDLE);
                if (!this.method_37908().field_9236 && (partner = this.getPartner((class_3218)this.method_37908())) != null) {
                    boolean bl = this.method_6051().method_43056();
                    this.setFlying(bl);
                    partner.setFlying(!bl);
                }
            }
        }
        this.setRemainingAniTicks(Math.max(this.getRemainingAniTicks() - 1, 0));
        if (this.getRemainingAniTicks() <= 0 && this.shouldWaitAnimation()) {
            this.setWaitAnimation(false);
            this.setAttackAnimation(Attacks.IDLE);
        }
    }

    @Override
    public class_3414 getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    public void method_6007() {
        super.method_6007();
        if (this.getParticleState() == 1 && this.method_37908().field_9236) {
            class_243 pos = this.getFlamethrowerTarget().method_46558();
            double e = pos.method_10216() - this.method_23317();
            double f = pos.method_10214() + 1.0 - this.method_23323(1.0);
            double g = pos.method_10215() - this.method_23321();
            double distance = this.method_5707(pos);
            double h = Math.sqrt(Math.sqrt(distance)) * 0.5;
            for (int i = 0; i < 50; ++i) {
                double velX = e + this.method_6051().method_43059() / 2.0 * h;
                double velY = f + this.method_6051().method_43059() / 2.0 * h;
                double velZ = g + this.method_6051().method_43059() / 2.0 * h;
                this.method_37908().method_8406((class_2394)class_2398.field_11240, this.method_23317(), this.method_23320(), this.method_23321(), velX / 10.0, velY / 10.0, velZ / 10.0);
            }
        }
        if (this.getAttackAnimation().equals((Object)Attacks.FLAMES_EDGE)) {
            float r = this.getFlamesEdgeRadius();
            for (int theta = 0; theta < 360; theta += this.isPhaseTwo() ? 4 : 8) {
                double x0 = this.method_23317();
                double z0 = this.method_23321();
                double x = x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
                if (this.getParticleState() == 2 && this.field_6012 % 8 == 0) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11240, x, this.method_23323(0.5), z, 0.0, 0.0, 0.0);
                    continue;
                }
                if (this.getParticleState() != 3) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_22246, x, this.method_23323(0.5), z, this.field_5974.method_43059() / 8.0, this.field_5974.method_43059() / 8.0, this.field_5974.method_43059() / 8.0);
                this.method_37908().method_8406((class_2394)class_2398.field_11237, x, this.method_23323(0.5), z, 0.0, (double)0.2f, 0.0);
            }
        }
    }

    public void setParticleState(int type) {
        this.field_6011.method_12778(SPAWN_PARTICLES_STATE, (Object)type);
    }

    public int getParticleState() {
        return (Integer)this.field_6011.method_12789(SPAWN_PARTICLES_STATE);
    }

    public void setFlamethrowerTarget(class_2338 pos) {
        this.field_6011.method_12778(FLAMETHROWER_TARGET, (Object)pos);
    }

    public class_2338 getFlamethrowerTarget() {
        return (class_2338)this.field_6011.method_12789(FLAMETHROWER_TARGET);
    }

    public void setRemainingAniTicks(int ticks) {
        this.field_6011.method_12778(REMAINING_ANI_TICKS, (Object)ticks);
    }

    public int getRemainingAniTicks() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANI_TICKS);
    }

    public void setPhaseTwo(boolean bl) {
        this.field_6011.method_12778(IS_PHASE_2, (Object)bl);
    }

    public boolean isPhaseTwo() {
        return (Boolean)this.field_6011.method_12789(IS_PHASE_2);
    }

    public void setFlying(boolean bl) {
        this.field_6011.method_12778(IS_FLYING, (Object)bl);
    }

    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(IS_FLYING);
    }

    public void setTargetPos(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    public class_2338 getTargetPos() {
        return (class_2338)this.field_6011.method_12789(TARGET_POS);
    }

    public void setChaseTarget(boolean bl) {
        this.field_6011.method_12778(CHASE_TARGET, (Object)bl);
    }

    public boolean shouldChaseTarget() {
        return (Boolean)this.field_6011.method_12789(CHASE_TARGET);
    }

    public void setWaitAnimation(boolean bl) {
        this.field_6011.method_12778(WAIT_ANIMATION, (Object)bl);
    }

    public boolean shouldWaitAnimation() {
        return (Boolean)this.field_6011.method_12789(WAIT_ANIMATION);
    }

    public void setFlamesEdgeRadius(float radius) {
        this.field_6011.method_12778(FLAMES_EDGE_RADIUS, (Object)Float.valueOf(radius));
    }

    public float getFlamesEdgeRadius() {
        return ((Float)this.field_6011.method_12789(FLAMES_EDGE_RADIUS)).floatValue();
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.isInitiatingPhaseTwo()) {
            return false;
        }
        if (source.method_49708(class_8111.field_42345)) {
            return false;
        }
        if (this.getAttackAnimation().equals((Object)Attacks.OVERHEAT)) {
            amount *= 0.6f;
        }
        if (this.isEmpowered() && source.method_48789(class_8103.field_42247) && !this.isFlying()) {
            amount *= this.isPhaseTwo() ? ConfigConstructor.day_stalker_empowered_projectile_damage_taken_modifier_phase_2 : ConfigConstructor.day_stalker_empowered_projectile_damage_taken_modifier_phase_1;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_5740() {
        return this.isFlying();
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
        if (!this.isFlying()) {
            super.method_5623(heightDifference, onGround, state, landedPosition);
        }
    }

    public boolean method_6101() {
        return !this.isFlying() && super.method_6101();
    }

    protected boolean method_27071() {
        return this.isPhaseTwo();
    }

    public static enum Attacks {
        IDLE,
        DEATH,
        SPAWN,
        AIR_COMBUSTION,
        DECIMATE,
        DAWNBREAKER,
        CHAOS_STORM,
        FLAMETHROWER,
        SUNFIRE_RUSH,
        CONFLAGRATION,
        FLAMES_EDGE,
        RADIANCE,
        WARMTH,
        OVERHEAT,
        INFERNO,
        FLAMES_REACH,
        BLAZE_BARRAGE,
        SKY_HIGH;

    }
}

