/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Objects;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.ai.goal.DraugrBossGoal;
import net.soulsweaponry.entity.mobs.BossEntity;
import net.soulsweaponry.entity.mobs.NightShade;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DraugrBoss
extends BossEntity
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    public int deathTicks;
    private int spawnTicks;
    private boolean shouldDisableShield = false;
    private String weaponDamagedById = "none";
    private static final String LAST_WEAPON_DAMAGED_BY = "last_weapon_damaged_by";
    private static final class_2940<Boolean> IS_SHIELDING = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> POSTURE_BROKEN = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> STATES = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2338> POS = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Integer> SAME_WEAPON_COUNT = class_2945.method_12791(DraugrBoss.class, (class_2941)class_2943.field_13327);

    public DraugrBoss(class_1299<? extends DraugrBoss> entityType, class_1937 world) {
        super(entityType, world, class_1259.class_1260.field_5786);
    }

    private PlayState attackAnimations(AnimationState<?> event) {
        if (this.isPostureBroken()) {
            event.getController().setAnimation(RawAnimation.begin().then("posture_break", Animation.LoopType.HOLD_ON_LAST_FRAME));
        } else {
            switch (this.getState().ordinal()) {
                case 0: {
                    if (this.isShielding()) {
                        if (event.isMoving()) {
                            event.getController().setAnimation(RawAnimation.begin().then("block_stance", Animation.LoopType.LOOP));
                            break;
                        }
                        event.getController().setAnimation(RawAnimation.begin().then("idle_block", Animation.LoopType.LOOP));
                        break;
                    }
                    if (event.isMoving()) {
                        event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
                        break;
                    }
                    event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
                    break;
                }
                case 1: {
                    event.getController().setAnimation(RawAnimation.begin().then("spawn", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(RawAnimation.begin().then("death", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(RawAnimation.begin().then("counter", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(RawAnimation.begin().then("shield_bash", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 5: {
                    event.getController().setAnimation(RawAnimation.begin().then("shield_vault", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 6: {
                    event.getController().setAnimation(RawAnimation.begin().then("swipes", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 7: {
                    event.getController().setAnimation(RawAnimation.begin().then("backstep_block", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 8: {
                    event.getController().setAnimation(RawAnimation.begin().then("charged_attack", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 9: {
                    event.getController().setAnimation(RawAnimation.begin().then("ground_slam", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 10: {
                    event.getController().setAnimation(RawAnimation.begin().then("parry", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 11: {
                    event.getController().setAnimation(RawAnimation.begin().then("battle_cry", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 12: {
                    event.getController().setAnimation(RawAnimation.begin().then("sword_leap", Animation.LoopType.HOLD_ON_LAST_FRAME));
                    break;
                }
                case 13: {
                    event.getController().setAnimation(RawAnimation.begin().then("thrust_run", Animation.LoopType.HOLD_ON_LAST_FRAME));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    public static class_5132.class_5133 createBossAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23717, 60.0).method_26868(class_5134.field_23716, ConfigConstructor.old_champions_remains_health).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23718, 1.0).method_26868(class_5134.field_23724, 5.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IS_SHIELDING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(POSTURE_BROKEN, (Object)Boolean.FALSE);
        this.field_6011.method_12784(STATES, (Object)0);
        this.field_6011.method_12784(SAME_WEAPON_COUNT, (Object)0);
        this.field_6011.method_12784(POS, (Object)new class_2338(0, 0, 0));
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new DraugrBossGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(5, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        super.method_5959();
    }

    public void setShielding(boolean bl) {
        this.field_6011.method_12778(IS_SHIELDING, (Object)bl);
    }

    public boolean isShielding() {
        return (Boolean)this.field_6011.method_12789(IS_SHIELDING);
    }

    public void setPostureBroken(boolean bl) {
        this.field_6011.method_12778(POSTURE_BROKEN, (Object)bl);
    }

    public boolean isPostureBroken() {
        return (Boolean)this.field_6011.method_12789(POSTURE_BROKEN);
    }

    private void setSameWeaponCount(int amount) {
        this.field_6011.method_12778(SAME_WEAPON_COUNT, (Object)amount);
    }

    private void addSameWeaponCount() {
        this.setSameWeaponCount(this.getSameWeaponCount() + 1);
    }

    private int getSameWeaponCount() {
        return (Integer)this.field_6011.method_12789(SAME_WEAPON_COUNT);
    }

    public void setTargetPos(class_2338 pos) {
        this.field_6011.method_12778(POS, (Object)pos);
    }

    public class_2338 getTargetPos() {
        return (class_2338)this.field_6011.method_12789(POS);
    }

    public void setState(States attack) {
        for (int i = 0; i < States.values().length; ++i) {
            if (!States.values()[i].equals((Object)attack)) continue;
            this.field_6011.method_12778(STATES, (Object)i);
        }
    }

    public States getState() {
        return States.values()[(Integer)this.field_6011.method_12789(STATES)];
    }

    public void setSpawning() {
        this.setState(States.SPAWN);
    }

    public boolean isSpawning() {
        return this.getState().equals((Object)States.SPAWN);
    }

    public void method_6007() {
        int i;
        super.method_6007();
        if (this.isSpawning()) {
            ++this.spawnTicks;
            this.method_6092(new class_1293(class_1294.field_5909, 10, 50));
            for (i = 0; i < 30; ++i) {
                class_5819 random = this.method_6051();
                class_2338 pos = this.method_24515();
                double d = random.method_43059() * 0.05;
                double e = random.method_43059() * 0.05;
                double newX = random.method_43058() - 0.5 + random.method_43059() * 0.15 + d;
                double newZ = random.method_43058() - 0.5 + random.method_43059() * 0.15 + e;
                double newY = random.method_43058() - 0.5 + random.method_43058() * 0.5;
                this.method_37908().method_8406((class_2394)class_2398.field_23114, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), newX / 2.0, newY / 8.0, newZ / 2.0);
                this.method_37908().method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), newX / 2.0, newY / 8.0, newZ / 2.0);
            }
            if (this.spawnTicks % 10 == 0 && this.spawnTicks < 40) {
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14742, class_3419.field_15251, 1.0f, 1.0f);
            }
            if (this.spawnTicks == 48 || this.spawnTicks == 55) {
                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.SWORD_HIT_SHIELD_EVENT, class_3419.field_15251, 1.0f, 1.0f);
                for (class_1297 entity : this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(10.0))) {
                    if (!(entity instanceof class_1309)) continue;
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5909, 200, 0));
                    ((class_1309)entity).method_6092(new class_1293(class_1294.field_5911, 200, 0));
                }
            }
            if (this.spawnTicks >= 70) {
                this.setState(States.IDLE);
            }
        }
        if (this.method_6032() <= this.method_6063() / 2.0f) {
            this.method_6092(new class_1293(class_1294.field_5904, 10, 0));
            this.method_6092(new class_1293(class_1294.field_5910, 10, 1));
            for (i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_11237, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        } else if (this.method_37908().method_8311(this.method_24515())) {
            this.method_6092(new class_1293(class_1294.field_5909, 10, 1));
            this.method_6092(new class_1293(class_1294.field_5911, 10, 1));
            for (i = 0; i < 2; ++i) {
                this.method_37908().method_8406((class_2394)class_2398.field_28013, this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
        if (this.isShielding()) {
            this.method_6092(new class_1293(class_1294.field_5907, 20, 1));
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            String item = attacker.method_6047().method_7922();
            if (Objects.equals(this.weaponDamagedById, item)) {
                this.addSameWeaponCount();
            } else {
                this.setSameWeaponCount(0);
            }
            if (this.getSameWeaponCount() >= ConfigConstructor.old_champions_remains_hits_before_growing_resistant) {
                double x = this.getSameWeaponCount() - (ConfigConstructor.old_champions_remains_hits_before_growing_resistant - this.getSameWeaponCount() > 0 ? 1 : 0);
                amount = (float)((double)amount * Math.pow(0.9345793724060059, x));
            }
            this.weaponDamagedById = item;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582(LAST_WEAPON_DAMAGED_BY, this.weaponDamagedById);
    }

    @Override
    public int getXp() {
        return ConfigConstructor.old_champions_remains_xp;
    }

    @Override
    public class_3414 getBossMusic() {
        return null;
    }

    @Override
    public boolean hasBossMusic() {
        return false;
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545(LAST_WEAPON_DAMAGED_BY)) {
            this.weaponDamagedById = nbt.method_10558(LAST_WEAPON_DAMAGED_BY);
        }
    }

    @Override
    public boolean method_5999() {
        return ConfigConstructor.old_champions_remains_is_undead;
    }

    @Override
    public String getGroupId() {
        return ConfigConstructor.old_champions_remains_group_type;
    }

    @Override
    public boolean method_5753() {
        return ConfigConstructor.old_champions_remains_is_fire_immune;
    }

    @Override
    public int getTicksUntilDeath() {
        return 20;
    }

    @Override
    public int getDeathTicks() {
        return this.deathTicks;
    }

    @Override
    public void method_6078(class_1282 source) {
        super.method_6078(source);
        this.setState(States.DEATH);
        CustomDeathHandler.deathExplosionEvent(this.method_37908(), this.method_19538(), SoundRegistry.NIGHTFALL_SPAWN_EVENT, new class_2394[]{class_2398.field_11237, class_2398.field_22246, ParticleRegistry.BLACK_FLAME});
        NightShade entity = new NightShade(EntityRegistry.NIGHT_SHADE, this.method_37908());
        entity.method_23327(this.method_23317(), this.method_23318() + (double)0.1f, this.method_23321());
        entity.method_18800(0.0, 0.1f, 0.0);
        entity.setSpawn();
        this.method_37908().method_8649((class_1297)entity);
    }

    @Override
    public void setDeath() {
    }

    @Override
    public void method_6108() {
        ++this.deathTicks;
        if (this.deathTicks >= this.getTicksUntilDeath() && !this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    @Override
    public boolean method_42149() {
        return ConfigConstructor.old_champions_remains_disables_shields && this.shouldDisableShield || ConfigConstructor.old_champions_remains_disables_shields_all_attacks;
    }

    public void updateDisableShield(boolean bl) {
        this.shouldDisableShield = bl;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 0, this::attackAnimations)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15214;
    }

    protected class_3414 method_6011(class_1282 source) {
        if (this.getSameWeaponCount() >= ConfigConstructor.old_champions_remains_hits_before_growing_resistant) {
            return class_3417.field_14670;
        }
        return class_3417.field_15027;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15122;
    }

    public static enum States {
        IDLE,
        SPAWN,
        DEATH,
        COUNTER,
        SHIELD_BASH,
        SHIELD_VAULT,
        SWIPES,
        BACKSTEP,
        HEAVY,
        GROUND_SLAM,
        PARRY,
        BATTLE_CRY,
        LEAP,
        RUN_THRUST;

    }
}

