/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoonlightProjectile
extends NonArrowProjectile
implements GeoEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Integer> EXPLOSION_PARTICLE_COUNT = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TRAIL_PARTICLE_COUNT = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AREA_PARTICLE_COUNT = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MAX_AGE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> EXPLOSION_EXPANSION = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> MODEL_ROTATION = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2394> EXPLOSION_PARTICLE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<class_2394> TRAIL_PARTICLE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<class_2394> AREA_PARTICLE = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13314);
    private static final class_2940<Integer> EFFECT_TICKS = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> EFFECT_AMPLIFIER = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13327);
    private static final class_2940<String> APPLIED_EFFECT_ID = class_2945.method_12791(MoonlightProjectile.class, (class_2941)class_2943.field_13326);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public MoonlightProjectile(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public MoonlightProjectile(class_1299<? extends class_1665> type, class_1937 world, class_1309 owner, class_1799 stack) {
        super(type, owner, world, stack);
    }

    public MoonlightProjectile(class_1299<? extends class_1665> type, class_1937 world, class_1309 owner) {
        super(type, owner, world, WeaponRegistry.MOONLIGHT_GREATSWORD.method_7854());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(EXPLOSION_PARTICLE_COUNT, (Object)75);
        this.field_6011.method_12784(TRAIL_PARTICLE_COUNT, (Object)4);
        this.field_6011.method_12784(AREA_PARTICLE_COUNT, (Object)0);
        this.field_6011.method_12784(MAX_AGE, (Object)30);
        this.field_6011.method_12784(EXPLOSION_EXPANSION, (Object)Float.valueOf(0.125f));
        this.field_6011.method_12784(MODEL_ROTATION, (Object)0);
        this.field_6011.method_12784(EXPLOSION_PARTICLE, (Object)class_2398.field_22246);
        this.field_6011.method_12784(TRAIL_PARTICLE, (Object)class_2398.field_28479);
        this.field_6011.method_12784(AREA_PARTICLE, (Object)ParticleRegistry.NIGHTFALL_PARTICLE);
        this.field_6011.method_12784(EFFECT_TICKS, (Object)0);
        this.field_6011.method_12784(APPLIED_EFFECT_ID, (Object)"");
        this.field_6011.method_12784(EFFECT_AMPLIFIER, (Object)0);
    }

    public void setAgeAndPoints(int maxAge, int explosionPoints, int tickParticleAmount) {
        this.field_6011.method_12778(MAX_AGE, (Object)maxAge);
        this.field_6011.method_12778(EXPLOSION_PARTICLE_COUNT, (Object)explosionPoints);
        this.field_6011.method_12778(TRAIL_PARTICLE_COUNT, (Object)tickParticleAmount);
    }

    public void setExplosionExpansion(float particleExpansion) {
        this.field_6011.method_12778(EXPLOSION_EXPANSION, (Object)Float.valueOf(particleExpansion));
    }

    public void setModelRotation(int degrees) {
        this.field_6011.method_12778(MODEL_ROTATION, (Object)degrees);
    }

    public int getModelRotation() {
        return (Integer)this.field_6011.method_12789(MODEL_ROTATION);
    }

    public int getMaxParticlePoints() {
        return (Integer)this.field_6011.method_12789(EXPLOSION_PARTICLE_COUNT);
    }

    public int getTrailParticleCount() {
        return (Integer)this.field_6011.method_12789(TRAIL_PARTICLE_COUNT);
    }

    public int getMaxAge() {
        return (Integer)this.field_6011.method_12789(MAX_AGE);
    }

    public float getParticleExplosionExpansion() {
        return ((Float)this.field_6011.method_12789(EXPLOSION_EXPANSION)).floatValue();
    }

    public int getAreaParticleCount() {
        return (Integer)this.field_6011.method_12789(AREA_PARTICLE_COUNT);
    }

    public void setAreaParticleCount(int particleCount) {
        this.field_6011.method_12778(AREA_PARTICLE_COUNT, (Object)particleCount);
    }

    public void method_5773() {
        int i;
        super.method_5773();
        class_243 vec3d = this.method_18798();
        double e = vec3d.field_1352;
        double f = vec3d.field_1351;
        double g = vec3d.field_1350;
        for (i = 0; i < this.getTrailParticleCount(); ++i) {
            this.method_37908().method_8406(this.getTrailParticleType(), this.method_23317() + e * (double)i / 4.0, this.method_23318() + f * (double)i / 4.0, this.method_23321() + g * (double)i / 4.0, -e, -f + 0.2, -g);
        }
        for (i = 0; i < this.getAreaParticleCount(); ++i) {
            this.method_37908().method_8406((class_2394)ParticleRegistry.NIGHTFALL_PARTICLE, this.method_23322(0.5), this.method_23319() - 0.5, this.method_23325(0.5), 0.0, 0.0, 0.0);
        }
        if (this.field_6012 > this.getMaxAge()) {
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        this.method_31472();
    }

    public int method_35207() {
        if (this.method_7445() != null) {
            return class_1890.method_8225((class_1887)class_1893.field_9121, (class_1799)this.method_7445());
        }
        return super.method_35207();
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        class_1297 class_12972 = entityHitResult.method_17782();
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (this.method_7445() != null) {
                float bonus = class_1890.method_8218((class_1799)this.method_7445(), (class_1310)living.method_6046());
                this.method_7438(this.method_7448() + (double)(bonus >= 5.0f ? bonus * 0.7f : bonus));
            }
        }
        super.method_7454(entityHitResult);
        if (this.getAppliedEffectTicks() > 0 && this.getAppliedEffectId().isEmpty() && entityHitResult.method_17782() != null) {
            entityHitResult.method_17782().method_20803(this.getAppliedEffectTicks());
        }
        if (!this.getAppliedEffectId().isEmpty() && (class_12972 = entityHitResult.method_17782()) instanceof class_1309) {
            class_1309 target = (class_1309)class_12972;
            target.method_6092(new class_1293(this.getAppliedEffect(), this.getAppliedEffectTicks(), this.getEffectAmplifier()));
        }
        this.method_31472();
    }

    public void detonateEntity(class_1937 world, double x, double y, double z, double points, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.method_8466(this.getExplosionParticleType(), true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    public void method_36209() {
        super.method_36209();
        this.detonateEntity(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), this.getMaxParticlePoints(), this.getParticleExplosionExpansion());
    }

    protected class_3414 method_7440() {
        return class_3417.field_15152;
    }

    protected float method_7436() {
        return 1.01f;
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_5753() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setExplosionParticleType(class_2394 particle) {
        this.method_5841().method_12778(EXPLOSION_PARTICLE, (Object)particle);
    }

    public class_2394 getExplosionParticleType() {
        return (class_2394)this.method_5841().method_12789(EXPLOSION_PARTICLE);
    }

    public void setTrailParticleType(class_2394 particle) {
        this.method_5841().method_12778(TRAIL_PARTICLE, (Object)particle);
    }

    public class_2394 getTrailParticleType() {
        return (class_2394)this.method_5841().method_12789(TRAIL_PARTICLE);
    }

    public void setAreaParticleType(class_2394 particle) {
        this.method_5841().method_12778(AREA_PARTICLE, (Object)particle);
    }

    public class_2394 getAreaParticleType() {
        return (class_2394)this.method_5841().method_12789(AREA_PARTICLE);
    }

    public void setAppliedEffectTicks(int ticks) {
        this.field_6011.method_12778(EFFECT_TICKS, (Object)ticks);
    }

    public int getAppliedEffectTicks() {
        return (Integer)this.field_6011.method_12789(EFFECT_TICKS);
    }

    public String getAppliedEffectId() {
        return (String)this.field_6011.method_12789(APPLIED_EFFECT_ID);
    }

    public void setAppliedEffectId(String string) {
        this.field_6011.method_12778(APPLIED_EFFECT_ID, (Object)string);
    }

    public void setAppliedStatusEffect(class_1291 effect) {
        this.setAppliedEffectId(Objects.requireNonNull(class_7923.field_41174.method_10221((Object)effect)));
    }

    public void setAppliedEffectId(class_2960 identifier) {
        this.setAppliedEffectId(identifier.toString());
    }

    public class_1291 getAppliedEffect() {
        return (class_1291)class_7923.field_41174.method_10223(new class_2960(this.getAppliedEffectId()));
    }

    public int getEffectAmplifier() {
        return (Integer)this.field_6011.method_12789(EFFECT_AMPLIFIER);
    }

    public void setEffectAmplifier(int amplifier) {
        this.field_6011.method_12778(EFFECT_AMPLIFIER, (Object)amplifier);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("ExplosionParticle", this.getExplosionParticleType().method_10293());
        nbt.method_10582("TrailParticle", this.getExplosionParticleType().method_10293());
        nbt.method_10582("AreaParticle", this.getAreaParticleType().method_10293());
        nbt.method_10569("ExplosionParticleCount", this.getMaxParticlePoints());
        nbt.method_10569("TrailParticleCount", this.getTrailParticleCount());
        nbt.method_10569("MaxAge", this.getMaxAge());
        nbt.method_10548("ParticleExplosionExpansion", this.getParticleExplosionExpansion());
        nbt.method_10569("ModelRotation", this.getModelRotation());
        nbt.method_10582("AppliedEffectId", this.getAppliedEffectId());
        nbt.method_10569("AppliedEffectAmplifier", this.getEffectAmplifier());
        nbt.method_10569("AppliedEffectTicks", this.getAppliedEffectTicks());
        nbt.method_10569("AreaParticleCount", this.getAreaParticleCount());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("ExplosionParticle", 8)) {
            try {
                this.setExplosionParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("ExplosionParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("ExplosionParticle"), (Object)var5);
            }
        }
        if (nbt.method_10573("TrailParticle", 8)) {
            try {
                this.setTrailParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("TrailParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("TrailParticle"), (Object)var5);
            }
        }
        if (nbt.method_10573("AreaParticle", 8)) {
            try {
                this.setAreaParticleType(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("AreaParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("AreaParticle"), (Object)var5);
            }
        }
        if (nbt.method_10545("ExplosionParticleCount") && nbt.method_10545("TrailParticleCount") && nbt.method_10545("MaxAge")) {
            this.setAgeAndPoints(nbt.method_10550("MaxAge"), nbt.method_10550("ExplosionParticleCount"), nbt.method_10550("TrailParticleCount"));
        }
        if (nbt.method_10545("ParticleExplosionExpansion")) {
            this.setExplosionExpansion(nbt.method_10583("ParticleExplosionExpansion"));
        }
        if (nbt.method_10545("ModelRotation")) {
            this.setModelRotation(nbt.method_10550("ModelRotation"));
        }
        if (nbt.method_10545("AppliedEffectId")) {
            this.setAppliedEffectId(nbt.method_10558("AppliedEffectId"));
        }
        if (nbt.method_10545("AppliedEffectAmplifier")) {
            this.setEffectAmplifier(nbt.method_10550("AppliedEffectAmplifier"));
        }
        if (nbt.method_10545("AppliedEffectTicks")) {
            this.setAppliedEffectTicks(nbt.method_10550("AppliedEffectTicks"));
        }
        if (nbt.method_10545("AreaParticleCount")) {
            this.setAreaParticleCount(nbt.method_10550("AreaParticleCount"));
        }
    }
}

