/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1528;
import net.minecraft.class_1538;
import net.minecraft.class_1687;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4081;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_7260;
import net.minecraft.class_7923;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.LuckChosenObject;
import net.soulsweaponry.util.WeaponUtil;

public class WitheredWabbajackProjectile
extends class_1687 {
    private static final List<LuckChosenObject<class_1299<?>>> ENTITIES = new ArrayList();
    private static final List<LuckChosenObject<CollisionEffect>> COLLISIONS = new ArrayList<LuckChosenObject<CollisionEffect>>();

    public WitheredWabbajackProjectile(class_1299<? extends WitheredWabbajackProjectile> entityType, class_1937 world) {
        super(entityType, world);
    }

    public WitheredWabbajackProjectile(class_1937 world, class_1309 owner, double directionX, double directionY, double directionZ) {
        this(owner.method_23317(), owner.method_23318(), owner.method_23321(), directionX, directionY, directionZ, world);
        this.method_7432((class_1297)owner);
        this.method_5710(owner.method_36454(), owner.method_36455());
    }

    public WitheredWabbajackProjectile(double x, double y, double z, double directionX, double directionY, double directionZ, class_1937 world) {
        super(EntityRegistry.WITHERED_WABBAJACK_PROJECTILE, world);
        this.method_5808(x, y, z, this.method_36454(), this.method_36455());
        this.method_23311();
        double d = Math.sqrt(directionX * directionX + directionY * directionY + directionZ * directionZ);
        if (d != 0.0) {
            this.field_7601 = directionX / d * 0.1;
            this.field_7600 = directionY / d * 0.1;
            this.field_7599 = directionZ / d * 0.1;
        }
    }

    protected float method_7466() {
        return 1.0f;
    }

    protected void method_7454(class_3966 entityHitResult) {
        if (!this.method_37908().field_9236) {
            class_1297 entity = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();
            if (entity instanceof class_1309) {
                class_1309 target = (class_1309)entity;
                if (owner instanceof class_1309) {
                    class_1309 user = (class_1309)owner;
                    Random random = new Random();
                    int rng = random.nextInt(10) + 1;
                    int power = this.getBound(75, 5, user) + WeaponUtil.getLuckFactor(user) * 5;
                    int amplifier = this.getBound(3, 1, user) + WeaponUtil.getLuckFactor(user) / 2;
                    int duration = this.getBound(300, 50, user) + WeaponUtil.getLuckFactor(user) * 50;
                    switch (rng) {
                        case 1: 
                        case 2: 
                        case 3: {
                            target.method_6092(new class_1293(this.getRandomEffect(true), duration, amplifier));
                            break;
                        }
                        case 4: 
                        case 5: {
                            user.method_6092(new class_1293(this.getRandomEffect(false), duration, amplifier));
                            break;
                        }
                        case 6: {
                            boolean luck = this.getBound(20, 1, user) + WeaponUtil.getLuckFactor(user) > 10;
                            class_1309 living = luck ? target : user;
                            living.method_5661().iterator().forEachRemaining(itemStack -> {
                                boolean bl = this.field_5974.method_43056();
                                if (bl) {
                                    class_1799 separate = itemStack.method_7972();
                                    living.method_5775(separate);
                                    itemStack.method_7934(1);
                                    this.method_37908().method_8396(null, living.method_24515(), class_3417.field_15118, class_3419.field_15248, 1.0f, 1.0f);
                                }
                            });
                            break;
                        }
                        default: {
                            if (power > 50) {
                                this.method_37908().method_8396(null, this.method_24515(), SoundRegistry.CRIT_HIT_EVENT, class_3419.field_15248, 0.5f, 1.0f);
                            }
                            target.method_5643(this.method_37908().method_48963().method_48831(), (float)power);
                        }
                    }
                }
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 > 100) {
            this.resetListLuckFactors();
            this.method_31472();
        }
    }

    private void resetListLuckFactors() {
        for (LuckChosenObject<class_1299<?>> luckChosenObject : ENTITIES) {
            luckChosenObject.setLuckFactor(10);
        }
        for (LuckChosenObject<Object> luckChosenObject : COLLISIONS) {
            luckChosenObject.setLuckFactor(10);
        }
    }

    protected void method_7488(class_239 hitResult) {
        class_239.class_240 type = hitResult.method_17783();
        if (type == class_239.class_240.field_1331) {
            this.method_7454((class_3966)hitResult);
            this.method_37908().method_32888(class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43286((class_1297)this, null));
        } else if (type == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            this.method_24920(blockHitResult);
            class_2338 blockPos = blockHitResult.method_17777();
            this.method_37908().method_43276(class_5712.field_28162, blockPos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockPos)));
        }
        if (this.method_24921() != null && this.method_24921() instanceof class_1309) {
            this.randomCollisionEffect((class_1309)this.method_24921());
        }
        this.resetListLuckFactors();
        this.method_31472();
    }

    private void randomCollisionEffect(class_1309 user) {
        boolean unluckyAf;
        int power = this.getBound(10, 1, user) + WeaponUtil.getLuckFactor(user);
        boolean bl = unluckyAf = this.getBound(100, 10, user) == 1;
        if (unluckyAf) {
            boolean isWarden = this.field_5974.method_43056();
            for (int i = 0; i < 3; ++i) {
                if (isWarden && !this.method_37908().field_9236) {
                    class_7260 warden = new class_7260(class_1299.field_38095, this.method_37908());
                    warden.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(user.method_24515()), class_3730.field_16471, null, null);
                    warden.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                    warden.method_42212((class_1297)user, 80, true);
                    this.method_37908().method_8649((class_1297)warden);
                    continue;
                }
                class_1528 boss = new class_1528(class_1299.field_6119, this.method_37908());
                boss.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                this.method_37908().method_8649((class_1297)boss);
            }
            return;
        }
        switch (this.getCollisionEffectType(user).ordinal()) {
            case 3: {
                for (int i = 0; i < power * 2; ++i) {
                    class_1420 bat = new class_1420(class_1299.field_6108, this.method_37908());
                    bat.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                    this.method_37908().method_8649((class_1297)bat);
                }
                break;
            }
            case 5: {
                this.method_37908().method_8396(null, this.method_24515(), (class_3414)class_3417.field_14564.comp_349(), class_3419.field_15256, 1.0f, 1.0f);
                this.method_37908().method_8396(null, this.method_24515(), class_3417.field_38067, class_3419.field_15251, 1.0f, 1.0f);
                user.method_6092(new class_1293(class_1294.field_38092, 60, 0));
                break;
            }
            case 0: {
                for (int i = 0; i < power; ++i) {
                    class_1538 entity = new class_1538(class_1299.field_6112, this.method_37908());
                    entity.method_23327(this.method_23317(), this.method_23318(), this.method_23321());
                    this.method_37908().method_8649((class_1297)entity);
                }
                break;
            }
            case 4: {
                if (this.method_37908().field_9236) break;
                class_2400 particle = this.getRandomParticle();
                int amount = 1000;
                if (particle == class_2398.field_11250) {
                    amount = 1;
                }
                ParticleHandler.particleSphereList(this.method_37908(), amount, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, new class_2394[]{particle});
                break;
            }
            case 1: {
                this.summonRandomEntity(user, power);
                break;
            }
            case 2: {
                this.summonSpecificEntity(user, power);
                break;
            }
            case 7: {
                this.method_37908().method_8406((class_2394)class_2398.field_11250, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                this.method_37908().method_8396(null, user.method_24515(), class_3417.field_15203, class_3419.field_15251, 1.0f, 1.0f);
                user.method_6092(new class_1293(class_1294.field_5911, 200, 5));
                break;
            }
            default: {
                boolean bl2 = this.method_37908().method_8450().method_8355(class_1928.field_19388);
                this.method_37908().method_8537(this.method_24921(), this.method_23317(), this.method_23318(), this.method_23321(), (float)power, bl2, bl2 ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40888);
            }
        }
    }

    private class_2400 getRandomParticle() {
        Random number = new Random();
        ArrayList arr = new ArrayList();
        class_7923.field_41180.method_10220().forEach(p -> {
            if (p instanceof class_2400) {
                class_2400 d = (class_2400)p;
                arr.add(d);
            }
        });
        int rng = number.nextInt(arr.size());
        return (class_2400)arr.get(rng);
    }

    private void summonSpecificEntity(class_1309 user, int power) {
        if (!this.method_37908().field_9236) {
            class_1299<?> type = this.getEntityType(user);
            for (int i = 0; i < power; ++i) {
                type.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16467);
            }
        }
    }

    private void summonRandomEntity(class_1309 user, int power) {
        if (!this.method_37908().field_9236) {
            for (int i = 0; i < power; ++i) {
                class_1299<?> type = this.getEntityType(user);
                type.method_47821((class_3218)this.method_37908(), this.method_24515(), class_3730.field_16467);
            }
        }
    }

    private int getBound(int bound, int luckModifier, class_1309 user) {
        int b = bound + WeaponUtil.getLuckFactor(user) * luckModifier;
        return b > 0 ? this.field_5974.method_43048(b) : 1;
    }

    private CollisionEffect getCollisionEffectType(class_1309 user) {
        return (CollisionEffect)((Object)WeaponUtil.getRandomlyChosenObject(user, COLLISIONS, false));
    }

    private class_1299<?> getEntityType(class_1309 user) {
        return (class_1299)WeaponUtil.getRandomlyChosenObject(user, ENTITIES, false);
    }

    private class_1291 getRandomEffect(boolean flipLuckTypes) {
        if (this.method_24921() instanceof class_1309) {
            return (class_1291)WeaponUtil.getRandomlyChosenObject((class_1309)this.method_24921(), this.getEffectList(), flipLuckTypes);
        }
        return class_1294.field_5912;
    }

    private List<LuckChosenObject<class_1291>> getEffectList() {
        ArrayList<LuckChosenObject<class_1291>> list = new ArrayList<LuckChosenObject<class_1291>>();
        for (class_1291 effect : class_7923.field_41174) {
            if (effect.method_18792().equals((Object)class_4081.field_18272)) {
                list.add(new LuckChosenObject<class_1291>(effect, WeaponUtil.LuckType.BAD));
                continue;
            }
            if (effect.method_18792().equals((Object)class_4081.field_18271)) {
                list.add(new LuckChosenObject<class_1291>(effect, WeaponUtil.LuckType.GOOD));
                continue;
            }
            list.add(new LuckChosenObject<class_1291>(effect, WeaponUtil.LuckType.NEUTRAL));
        }
        return list;
    }

    static {
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6046, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6051, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6128, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_20346, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6062, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6059, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6137, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6123, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6118, WeaponUtil.LuckType.BAD));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6073, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6085, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6070, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6111, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_17713, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6132, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6115, WeaponUtil.LuckType.NEUTRAL));
        ENTITIES.add(new LuckChosenObject<class_1299>(class_1299.field_6044, WeaponUtil.LuckType.GOOD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.RANDOM_ENTITY, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.SPECIFIC_ENTITY, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.BATS, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.PARTICLES, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.DARKNESS, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.CURSE, WeaponUtil.LuckType.BAD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.LIGHTNING, WeaponUtil.LuckType.GOOD));
        COLLISIONS.add(new LuckChosenObject<CollisionEffect>(CollisionEffect.EXPLOSION, WeaponUtil.LuckType.GOOD));
    }

    static enum CollisionEffect {
        LIGHTNING,
        RANDOM_ENTITY,
        SPECIFIC_ENTITY,
        BATS,
        PARTICLES,
        DARKNESS,
        EXPLOSION,
        CURSE;

    }
}

