/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.gun;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ITooltipInfo;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends class_1753
implements IConfigDisable,
ITooltipInfo {
    public static final Predicate<class_1799> SILVER_PROJECTILE = stack -> stack.method_31574(ItemRegistry.SILVER_BULLET);
    protected final List<TooltipAbilities> tooltipAbilities = new ArrayList<TooltipAbilities>();

    public GunItem(class_1792.class_1793 settings) {
        super(settings);
        this.addTooltipAbility(TooltipAbilities.GUN_ITEM);
    }

    public Predicate<class_1799> method_19268() {
        return SILVER_PROJECTILE;
    }

    public int getReducedCooldown(class_1799 stack) {
        return class_1890.method_8225((class_1887)EnchantRegistry.FAST_HANDS, (class_1799)stack) * 8;
    }

    public abstract int getPostureLoss(class_1799 var1);

    public abstract float getBulletDamage(class_1799 var1);

    public abstract float getBulletVelocity(class_1799 var1);

    public abstract float getBulletDivergence(class_1799 var1);

    public abstract int getCooldown(class_1799 var1);

    public abstract int bulletsNeeded();

    public abstract boolean method_24358();

    public int method_7881(class_1799 stack) {
        return 0;
    }

    public class_1665 createSilverBulletEntity(class_1937 world, class_1309 shooter, class_1799 gunStack) {
        float power = this.getBulletDamage(gunStack) / this.getBulletVelocity(gunStack) + (float)class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)gunStack) / 2.0f;
        int punch = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)gunStack);
        SilverBulletEntity entity = this.getModdedProjectile(world, shooter, gunStack);
        if (gunStack.method_31574((class_1792)GunRegistry.GATLING_GUN)) {
            entity.method_23327(shooter.method_23317(), shooter.method_23320() - (double)0.2f, shooter.method_23321());
        } else {
            entity.method_23327(shooter.method_23317(), shooter.method_23320(), shooter.method_23321());
        }
        entity.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, this.getBulletVelocity(gunStack), this.getBulletDivergence(gunStack));
        entity.field_7572 = class_1665.class_1666.field_7594;
        entity.setPostureLoss(this.getPostureLoss(gunStack));
        entity.method_7438(power);
        if (punch > 0) {
            entity.method_7449(punch);
        }
        if (class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)gunStack) > 0) {
            entity.method_5639(8);
        }
        return entity;
    }

    public SilverBulletEntity getModdedProjectile(class_1937 world, class_1309 shooter, class_1799 gunStack) {
        return new SilverBulletEntity(world, shooter, gunStack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.isDisabled(stack)) {
            tooltip.add((class_2561)class_2561.method_48321((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        this.appendTooltipAbilities(stack, world, tooltip, context);
        super.method_7851(stack, world, tooltip, context);
    }

    @Override
    public List<TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    @Override
    public void addTooltipAbility(TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    @Override
    public class_2561[] getAdditionalTooltips() {
        return new class_2561[0];
    }
}

