/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.scythe;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.ModTags;
import net.soulsweaponry.util.TooltipAbilities;

public class DarkinScythePre
extends SoulHarvestingItem {
    public final int MAX_SOULS = ConfigConstructor.darkin_scythe_max_souls;

    public DarkinScythePre(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.darkin_scythe_damage, ConfigConstructor.darkin_scythe_attack_speed, settings);
        this.getTooltipAbilities().clear();
        this.addTooltipAbility(TooltipAbilities.TRANSFORMATION);
    }

    @Override
    public void handleKill(class_1309 target, class_1799 stack) {
        int amount;
        int n = amount = target.method_5864().method_20210(ModTags.Entities.BOSSES) ? 20 : 1;
        if (target.method_5864().method_20210(ModTags.Entities.RANGED_MOBS) || target.method_6047().method_7909() instanceof class_1811 || target instanceof class_1296) {
            this.addAmount(stack, amount, SoulType.BLUE);
        } else {
            this.addAmount(stack, amount, SoulType.RED);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (!this.isDisabled(stack) && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (this.getSouls(stack) >= this.MAX_SOULS && slot == player.method_31548().field_7545) {
                if (!world.field_9236) {
                    ParticleHandler.particleSphere(world, 1000, entity.method_23317(), entity.method_23318() + (double)0.1f, entity.method_23321(), (class_2394)class_2398.field_11240, 1.0f);
                    ParticleHandler.particleOutburstMap(world, 200, entity.method_23317(), entity.method_23318() + (double)0.1f, entity.method_23321(), ParticleEvents.DAWNBREAKER_MAP, 1.0f);
                }
                world.method_8396(null, entity.method_24515(), SoundRegistry.DAWNBREAKER_EVENT, class_3419.field_15251, 0.8f, 1.0f);
                class_1831 item = WeaponRegistry.DARKIN_SCYTHE_PRIME;
                switch (this.getDominantType(stack).ordinal()) {
                    case 0: {
                        item = WeaponRegistry.DARKIN_SCYTHE_PRIME;
                        break;
                    }
                    case 1: {
                        item = WeaponRegistry.SHADOW_ASSASSIN_SCYTHE;
                    }
                }
                class_1799 newStack = new class_1799((class_1935)item);
                Map enchants = class_1890.method_8222((class_1799)stack);
                for (class_1887 enchant : enchants.keySet()) {
                    newStack.method_7978(enchant, ((Integer)enchants.get(enchant)).intValue());
                }
                player.method_31548().method_5441(slot);
                player.method_31548().method_7367(slot, newStack);
            }
        }
    }

    public void addAmount(class_1799 stack, int amount, SoulType soulType) {
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545(soulType.id)) {
                stack.method_7969().method_10569(soulType.id, stack.method_7969().method_10550(soulType.id) + amount);
            } else {
                stack.method_7969().method_10569(soulType.id, amount);
            }
        }
    }

    public SoulType getDominantType(class_1799 stack) {
        if (stack.method_7985()) {
            int red;
            int blue = stack.method_7969().method_10545(SoulType.BLUE.id) ? stack.method_7969().method_10550(SoulType.BLUE.id) : 0;
            int n = red = stack.method_7969().method_10545(SoulType.RED.id) ? stack.method_7969().method_10550(SoulType.RED.id) : 0;
            if (blue > red) {
                return SoulType.BLUE;
            }
            return SoulType.RED;
        }
        return SoulType.RED;
    }

    private float getBonusDamage(class_1799 stack) {
        if (this.isDisabled(stack)) {
            return 0.0f;
        }
        float soulPercent = (float)this.getSouls(stack) / (float)this.MAX_SOULS;
        return (float)ConfigConstructor.darkin_scythe_bonus_damage * soulPercent;
    }

    @Override
    public int getSouls(class_1799 stack) {
        int amount = 0;
        if (stack.method_7985()) {
            if (stack.method_7969().method_10545(SoulType.BLUE.id)) {
                amount += stack.method_7969().method_10550(SoulType.BLUE.id);
            }
            if (stack.method_7969().method_10545(SoulType.RED.id)) {
                amount += stack.method_7969().method_10550(SoulType.RED.id);
            }
        }
        return amount;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)(this.method_8020() + this.getBonusDamage(stack)), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.getAttackSpeed(), class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.method_7844(slot);
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_darkin_scythe;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_darkin_scythe;
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return false;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return null;
    }

    public static enum SoulType {
        RED("red_soul"),
        BLUE("blue_soul");

        final String id;

        private SoulType(String id) {
            this.id = id;
        }
    }
}

