/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.spear;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_756;
import net.soulsweaponry.client.renderer.item.CometSpearItemRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.CometSpearEntity;
import net.soulsweaponry.items.DetonateGroundItem;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.RenderProvider;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CometSpear
extends DetonateGroundItem
implements GeoItem {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<Object> renderProvider = GeoItem.makeRenderer((GeoItem)this);

    public CometSpear(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.comet_spear_damage, ConfigConstructor.comet_spear_attack_speed, settings);
        this.addTooltipAbility(TooltipAbilities.SKYFALL, TooltipAbilities.INFINITY, TooltipAbilities.CRIT);
    }

    @Override
    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (user instanceof class_1657) {
            class_1657 playerEntity = (class_1657)user;
            int i = this.method_7881(stack) - remainingUseTicks;
            if (i >= 10) {
                float enchant = WeaponUtil.getEnchantDamageBonus(stack);
                if (stack == user.method_6079()) {
                    float f = user.method_36454();
                    float g = user.method_36455();
                    float h = -class_3532.method_15374((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
                    float k = -class_3532.method_15374((float)(g * ((float)Math.PI / 180)));
                    float l = class_3532.method_15362((float)(f * ((float)Math.PI / 180))) * class_3532.method_15362((float)(g * ((float)Math.PI / 180)));
                    float m = class_3532.method_15355((float)(h * h + k * k + l * l));
                    float n = 3.0f * ((5.0f + enchant) / 4.0f);
                    user.method_5762((double)(h *= n / m), (double)(k *= n / m), (double)(l *= n / m));
                    playerEntity.method_40126(20);
                    world.method_43129(null, (class_1297)playerEntity, class_3417.field_14717, class_3419.field_15248, 1.0f, 1.0f);
                    if (playerEntity.method_24828()) {
                        playerEntity.method_5784(class_1313.field_6308, new class_243(0.0, 1.1999999284744263, 0.0));
                    }
                    user.method_6092(new class_1293(EffectRegistry.CALCULATED_FALL, 600, ConfigConstructor.comet_spear_ability_damage));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownSkyfall(stack));
                    stack.method_7956(4, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                } else {
                    stack.method_7956(2, (class_1309)playerEntity, p_220045_0_ -> p_220045_0_.method_20236(user.method_6058()));
                    this.applyItemCooldown(playerEntity, this.getScaledCooldownThrow(stack));
                    CometSpearEntity entity = new CometSpearEntity(world, (class_1309)playerEntity, stack);
                    entity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 5.0f, 1.0f);
                    entity.field_7572 = class_1665.class_1666.field_7594;
                    world.method_8649((class_1297)entity);
                    world.method_43129(null, (class_1297)entity, class_3417.field_15001, class_3419.field_15248, 1.0f, 1.0f);
                }
            }
        }
    }

    protected int getScaledCooldownSkyfall(class_1799 stack) {
        int base = ConfigConstructor.comet_spear_skyfall_ability_cooldown;
        return Math.max(ConfigConstructor.comet_spear_skyfall_ability_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 20);
    }

    protected int getScaledCooldownThrow(class_1799 stack) {
        int base = ConfigConstructor.comet_spear_throw_ability_cooldown;
        return Math.max(ConfigConstructor.comet_spear_throw_ability_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 5);
    }

    @Override
    public boolean canEnchantReduceCooldown(class_1799 stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown;
    }

    @Override
    public String[] getReduceCooldownEnchantIds(class_1799 stack) {
        return ConfigConstructor.comet_spear_enchant_reduces_cooldown_ids;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void createRenderer(Consumer<Object> consumer) {
        consumer.accept(new RenderProvider(){
            private final CometSpearItemRenderer renderer = new CometSpearItemRenderer();

            public class_756 getCustomRenderer() {
                return this.renderer;
            }
        });
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    @Override
    public boolean method_24358() {
        return ConfigConstructor.is_fireproof_comet_spear;
    }

    @Override
    public float getBaseExpansion() {
        return ConfigConstructor.comet_spear_calculated_fall_base_radius;
    }

    @Override
    public float getExpansionModifier() {
        return ConfigConstructor.comet_spear_calculated_fall_height_increase_radius_modifier;
    }

    @Override
    public float getLaunchModifier() {
        return ConfigConstructor.comet_spear_calculated_fall_target_launch_modifier;
    }

    @Override
    public float getMaxLaunchPower() {
        return ConfigConstructor.comet_spear_calculated_fall_target_max_launch_power;
    }

    @Override
    public float getMaxExpansion() {
        return ConfigConstructor.comet_spear_calculated_fall_max_radius;
    }

    @Override
    public float getMaxDetonationDamage() {
        return ConfigConstructor.comet_spear_calculated_fall_max_damage;
    }

    @Override
    public float getFallDamageIncreaseModifier() {
        return ConfigConstructor.comet_spear_calculated_fall_height_increase_damage_modifier;
    }

    @Override
    public boolean shouldHeal() {
        return ConfigConstructor.comet_spear_calculated_fall_should_heal;
    }

    @Override
    public float getHealFromDamageModifier() {
        return ConfigConstructor.comet_spear_calculated_fall_heal_from_damage_modifier;
    }

    @Override
    public void doCustomEffects(class_1309 target, class_1309 user) {
    }

    @Override
    public Map<class_2394, class_243> getParticles() {
        HashMap<class_2394, class_243> map = new HashMap<class_2394, class_243>();
        map.put((class_2394)class_2398.field_11240, new class_243(1.0, 6.0, 1.0));
        return map;
    }

    @Override
    public boolean isDisabled(class_1799 stack) {
        return ConfigConstructor.disable_use_comet_spear;
    }
}

