/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items.sword;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_5134;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.TrickWeapon;
import net.soulsweaponry.util.TooltipAbilities;
import net.soulsweaponry.util.WeaponUtil;

public class HolyMoonlightSword
extends TrickWeapon
implements IChargeNeeded {
    public HolyMoonlightSword(class_1832 toolMaterial, class_1792.class_1793 settings) {
        super(toolMaterial, ConfigConstructor.holy_moonlight_sword_damage, ConfigConstructor.holy_moonlight_sword_attack_speed, settings, false, ConfigConstructor.holy_moonlight_sword_righteous_undead_bonus_damage, ConfigConstructor.is_fireproof_holy_moonlight_sword, ConfigConstructor.disable_use_holy_moonlight_sword);
        this.addTooltipAbility(TooltipAbilities.CHARGE, TooltipAbilities.CHARGE_BONUS_DAMAGE);
    }

    @Override
    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (!this.isDisabled(stack)) {
            this.addCharge(stack, this.getAddedCharge(stack));
        }
        return super.method_7873(stack, target, attacker);
    }

    private float getBonusDamage(class_1799 stack) {
        if (this.isDisabled(stack)) {
            return 0.0f;
        }
        float per = (float)this.getCharge(stack) / (float)ConfigConstructor.holy_moonlight_ability_charge_needed;
        return (float)ConfigConstructor.holy_moonlight_sword_max_bonus_damage * per;
    }

    public Multimap<class_1320, class_1322> getAttributeModifiers(class_1799 stack, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(field_8006, "Weapon modifier", (double)(this.method_8020() + this.getBonusDamage(stack)), class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(field_8001, "Weapon modifier", (double)this.getAttackSpeed(), class_1322.class_1323.field_6328));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.method_7844(slot);
    }

    @Override
    public int getMaxCharge() {
        return ConfigConstructor.holy_moonlight_ability_charge_needed;
    }

    @Override
    public int getAddedCharge(class_1799 stack) {
        int base = ConfigConstructor.holy_moonlight_sword_charge_added_post_hit;
        return base + WeaponUtil.getEnchantDamageBonus(stack);
    }

    @Override
    public boolean acceptsMoonHeraldEffect(class_1799 stack) {
        return true;
    }
}

