/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.soulsweaponry.util.LuckChosenObject;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Nullable;

public class WeaponUtil {
    public static final class_1887[] DAMAGE_ENCHANTS = new class_1887[]{class_1893.field_9118, class_1893.field_9123, class_1893.field_9112};

    public static int getEnchantDamageBonus(class_1799 stack) {
        for (class_1887 ench : DAMAGE_ENCHANTS) {
            if (class_1890.method_8225((class_1887)ench, (class_1799)stack) <= 0) continue;
            return class_1890.method_8225((class_1887)ench, (class_1799)stack);
        }
        return 0;
    }

    public static List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int t : array) {
            list.add(t);
        }
        return list;
    }

    public static void doConsumerOnCircle(class_1937 world, float yaw, class_243 start, double maxY, int ripples, class_241 radiusAndMod, TriConsumer<class_243, Integer, Float> consumer) {
        double y = maxY + 1.0;
        float f = (float)Math.toRadians(yaw);
        for (int waves = 0; waves < ripples; ++waves) {
            for (int i = 0; i < 360; i += class_3532.method_15375((float)(80.0f / ((float)waves + 1.0f)))) {
                float r = radiusAndMod.field_1343 + (float)waves * radiusAndMod.field_1342;
                yaw = (float)((double)f + (double)i * Math.PI / 180.0);
                double x0 = start.method_10216();
                double z0 = start.method_10215();
                double x = x0 + (double)r * Math.cos((double)i * Math.PI / 180.0);
                double z = z0 + (double)r * Math.sin((double)i * Math.PI / 180.0);
                WeaponUtil.doConsumerOnPoint(world, x, z, maxY, y, 3 * (waves + 1), yaw, consumer);
            }
        }
    }

    public static void doConsumerOnLine(class_1937 world, float yaw, class_243 startPos, double maxY, int amount, float spacingModifier, TriConsumer<class_243, Integer, Float> consumer) {
        double y = maxY + 1.0;
        float f = (float)Math.toRadians(yaw);
        for (int i = 0; i < amount; ++i) {
            double h = (double)spacingModifier * (double)(i + 1);
            WeaponUtil.doConsumerOnPoint(world, startPos.method_10216() + (double)class_3532.method_15362((float)f) * h, startPos.method_10215() + (double)class_3532.method_15374((float)f) * h, maxY, y, -6 + i * 2, yaw, consumer);
        }
    }

    public static void doConsumerOnPoint(class_1937 world, double x, double z, double maxY, double y, int warmup, float yaw, TriConsumer<class_243, Integer, Float> consumer) {
        class_2338 blockPos = new class_2338((int)x, (int)y, (int)z);
        boolean bl = false;
        double d = 0.0;
        do {
            class_265 voxelShape;
            class_2338 blockPos2;
            if (!world.method_8320(blockPos2 = blockPos.method_10074()).method_26206((class_1922)world, blockPos2, class_2350.field_11036)) continue;
            if (!world.method_22347(blockPos) && !(voxelShape = world.method_8320(blockPos).method_26220((class_1922)world, blockPos)).method_1110()) {
                d = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.method_10074()).method_10264() >= class_3532.method_15357((double)maxY) - 1);
        if (bl) {
            consumer.accept((Object)new class_243(x, (double)blockPos.method_10264() + d, z), (Object)warmup, (Object)Float.valueOf(yaw));
        }
    }

    public static int getLuckFactor(class_1309 entity) {
        return class_3532.method_15357((double)(entity.method_26825(class_5134.field_23726) * 2.0 + 2.0));
    }

    @Nullable
    public static <T> T getRandomlyChosenObject(class_1309 user, List<LuckChosenObject<T>> list, boolean flipLuckTypes) {
        ArrayList<LuckChosenObject<T>> projectileList = new ArrayList<LuckChosenObject<T>>();
        int modifier = flipLuckTypes ? -1 : 1;
        for (LuckChosenObject<T> luckChosenObject : list) {
            switch (luckChosenObject.getLuckType().ordinal()) {
                case 2: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * -WeaponUtil.getLuckFactor(user));
                    break;
                }
                case 0: {
                    luckChosenObject.setLuckFactor(luckChosenObject.getLuckFactor() + modifier * WeaponUtil.getLuckFactor(user));
                }
            }
            if (luckChosenObject.getLuckFactor() <= 0) continue;
            projectileList.add(luckChosenObject);
        }
        int totalChance = 0;
        for (LuckChosenObject luckChosenObject : projectileList) {
            totalChance += luckChosenObject.getLuckFactor();
        }
        int n = user.method_6051().method_43048(totalChance);
        boolean bl = false;
        for (LuckChosenObject luckChosenObject : projectileList) {
            if (n >= (var7_12 += luckChosenObject.getLuckFactor())) continue;
            return luckChosenObject.getObject();
        }
        return null;
    }

    public static enum LuckType {
        GOOD,
        NEUTRAL,
        BAD;

    }
}

