/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.fabric.smap;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SourceMap {
    private final String generatedFileName;
    private final String firstStratum;
    private final Map<Integer, FileInfo> fileinfo = new HashMap<Integer, FileInfo>();
    private final Map<Integer, int[]> reverseLineMapping = new HashMap<Integer, int[]>();
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]+)(?:#([0-9]+))?(?:,([0-9]+))?:([0-9]+)(?:,([0-9]+))?");

    public SourceMap(String value) {
        String[] lines = value.split("\n");
        if (!(lines[0].equals("SMAP") && lines[3].startsWith("*S ") && lines[4].equals("*F"))) {
            throw new IllegalArgumentException(value);
        }
        this.generatedFileName = lines[1];
        this.firstStratum = lines[3].substring(3);
        int idx = 5;
        while (!lines[idx].startsWith("*")) {
            String infoline = lines[idx++];
            String path = null;
            if (infoline.startsWith("+ ")) {
                path = lines[idx++];
                infoline = infoline.substring(2);
            }
            int pos = infoline.indexOf(" ");
            int filenum = Integer.parseInt(infoline.substring(0, pos));
            String name = infoline.substring(pos + 1);
            this.fileinfo.put(filenum, new FileInfo(name, path == null ? name : path));
        }
        if (lines[idx].equals("*L")) {
            ++idx;
            int lastLFI = 0;
            while (!lines[idx].startsWith("*")) {
                Matcher m;
                if (!(m = LINE_INFO_PATTERN.matcher(lines[idx++])).matches()) {
                    throw new IllegalArgumentException(lines[idx - 1]);
                }
                int inputStartLine = Integer.parseInt(m.group(1));
                int lineFileID = m.group(2) == null ? lastLFI : Integer.parseInt(m.group(2));
                int repeatCount = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
                int outputStartLine = Integer.parseInt(m.group(4));
                int outputLineIncrement = m.group(5) == null ? 1 : Integer.parseInt(m.group(5));
                for (int i = 0; i < repeatCount; ++i) {
                    int baseOL;
                    int[] inputMapping = new int[]{lineFileID, inputStartLine + i};
                    for (int ol = baseOL = outputStartLine + i * outputLineIncrement; ol < baseOL + outputLineIncrement; ++ol) {
                        if (this.reverseLineMapping.containsKey(ol)) continue;
                        this.reverseLineMapping.put(ol, inputMapping);
                    }
                }
                lastLFI = lineFileID;
            }
        }
    }

    public String getGeneratedFileName() {
        return this.generatedFileName;
    }

    public String getFirstStratum() {
        return this.firstStratum;
    }

    public Map<Integer, FileInfo> getFileInfo() {
        return this.fileinfo;
    }

    public Map<Integer, int[]> getReverseLineMapping() {
        return this.reverseLineMapping;
    }

    public record FileInfo(String name, String path) {
    }
}

