/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.cannon;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.cannon.CannonTrajectory;
import net.mehvahdjukaar.supplementaries.common.block.blocks.CannonBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSyncCannonPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_638;
import net.minecraft.class_744;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class CannonController {
    @Nullable
    protected static CannonBlockTile cannon;
    private static class_5498 lastCameraType;
    protected static class_239 hit;
    private static boolean firstTick;
    private static float yawIncrease;
    private static float pitchIncrease;
    private static boolean needsToUpdateServer;
    private static boolean preferShootingDown;
    @Nullable
    protected static CannonTrajectory trajectory;
    private static class_243 lastCameraPos;
    private static float lastZoomOut;
    private static float lastCameraYaw;
    private static float lastCameraPitch;

    public static void activateCannonCamera(CannonBlockTile tile) {
        cannon = tile;
        firstTick = true;
        preferShootingDown = true;
        class_310 mc = class_310.method_1551();
        lastCameraType = mc.field_1690.method_31044();
        mc.field_1690.method_31043(class_5498.field_26665);
        mc.field_1705.method_1758((class_2561)class_2561.method_43469((String)"message.supplementaries.cannon_maneuver", (Object[])new Object[]{mc.field_1690.field_1832.method_16007(), mc.field_1690.field_1886.method_16007()}), false);
    }

    public static void turnOff() {
        cannon = null;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
        lastZoomOut = 0.0f;
        lastCameraPos = null;
        if (lastCameraType != null) {
            class_310.method_1551().field_1690.method_31043(lastCameraType);
        }
    }

    public static boolean isActive() {
        return cannon != null;
    }

    public static boolean setupCamera(class_4184 camera, class_1922 level, class_1297 entity, boolean detached, boolean thirdPersonReverse, float partialTick) {
        if (CannonController.isActive()) {
            class_243 centerCannonPos = cannon.method_11016().method_46558();
            if (lastCameraPos == null) {
                lastCameraPos = camera.method_19326();
                lastCameraYaw = camera.method_19330();
                lastCameraPitch = camera.method_19329();
            }
            class_243 targetCameraPos = centerCannonPos.method_1031(0.0, 2.0, 0.0);
            float targetYRot = camera.method_19330() + yawIncrease;
            float targetXRot = class_3532.method_15363((float)(camera.method_19329() + pitchIncrease), (float)-90.0f, (float)90.0f);
            camera.method_19322(targetCameraPos);
            camera.method_19325(targetYRot, targetXRot);
            lastCameraPos = camera.method_19326();
            lastCameraYaw = camera.method_19330();
            lastCameraPitch = camera.method_19329();
            lastZoomOut = (float)camera.method_19318(4.0);
            camera.method_19324((double)(-lastZoomOut), 0.0, -1.0);
            yawIncrease = 0.0f;
            pitchIncrease = 0.0f;
            class_243 lookDir2 = new class_243(camera.method_19335());
            float maxRange = 128.0f;
            class_243 actualCameraPos = camera.method_19326();
            class_243 endPos = actualCameraPos.method_1019(lookDir2.method_1021((double)maxRange));
            hit = level.method_17742(new class_3959(actualCameraPos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1347, entity));
            class_243 targetVector = hit.method_17784().method_1020(cannon.method_11016().method_46558());
            class_241 target = new class_241((float)class_3532.method_39241((double)targetVector.field_1352, (double)targetVector.field_1350), (float)targetVector.field_1351);
            target = target.method_35586(target.method_35581().method_35582(0.05f));
            float wantedCannonYaw = (float)Math.PI + (float)class_3532.method_15349((double)(-targetVector.field_1352), (double)targetVector.field_1350);
            Restraint restraints = CannonController.getPitchAndYawRestrains(cannon.method_11010());
            trajectory = CannonTrajectory.findBest(target, cannon.getProjectileGravity(), cannon.getProjectileDrag(), cannon.getFirePower(), preferShootingDown, restraints.minPitch, restraints.maxPitch);
            if (trajectory != null) {
                float followSpeed = 0.4f;
                cannon.setPitch(class_3532.method_17821((float)followSpeed, (float)cannon.getPitch(1.0f), (float)(trajectory.pitch() * 57.295776f)));
                float yaw = class_3532.method_17821((float)followSpeed, (float)cannon.getYaw(1.0f), (float)(wantedCannonYaw * 57.295776f));
                cannon.setYaw(class_3532.method_15363((float)yaw, (float)restraints.minYaw, (float)restraints.maxYaw));
            }
            return true;
        }
        return false;
    }

    private static Restraint getPitchAndYawRestrains(class_2680 state) {
        return switch ((class_2350)state.method_11654((class_2769)CannonBlock.field_10927)) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11043 -> new Restraint(70.0f, 290.0f, -360.0f, 360.0f);
            case class_2350.field_11035 -> new Restraint(-110.0f, 110.0f, -360.0f, 360.0f);
            case class_2350.field_11034 -> new Restraint(-200.0f, 20.0f, -360.0f, 360.0f);
            case class_2350.field_11039 -> new Restraint(-20.0f, 200.0f, -360.0f, 360.0f);
            case class_2350.field_11036 -> new Restraint(-360.0f, 360.0f, -200.0f, 20.0f);
            case class_2350.field_11033 -> new Restraint(-360.0f, 360.0f, -20.0f, 200.0f);
        };
    }

    public static void onPlayerRotated(double yawAdd, double pitchAdd) {
        float scale = 0.2f;
        yawIncrease = (float)((double)yawIncrease + yawAdd * (double)scale);
        pitchIncrease = (float)((double)pitchIncrease + pitchAdd * (double)scale);
        if (yawAdd != 0.0 || pitchAdd != 0.0) {
            needsToUpdateServer = true;
        }
    }

    public static void onKeyPressed(int key, int action, int modifiers) {
        if (action != 1) {
            return;
        }
        if (class_310.method_1551().field_1690.field_1832.method_1417(key, action)) {
            CannonController.turnOff();
        }
        if (class_310.method_1551().field_1690.field_1903.method_1417(key, action)) {
            preferShootingDown = !preferShootingDown;
            needsToUpdateServer = true;
        }
    }

    public static void onPlayerAttack(boolean attack) {
        if (attack && cannon != null && cannon.readyToFire()) {
            ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSyncCannonPacket(cannon.getYaw(1.0f), cannon.getPitch(1.0f), cannon.getFirePower(), true, cannon.method_11016()));
        }
    }

    public static void onInputUpdate(class_744 input) {
        if (firstTick) {
            firstTick = false;
            input.field_3909 = false;
            input.field_3904 = false;
            input.field_3910 = false;
            input.field_3908 = false;
            input.field_3906 = false;
            input.field_3903 = false;
            input.field_3905 = 0.0f;
            input.field_3907 = 0.0f;
        }
    }

    public static void onClientTick(class_310 mc) {
        if (!CannonController.isActive()) {
            return;
        }
        class_638 level = mc.field_1687;
        class_2338 pos = cannon.method_11016();
        class_746 player = class_310.method_1551().field_1724;
        float maxDist = 7.0f;
        if (level.method_8321(pos) == cannon && !cannon.method_11015() && pos.method_19770((class_2374)player.method_19538()) < (double)(maxDist * maxDist)) {
            if (needsToUpdateServer) {
                needsToUpdateServer = false;
                ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSyncCannonPacket(cannon.getYaw(0.0f), cannon.getPitch(0.0f), cannon.getFirePower(), false, cannon.method_11016()));
            }
        } else {
            CannonController.turnOff();
        }
    }

    static {
        firstTick = true;
        preferShootingDown = true;
        lastZoomOut = 0.0f;
        lastCameraYaw = 0.0f;
        lastCameraPitch = 0.0f;
    }

    private record Restraint(float minYaw, float maxYaw, float minPitch, float maxPitch) {
    }
}

