/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.entity.IExtraClientSpawnData;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.events.overrides.InteractEventsHandler;
import net.mehvahdjukaar.supplementaries.common.items.BombItem;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1677;
import net.minecraft.class_1680;
import net.minecraft.class_1684;
import net.minecraft.class_1686;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1776;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1823;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4537;

public class SlingshotProjectileEntity
extends ImprovedProjectileEntity
implements IExtraClientSpawnData {
    private static final class_2940<Byte> ID_LOYALTY = class_2945.method_12791(SlingshotProjectileEntity.class, (class_2941)class_2943.field_13319);
    protected int MAX_AGE = 700;
    private float xRotInc;
    private float yRotInc;
    private float particleCooldown = 0.0f;
    private final Supplier<Integer> light = Suppliers.memoize(() -> {
        class_1792 item = this.method_7495().method_7909();
        if (item instanceof class_1747) {
            class_1747 blockItem = (class_1747)item;
            class_2248 b = blockItem.method_7711();
            return b.method_9564().method_26213();
        }
        return 0;
    });

    public SlingshotProjectileEntity(class_1309 thrower, class_1937 world, class_1799 item, class_1799 throwerStack) {
        this(world, item, throwerStack);
        this.method_5814(thrower.method_23317(), thrower.method_23320() - 0.1, thrower.method_23321());
        this.method_7432((class_1297)thrower);
    }

    public SlingshotProjectileEntity(class_1937 world, class_1799 item, class_1799 throwerStack) {
        super(ModEntities.SLINGSHOT_PROJECTILE.get(), world);
        this.maxAge = this.MAX_AGE;
        this.method_16940(item);
        this.field_6011.method_12778(ID_LOYALTY, (Object)((byte)class_1890.method_8206((class_1799)throwerStack)));
        this.method_5875(class_1890.method_8225((class_1887)ModRegistry.STASIS_ENCHANTMENT.get(), (class_1799)throwerStack) != 0);
        this.yRotInc = (float)(this.field_5974.method_43056() ? 1 : -1) * (float)(4.0 * this.field_5974.method_43059() + 7.0);
        this.xRotInc = (float)(this.field_5974.method_43056() ? 1 : -1) * (float)(4.0 * this.field_5974.method_43059() + 7.0);
        this.method_36457(this.field_5974.method_43057() * 360.0f);
        this.method_36456(this.field_5974.method_43057() * 360.0f);
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
    }

    public SlingshotProjectileEntity(class_1299<SlingshotProjectileEntity> type, class_1937 world) {
        super(type, world);
        this.maxAge = this.MAX_AGE;
    }

    protected ImprovedProjectileEntity.ColliderType getColliderType() {
        return ImprovedProjectileEntity.ColliderType.RAY;
    }

    public class_2596<class_2602> method_18002() {
        return PlatHelper.getEntitySpawnPacket((class_1297)this);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ID_LOYALTY, (Object)0);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.field_6011.method_12778(ID_LOYALTY, (Object)tag.method_10571("Loyalty"));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10567("Loyalty", ((Byte)this.field_6011.method_12789(ID_LOYALTY)).byteValue());
    }

    public void setLoyalty(class_1799 stack) {
        this.field_6011.method_12778(ID_LOYALTY, (Object)((byte)class_1890.method_8206((class_1799)stack)));
    }

    protected class_1792 method_16942() {
        return class_1802.field_20391;
    }

    protected void method_7454(class_3966 entityRayTraceResult) {
        class_1297 class_12972;
        super.method_7454(entityRayTraceResult);
        if (!this.trySplashPotStuff() && (class_12972 = entityRayTraceResult.method_17782()) instanceof class_1560) {
            class_1747 bi;
            class_2248 block;
            class_1560 enderman = (class_1560)class_12972;
            class_1792 item = this.method_7495().method_7909();
            if (item instanceof class_1747 && ((block = (bi = (class_1747)item).method_7711()).method_40142().method_40220(class_3481.field_15460) || CommonConfigs.Tools.UNRESTRICTED_SLINGSHOT.get().booleanValue()) && enderman.method_7027() == null) {
                enderman.method_7032(block.method_9564());
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    protected void method_24920(class_3965 hit) {
        super.method_24920(hit);
        if (this.touchedGround) {
            return;
        }
        class_1297 owner = this.method_24921();
        class_1937 level = this.method_37908();
        boolean success = this.trySplashPotStuff();
        if (!success && owner instanceof class_1657) {
            class_1657 player = (class_1657)owner;
            if (!Utils.mayPerformBlockAction((class_1657)player, (class_2338)hit.method_17777(), (class_1799)this.method_7495())) {
                return;
            }
            if (CompatHandler.FLAN && (level.field_9236 || !FlanCompat.canPlace(player, hit.method_17777()))) {
                return;
            }
        }
        if (!success) {
            class_1657 p;
            class_1799 stack = this.method_7495();
            class_1792 item = stack.method_7909();
            class_1657 player = owner instanceof class_1657 ? (p = (class_1657)owner) : FakePlayerManager.getDefault((class_1297)this, (class_1297)this);
            class_1269 overrideResult = InteractEventsHandler.onItemUsedOnBlockHP(player, level, stack, class_1268.field_5808, hit);
            if (overrideResult.method_23665()) {
                success = true;
            } else {
                overrideResult = InteractEventsHandler.onItemUsedOnBlock(player, level, stack, class_1268.field_5808, hit);
                if (overrideResult.method_23665()) {
                    success = true;
                }
            }
            if (!success) {
                class_1657 fakePlayer = FakePlayerManager.getDefault((class_1297)this, (class_1297)player);
                success = ItemsUtil.place(item, new class_1750(level, fakePlayer, class_1268.field_5808, this.method_7495(), hit)).method_23665();
            }
        }
        if (success) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private boolean trySplashPotStuff() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof class_1309) {
            class_1309 le = (class_1309)class_12972;
            Object ent = null;
            class_1792 item = this.method_7495().method_7909();
            class_1937 level = this.method_37908();
            if (item instanceof class_4537) {
                class_1686 p = new class_1686(level, le);
                p.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                p.method_16940(this.method_7495());
                ent = p;
            } else if (item == class_1802.field_8814) {
                class_1677 p = new class_1677(level, le, this.method_23317(), this.method_23318(), this.method_23321());
                p.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                p.method_16936(this.method_7495());
                ent = p;
            } else if (item instanceof class_1823) {
                class_1680 s = new class_1680(level, le);
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            } else if (item instanceof BombItem) {
                BombItem bi = (BombItem)item;
                BombEntity s = new BombEntity(level, le, bi.getType());
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            } else if (item instanceof class_1776) {
                class_1684 s = new class_1684(level, le);
                s.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                s.method_16940(this.method_7495());
                ent = s;
            }
            if (ent != null) {
                level.method_8649(ent);
                ent.method_5773();
                return true;
            }
        }
        return false;
    }

    public void method_5773() {
        if (this.isNoPhysics()) {
            byte i = (Byte)this.field_6011.method_12789(ID_LOYALTY);
            class_1297 owner = this.method_24921();
            if (i > 0 && this.isAcceptableReturnOwner(owner)) {
                class_243 vector3d = new class_243(owner.method_23317() - this.method_23317(), owner.method_23320() - this.method_23318(), owner.method_23321() - this.method_23321());
                this.method_23327(this.method_23317(), this.method_23318() + vector3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double d0 = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vector3d.method_1029().method_1021(d0)));
            }
        }
        super.method_5773();
    }

    private boolean isAcceptableReturnOwner(class_1297 owner) {
        if (owner != null && owner.method_5805()) {
            return !(owner instanceof class_3222) || !owner.method_7325();
        }
        return false;
    }

    public void method_5694(class_1657 playerEntity) {
        if (this.isNoPhysics() || this.touchedGround) {
            boolean success = playerEntity.method_31549().field_7477 || playerEntity.method_31548().method_7394(this.method_7495());
            class_1937 level = this.method_37908();
            if (!level.field_9236) {
                if (!success) {
                    this.method_5699(this.method_7495(), 0.1f);
                }
            } else {
                level.method_8486(this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 1.4f + 2.0f, false);
            }
            this.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public boolean hasReachedEndOfLife() {
        if (this.method_5740() && this.method_18798().method_1027() < 0.005) {
            return true;
        }
        return super.hasReachedEndOfLife() && !this.isNoPhysics();
    }

    public void reachedEndOfLife() {
        if ((Byte)this.field_6011.method_12789(ID_LOYALTY) != 0 && this.isAcceptableReturnOwner(this.method_24921())) {
            this.setNoPhysics(true);
            this.groundTime = 0;
        } else {
            this.method_5699(this.method_7495(), 0.1f);
            super.reachedEndOfLife();
        }
    }

    protected void method_26962() {
        if (!this.isNoPhysics()) {
            this.field_6004 = this.method_36455();
            this.field_5982 = this.method_36454();
            this.method_36457(this.method_36455() + this.xRotInc);
            this.method_36456(this.method_36454() + this.yRotInc);
            this.particleCooldown += 1.0f;
        } else {
            super.method_26962();
        }
    }

    public void spawnTrailParticles() {
        class_243 newPos = this.method_19538();
        class_243 currentPos = new class_243(this.field_6014, this.field_6036, this.field_5969);
        if (!this.isNoPhysics()) {
            double d = this.method_18798().method_1033();
            if (this.field_6012 > 1 && d * (double)this.field_6012 > 1.5) {
                if (this.method_5740()) {
                    class_243 rot = new class_243(0.325, 0.0, 0.0).method_1024((float)this.field_6012 * 0.32f);
                    class_243 movement = this.method_18798();
                    class_243 offset = MthUtils.changeBasisN((class_243)movement, (class_243)rot);
                    double px = newPos.field_1352 + offset.field_1352;
                    double py = newPos.field_1351 + offset.field_1351;
                    double pz = newPos.field_1350 + offset.field_1350;
                    movement = movement.method_1021(0.25);
                    this.method_37908().method_8406((class_2394)ModParticles.STASIS_PARTICLE.get(), px, py, pz, movement.field_1352, movement.field_1351, movement.field_1350);
                } else {
                    double interval = 4.0 / (d * 0.95 + 0.05);
                    if ((double)this.particleCooldown > interval) {
                        this.particleCooldown = (float)((double)this.particleCooldown - interval);
                        double x = currentPos.field_1352;
                        double y = currentPos.field_1351;
                        double z = currentPos.field_1350;
                        this.method_37908().method_8406((class_2394)ModParticles.SLINGSHOT_PARTICLE.get(), x, y, z, 0.0, 0.01, 0.0);
                    }
                }
            }
        }
    }

    protected float getInertia() {
        return this.method_5740() ? (float)CommonConfigs.Tools.SLINGSHOT_DECELERATION.get().doubleValue() : super.getInertia();
    }

    public void writeSpawnData(class_2540 buffer) {
        class_1297 entity = this.method_24921();
        int id = -1;
        if (entity != null) {
            id = entity.method_5628();
        }
        buffer.writeInt(id);
        buffer.writeFloat(this.xRotInc);
        buffer.writeFloat(this.yRotInc);
        buffer.writeFloat(this.method_36455());
        buffer.writeFloat(this.method_36454());
    }

    public void readSpawnData(class_2540 buffer) {
        int id = buffer.readInt();
        if (id != -1) {
            this.method_7432(this.method_37908().method_8469(id));
        }
        this.xRotInc = buffer.readFloat();
        this.yRotInc = buffer.readFloat();
        this.method_36457(buffer.readFloat());
        this.method_36456(buffer.readFloat());
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
    }

    public int getLightEmission() {
        return this.light.get();
    }
}

