/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc;

import net.mehvahdjukaar.supplementaries.common.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3619;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5172;
import net.minecraft.class_5556;
import org.jetbrains.annotations.Nullable;

public class RopeHelper {
    public static boolean addRopeDown(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1268 hand, class_2248 ropeBlock) {
        return RopeHelper.addRope(pos, level, player, hand, ropeBlock, class_2350.field_11033, true, Integer.MAX_VALUE);
    }

    public static boolean addRope(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1268 hand, class_2248 ropeBlock, class_2350 moveDir, boolean canPush, int maxDist) {
        class_2586 class_25862;
        class_2680 state = level.method_8320(pos);
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveDir)) {
            return RopeHelper.addRope(pos.method_10093(moveDir), level, player, hand, ropeBlock, moveDir, canPush, maxDist);
        }
        if (state.method_27852(ModRegistry.PULLEY_BLOCK.get()) && (class_25862 = level.method_8321(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile te = (PulleyBlockTile)class_25862;
            return te.rotateIndirect(player, hand, ropeBlock, moveDir, false);
        }
        return RopeHelper.tryPlaceAndMove(player, hand, level, pos, ropeBlock, moveDir, canPush);
    }

    public static boolean isCorrectRope(class_2248 ropeBlock, class_2680 state, class_2350 direction) {
        if (state.method_26204() instanceof class_5172 && state.method_11654((class_2769)class_5172.field_11459) != direction.method_10166()) {
            return false;
        }
        return ropeBlock == state.method_26204();
    }

    public static boolean tryPlaceAndMove(@Nullable class_1657 player, class_1268 hand, class_1937 world, class_2338 pos, class_2248 ropeBlock, class_2350 moveDir, boolean canPush) {
        class_2680 state;
        class_1799 stack = new class_1799((class_1935)ropeBlock);
        class_1750 context = new class_1750(world, player, hand, stack, new class_3965(class_243.method_24953((class_2382)pos), moveDir.method_10153(), pos, false));
        if (!context.method_7716()) {
            class_2338 downPos = pos.method_10093(moveDir);
            if (!(canPush && world.method_8320(downPos).method_45474() && RopeHelper.tryMove(pos, downPos, world))) {
                return false;
            }
            context = new class_1750(world, player, hand, stack, new class_3965(class_243.method_24953((class_2382)pos), moveDir.method_10153(), pos, false));
        }
        if ((state = ItemsUtil.getPlacementState(context, ropeBlock)) == null) {
            return false;
        }
        if (state == world.method_8320(context.method_8037())) {
            return false;
        }
        if (world.method_8652(context.method_8037(), state, 11)) {
            class_2680 placedState;
            class_2248 block;
            if (player != null && (block = (placedState = world.method_8320(context.method_8037())).method_26204()) == state.method_26204()) {
                block.method_9567(world, context.method_8037(), placedState, (class_1309)player, stack);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_1191.method_23889(serverPlayer, context.method_8037(), stack);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isBlockMovable(class_2680 state, class_1937 level, class_2338 pos) {
        if (state.method_26204() instanceof PulleyBlock) {
            return false;
        }
        return !state.method_26215() && !state.method_27852(class_2246.field_10540) && !state.method_27852(class_2246.field_10260) && !state.method_27852(class_2246.field_22423) && !state.method_27852(class_2246.field_23152) && state.method_26214((class_1922)level, pos) != -1.0f;
    }

    public static boolean removeRopeDown(class_2338 pos, class_1937 level, class_2248 ropeBlock) {
        return RopeHelper.removeRope(pos, level, ropeBlock, class_2350.field_11033, Integer.MAX_VALUE);
    }

    public static boolean removeRope(class_2338 pos, class_1937 level, class_2248 ropeBlock, class_2350 moveUpDir, int maxDist) {
        PulleyBlockTile te;
        class_2586 class_25862;
        if (maxDist <= 0) {
            return false;
        }
        --maxDist;
        class_2680 state = level.method_8320(pos);
        if (RopeHelper.isCorrectRope(ropeBlock, state, moveUpDir)) {
            return RopeHelper.removeRope(pos.method_10093(moveUpDir), level, ropeBlock, moveUpDir, maxDist);
        }
        if (state.method_27852(ModRegistry.PULLEY_BLOCK.get()) && (class_25862 = level.method_8321(pos)) instanceof PulleyBlockTile && !(te = (PulleyBlockTile)class_25862).method_5442()) {
            return te.rotateIndirect(null, class_1268.field_5808, ropeBlock, moveUpDir, true);
        }
        class_2338 up = pos.method_10093(moveUpDir.method_10153());
        if (level.method_8320(up).method_26204() != ropeBlock) {
            return false;
        }
        class_3610 fromFluid = level.method_8316(up);
        boolean water = fromFluid.method_15772() == class_3612.field_15910 && fromFluid.method_15771();
        level.method_8501(up, water ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
        RopeHelper.tryMove(pos, up, level);
        return true;
    }

    private static boolean tryMove(class_2338 fromPos, class_2338 toPos, class_1937 world) {
        if (toPos.method_10264() < world.method_31607() || toPos.method_10264() > world.method_31600()) {
            return false;
        }
        class_2680 state = world.method_8320(fromPos);
        class_3619 push = state.method_26223();
        if (RopeHelper.isBlockMovable(state, world, fromPos) && ((push == class_3619.field_15974 || toPos.method_10264() < fromPos.method_10264() && push == class_3619.field_15970) && state.method_26184((class_4538)world, toPos) || state.method_26164(ModTags.ROPE_HANG_TAG))) {
            class_3610 fromFluid;
            class_3611 fluidState;
            class_2586 tile = world.method_8321(fromPos);
            if (tile != null) {
                if (CompatHandler.QUARK && !QuarkCompat.canMoveBlockEntity(state)) {
                    return false;
                }
                tile.method_11012();
            }
            boolean waterFluid = (fluidState = world.method_8316(toPos).method_15772()) == class_3612.field_15910;
            boolean canHoldWater = false;
            if (state.method_28498((class_2769)class_2741.field_12508)) {
                canHoldWater = state.method_26164(ModTags.WATER_HOLDER);
                if (!canHoldWater) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(waterFluid));
                }
            } else if (state.method_26204() instanceof class_2275) {
                if (waterFluid && state.method_27852(class_2246.field_10593) || state.method_27852(class_2246.field_27097)) {
                    state = (class_2680)class_2246.field_27097.method_9564().method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(3));
                }
                if (fluidState == class_3612.field_15908 && state.method_27852(class_2246.field_10593) || state.method_27852(class_2246.field_27098)) {
                    state = class_2246.field_27098.method_9564();
                }
            }
            boolean leaveWater = (fromFluid = world.method_8316(fromPos)).method_15772() == class_3612.field_15910 && fromFluid.method_15771() && !canHoldWater;
            world.method_8501(fromPos, leaveWater ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564());
            class_2680 newState = class_2248.method_9510((class_2680)state, (class_1936)world, (class_2338)toPos);
            world.method_8501(toPos, newState);
            if (tile != null) {
                class_2487 tag = tile.method_38244();
                class_2586 te = world.method_8321(toPos);
                if (te != null) {
                    te.method_11014(tag);
                }
            }
            world.method_8492(toPos, state.method_26204(), toPos);
            return true;
        }
        return false;
    }
}

