/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.electricring;

import com.google.common.collect.Lists;
import com.telepathicgrunt.the_bumblezone.client.rendering.electricring.ElectricRingModel;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ElectricRingEntity;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

public class ElectricRingRenderer<M extends class_583<ElectricRingEntity>>
extends class_897<ElectricRingEntity>
implements class_3883<ElectricRingEntity, M> {
    static final class_2960 SKIN_1 = new class_2960("the_bumblezone", "textures/entity/electric_ring/electric_ring_1.png");
    static final class_2960 SKIN_2 = new class_2960("the_bumblezone", "textures/entity/electric_ring/electric_ring_2.png");
    static final class_2960 SKIN_3 = new class_2960("the_bumblezone", "textures/entity/electric_ring/electric_ring_3.png");
    protected final ElectricRingModel<ElectricRingEntity> model;
    protected final List<class_3887<ElectricRingEntity, M>> layers = Lists.newArrayList();

    public ElectricRingRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new ElectricRingModel(context.method_32167(ElectricRingModel.LAYER_LOCATION));
    }

    protected final boolean addLayer(class_3887<ElectricRingEntity, M> renderLayer) {
        return this.layers.add(renderLayer);
    }

    public M method_4038() {
        return (M)((Object)this.model);
    }

    public void render(ElectricRingEntity ringEntity, float yRot, float partialTicks, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        packedLight = 0xF000F0;
        float angleExtra = -180.0f;
        int interval = 3;
        int state = ringEntity.field_6012 / interval;
        float spinSpeed = 15.0f;
        float angle = ((float)ringEntity.field_6012 + partialTicks) * spinSpeed;
        angle += (float)state * angleExtra;
        poseStack.method_22903();
        float rotationLerp = class_3532.method_16439((float)partialTicks, (float)ringEntity.field_6004, (float)ringEntity.method_36455());
        float scale = ringEntity.disappearingTime >= 0 ? Math.min(((float)ringEntity.disappearingTime - partialTicks) / 20.0f, 1.0f) : Math.min(((float)ringEntity.field_6012 + partialTicks) / 20.0f, 1.0f);
        poseStack.method_22905(-scale, -scale, scale);
        poseStack.method_46416(0.0f, -1.0f - (1.5f - scale * 1.5f), 0.0f);
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180.0f - ringEntity.method_36454()));
        poseStack.method_22907(class_7833.field_40713.rotationDegrees(180.0f - ringEntity.method_36455()));
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(angle % 360.0f));
        this.model.method_2816(ringEntity, 0.0f, 0.0f, partialTicks);
        this.model.method_2819(ringEntity, 0.0f, 0.0f, 0.0f, 0.0f, rotationLerp);
        class_310 minecraft = class_310.method_1551();
        boolean bodyVisible = this.isBodyVisible(ringEntity);
        boolean hidden = !bodyVisible && !ringEntity.method_5756((class_1657)minecraft.field_1724);
        boolean glowing = minecraft.method_27022((class_1297)ringEntity);
        class_1921 renderType = this.getRenderType(ringEntity, bodyVisible, hidden, glowing);
        if (renderType != null) {
            class_4588 vertexConsumer = multiBufferSource.getBuffer(renderType);
            this.model.method_2828(poseStack, vertexConsumer, packedLight, 0, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!ringEntity.method_7325()) {
            for (class_3887<ElectricRingEntity, M> renderLayer : this.layers) {
                renderLayer.method_4199(poseStack, multiBufferSource, packedLight, (class_1297)ringEntity, 0.0f, 0.0f, partialTicks, 0.0f, 0.0f, rotationLerp);
            }
        }
        poseStack.method_22909();
        super.method_3936((class_1297)ringEntity, yRot, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    @Nullable
    protected class_1921 getRenderType(ElectricRingEntity ringEntity, boolean bodyVisible, boolean hidden, boolean glowing) {
        class_2960 resourceLocation = this.getTextureLocation(ringEntity);
        if (bodyVisible) {
            return this.model.method_23500(resourceLocation);
        }
        if (glowing) {
            return class_1921.method_23287((class_2960)resourceLocation);
        }
        return null;
    }

    protected boolean isBodyVisible(ElectricRingEntity ringEntity) {
        return !ringEntity.method_5767();
    }

    public class_2960 getTextureLocation(ElectricRingEntity ringEntity) {
        int interval = 3;
        int state = ringEntity.field_6012 % (interval * 3);
        if (state < interval) {
            return SKIN_1;
        }
        if (state < interval * 2) {
            return SKIN_2;
        }
        return SKIN_3;
    }
}

