/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.living;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlockWhite;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.LivingEntityAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_128;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_148;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2718;
import net.minecraft.class_2783;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5575;
import net.minecraft.class_7094;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CosmicCrystalEntity
extends class_1309 {
    public static final class_2941<CosmicCrystalState> COSMIC_CRYSTAL_STATE_SERIALIZER = class_2941.method_43240(CosmicCrystalState.class);
    private static final class_2940<CosmicCrystalState> COSMIC_CRYSTAL_STATE = class_2945.method_12791(CosmicCrystalEntity.class, COSMIC_CRYSTAL_STATE_SERIALIZER);
    private static final class_2940<Integer> INITIAL_ROTATION_ANIMATION_TIMESPAN = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> STATE_TIMESPAN = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LASER_START_DELAY = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LASER_FIRE_START_TIME = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SYNCED_CURRENT_STATE_TIME_TICK = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ORBIT_OFFSET_DEGREES = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DIFFICULTY_BOOST = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> COLLIDED = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SECOND_PHASE = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> ESSENCE_CONTROLLER_UUID = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<class_2338>> ESSENCE_CONTROLLER_BLOCK_POS = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<String> ESSENCE_CONTROLLER_DIMENSION = class_2945.method_12791(CosmicCrystalEntity.class, (class_2941)class_2943.field_13326);
    private static final class_243 UP_VECT = new class_243(0.0, 1.0, 0.0);
    private static final class_243 POSITIVE_X_VECT = new class_243(1.0, 0.0, 0.0);
    public static final int MAX_RANGE = 30;
    protected static final class_4051 TARGETING_CONDITIONS = class_4051.method_36625().method_18418(30.0).method_18420(livingEntity -> !(livingEntity instanceof CosmicCrystalEntity) && livingEntity.method_6102());
    public final class_7094 idleAnimationState = new class_7094();
    private final class_2371<class_1799> armorItems = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    private UUID targetEntityUUID = null;
    private class_1297 targetEntity = null;
    private class_243 prevTargetPosition = new class_243(0.0, 0.0, 0.0);
    public int currentStateTimeTick = 0;
    public int currentTickCount = 0;
    public int animationTimeTick = 0;
    public int prevAnimationTick = 0;
    public class_243 prevLookAngle = new class_243(1.0, 0.0, 0.0);
    private boolean laserChargeSoundPlayed = false;
    public int lastPhysicalHit = 0;
    public final ArrayDeque<CosmicCrystalState> pastStates = new ArrayDeque();
    private boolean noAI = false;

    public CosmicCrystalEntity(class_1299<? extends CosmicCrystalEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.idleAnimationState.method_41322(this.field_6012);
        this.field_5985 = true;
    }

    public static class_5132.class_5133 getAttributeBuilder() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, (double)BzGeneralConfigs.cosmicCrystalHealth).method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, 30.0);
    }

    public UUID getEssenceController() {
        return ((Optional)this.field_6011.method_12789(ESSENCE_CONTROLLER_UUID)).orElse(null);
    }

    public void setEssenceController(UUID essenceController) {
        this.field_6011.method_12778(ESSENCE_CONTROLLER_UUID, Optional.of(essenceController));
    }

    public class_2338 getEssenceControllerBlockPos() {
        return ((Optional)this.field_6011.method_12789(ESSENCE_CONTROLLER_BLOCK_POS)).orElse(null);
    }

    public void setEssenceControllerBlockPos(class_2338 essenceControllerBlockPos) {
        this.field_6011.method_12778(ESSENCE_CONTROLLER_BLOCK_POS, essenceControllerBlockPos == null ? Optional.empty() : Optional.of(essenceControllerBlockPos));
    }

    public class_5321<class_1937> getEssenceControllerDimension() {
        String dimensionString = (String)this.field_6011.method_12789(ESSENCE_CONTROLLER_DIMENSION);
        if (dimensionString == null || dimensionString.isEmpty()) {
            return null;
        }
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimensionString));
    }

    public void setEssenceControllerDimension(class_5321<class_1937> essenceControllerDimension) {
        this.field_6011.method_12778(ESSENCE_CONTROLLER_DIMENSION, (Object)essenceControllerDimension.method_29177().toString());
    }

    public int getOrbitOffsetDegrees() {
        return (Integer)this.field_6011.method_12789(ORBIT_OFFSET_DEGREES);
    }

    public void setOrbitOffsetDegrees(int orbitOffsetDegrees) {
        this.field_6011.method_12778(ORBIT_OFFSET_DEGREES, (Object)orbitOffsetDegrees);
    }

    public float getDifficultyBoost() {
        return ((Float)this.field_6011.method_12789(DIFFICULTY_BOOST)).floatValue();
    }

    public void setDifficultyBoost(float difficultyBoost) {
        this.field_6011.method_12778(DIFFICULTY_BOOST, (Object)Float.valueOf(difficultyBoost));
    }

    public void setCosmicCrystalState(CosmicCrystalState cosmicCrystalState) {
        if (!this.method_37908().method_8608() && cosmicCrystalState != this.getCosmicCrystalState()) {
            if (this.field_6012 > 1) {
                this.currentStateTimeTick = 0;
                this.lastPhysicalHit = 0;
                this.setSecondPhase(false);
            }
            if (this.targetEntity != null) {
                this.prevTargetPosition = this.targetEntity.method_19538();
            }
            this.pastStates.addFirst(this.getCosmicCrystalState());
            if (this.pastStates.size() > 8) {
                this.pastStates.removeLast();
            }
            this.field_6011.method_12778(COSMIC_CRYSTAL_STATE, (Object)cosmicCrystalState);
            switch (this.getCosmicCrystalState()) {
                case NORMAL: {
                    this.setInitialRotationAnimationTimespan(40);
                    this.setStateTimespan(Integer.MAX_VALUE);
                    break;
                }
                case TRACKING_SMASHING_ATTACK: {
                    this.setInitialRotationAnimationTimespan((int)(100.0f - 40.0f * this.getDifficultyBoost() + (float)(this.getOrbitOffsetDegrees() / 3)));
                    this.setStateTimespan(450);
                    this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_CRASH_CHARGE.get(), class_3419.field_15251, 1.0f, 1.0f);
                    break;
                }
                case TRACKING_SPINNING_ATTACK: {
                    int timeOffset = (int)((float)this.getOrbitOffsetDegrees() * this.getDifficultyBoost() * this.getDifficultyBoost());
                    this.setInitialRotationAnimationTimespan(20 + timeOffset);
                    this.setStateTimespan((int)((float)timeOffset + this.getDifficultyBoost() * this.getDifficultyBoost() * 80.0f));
                    break;
                }
                case VERTICAL_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(20);
                    this.setLaserFireStartTime(60);
                    this.setStateTimespan(400);
                    break;
                }
                case HORIZONTAL_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(40);
                    this.setLaserFireStartTime(80);
                    this.setStateTimespan(350);
                    break;
                }
                case SWEEP_LASER: {
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay(60);
                    this.setLaserFireStartTime(80);
                    this.setStateTimespan(400);
                    break;
                }
                case TRACKING_LASER: {
                    int timeOffset = this.getOrbitOffsetDegrees() / 3;
                    this.setInitialRotationAnimationTimespan((int)(40.0f + 20.0f * this.getDifficultyBoost()));
                    this.setLaserStartDelay((int)(40.0f + 20.0f * this.getDifficultyBoost() + (float)timeOffset));
                    this.setLaserFireStartTime(80 + timeOffset);
                    this.setStateTimespan(180 + timeOffset);
                }
            }
        }
    }

    public CosmicCrystalState getCosmicCrystalState() {
        return (CosmicCrystalState)((Object)this.field_6011.method_12789(COSMIC_CRYSTAL_STATE));
    }

    public void setInitialRotationAnimationTimespan(int initialRotationAnimationTimespan) {
        this.animationTimeTick = 0;
        this.prevAnimationTick = 0;
        this.field_6011.method_12778(INITIAL_ROTATION_ANIMATION_TIMESPAN, (Object)initialRotationAnimationTimespan);
        this.setCollided(false);
    }

    public int getInitialRotationAnimationTimespan() {
        return (Integer)this.field_6011.method_12789(INITIAL_ROTATION_ANIMATION_TIMESPAN);
    }

    public void setStateTimespan(int stateTimespan) {
        this.field_6011.method_12778(STATE_TIMESPAN, (Object)stateTimespan);
    }

    public int getStateTimespan() {
        return (Integer)this.field_6011.method_12789(STATE_TIMESPAN);
    }

    public void setLaserStartDelay(int laserStartDelay) {
        this.laserChargeSoundPlayed = false;
        this.field_6011.method_12778(LASER_START_DELAY, (Object)laserStartDelay);
    }

    public int getLaserStartDelay() {
        return (Integer)this.field_6011.method_12789(LASER_START_DELAY);
    }

    public void setLaserFireStartTime(int laserFireStartTime) {
        this.field_6011.method_12778(LASER_FIRE_START_TIME, (Object)laserFireStartTime);
    }

    public int getLaserFireStartTime() {
        return (Integer)this.field_6011.method_12789(LASER_FIRE_START_TIME);
    }

    public void setSyncedCurrentStateTimeTick(int syncedCurrentStateTimeTick) {
        this.field_6011.method_12778(SYNCED_CURRENT_STATE_TIME_TICK, (Object)syncedCurrentStateTimeTick);
    }

    public int getSyncedCurrentStateTimeTick() {
        return (Integer)this.field_6011.method_12789(SYNCED_CURRENT_STATE_TIME_TICK);
    }

    public void setCollided(boolean collided) {
        this.field_6011.method_12778(COLLIDED, (Object)collided);
    }

    public boolean getCollided() {
        return (Boolean)this.field_6011.method_12789(COLLIDED);
    }

    public void setSecondPhase(boolean smashingPhase) {
        this.field_6011.method_12778(SECOND_PHASE, (Object)smashingPhase);
    }

    public boolean getSecondPhase() {
        return (Boolean)this.field_6011.method_12789(SECOND_PHASE);
    }

    public void setTargetEntityUUID(UUID targetEntityUUID) {
        this.targetEntityUUID = targetEntityUUID;
    }

    public UUID getTargetEntityUUID() {
        return this.targetEntityUUID;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(COSMIC_CRYSTAL_STATE, (Object)CosmicCrystalState.NORMAL);
        this.field_6011.method_12784(INITIAL_ROTATION_ANIMATION_TIMESPAN, (Object)0);
        this.field_6011.method_12784(STATE_TIMESPAN, (Object)0);
        this.field_6011.method_12784(LASER_START_DELAY, (Object)0);
        this.field_6011.method_12784(LASER_FIRE_START_TIME, (Object)0);
        this.field_6011.method_12784(SYNCED_CURRENT_STATE_TIME_TICK, (Object)0);
        this.field_6011.method_12784(ORBIT_OFFSET_DEGREES, (Object)0);
        this.field_6011.method_12784(DIFFICULTY_BOOST, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(COLLIDED, (Object)false);
        this.field_6011.method_12784(SECOND_PHASE, (Object)false);
        this.field_6011.method_12784(ESSENCE_CONTROLLER_UUID, Optional.empty());
        this.field_6011.method_12784(ESSENCE_CONTROLLER_BLOCK_POS, Optional.empty());
        this.field_6011.method_12784(ESSENCE_CONTROLLER_DIMENSION, (Object)"");
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        super.method_5674(entityDataAccessor);
        if (COSMIC_CRYSTAL_STATE.equals(entityDataAccessor) && this.field_6012 > 1) {
            this.animationTimeTick = 0;
            this.prevAnimationTick = 0;
            this.currentStateTimeTick = 0;
            this.lastPhysicalHit = 0;
            if (this.targetEntity != null) {
                this.prevTargetPosition = this.targetEntity.method_19538();
            }
        } else if (SYNCED_CURRENT_STATE_TIME_TICK.equals(entityDataAccessor)) {
            this.currentStateTimeTick = this.getSyncedCurrentStateTimeTick();
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("essenceController")) {
            this.setEssenceController(compoundTag.method_25926("essenceController"));
        }
        if (compoundTag.method_10545("essenceControllerBlockPos")) {
            this.setEssenceControllerBlockPos(class_2512.method_10691((class_2487)compoundTag.method_10562("essenceControllerBlockPos")));
        }
        if (compoundTag.method_10545("essenceControllerDimension")) {
            this.setEssenceControllerDimension((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compoundTag.method_10558("essenceControllerDimension"))));
        }
        if (compoundTag.method_10545("prevCosmicCrystalState")) {
            this.setCosmicCrystalState(CosmicCrystalState.valueOf(compoundTag.method_10558("prevCosmicCrystalState")));
        }
        if (compoundTag.method_10545("cosmicCrystalState")) {
            this.setCosmicCrystalState(CosmicCrystalState.valueOf(compoundTag.method_10558("cosmicCrystalState")));
        }
        this.setInitialRotationAnimationTimespan(compoundTag.method_10550("initialRotationAnimationTimespan"));
        this.setStateTimespan(compoundTag.method_10550("stateTimespan"));
        this.setLaserStartDelay(compoundTag.method_10550("laserStartDelay"));
        this.setLaserFireStartTime(compoundTag.method_10550("laserFireStartTime"));
        this.setSecondPhase(compoundTag.method_10577("secondPhase"));
        this.setCollided(compoundTag.method_10577("collided"));
        this.setOrbitOffsetDegrees(compoundTag.method_10550("orbitOffsetDegrees"));
        if (compoundTag.method_10545("difficultyBoost")) {
            this.setDifficultyBoost(compoundTag.method_10583("difficultyBoost"));
        }
        this.currentStateTimeTick = compoundTag.method_10550("currentStateTimeTick");
        this.setSyncedCurrentStateTimeTick(this.currentStateTimeTick);
        this.animationTimeTick = compoundTag.method_10550("animationTimeTick");
        this.prevAnimationTick = compoundTag.method_10550("prevAnimationTick");
        if (compoundTag.method_10545("targetEntityUUID")) {
            this.targetEntityUUID = compoundTag.method_25926("targetEntityUUID");
        }
        if (compoundTag.method_10545("prevLookAngle")) {
            class_2487 vectTag = compoundTag.method_10562("prevLookAngle");
            this.prevLookAngle = new class_243(vectTag.method_10574("x"), vectTag.method_10574("y"), vectTag.method_10574("z"));
        }
        this.noAI = compoundTag.method_10577("NoAI") || compoundTag.method_10577("noAI") || compoundTag.method_10577("noAi");
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        if (this.getEssenceController() != null) {
            compoundTag.method_25927("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.method_10566("essenceControllerBlockPos", (class_2520)class_2512.method_10692((class_2338)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.method_10582("essenceControllerDimension", this.getEssenceControllerDimension().method_29177().toString());
        }
        compoundTag.method_10582("cosmicCrystalState", this.getCosmicCrystalState().name());
        compoundTag.method_10569("initialRotationAnimationTimespan", this.getInitialRotationAnimationTimespan());
        compoundTag.method_10569("stateTimespan", this.getStateTimespan());
        compoundTag.method_10569("laserStartDelay", this.getLaserStartDelay());
        compoundTag.method_10569("laserFireStartTime", this.getLaserFireStartTime());
        compoundTag.method_10556("secondPhase", this.getSecondPhase());
        compoundTag.method_10556("collided", this.getCollided());
        compoundTag.method_10569("orbitOffsetDegrees", this.getOrbitOffsetDegrees());
        compoundTag.method_10548("difficultyBoost", this.getDifficultyBoost());
        compoundTag.method_10569("currentStateTimeTick", this.currentStateTimeTick);
        compoundTag.method_10569("animationTimeTick", this.animationTimeTick);
        compoundTag.method_10569("prevAnimationTick", this.prevAnimationTick);
        if (this.targetEntityUUID != null) {
            compoundTag.method_25927("targetEntityUUID", this.targetEntityUUID);
        }
        class_2487 vectTag = new class_2487();
        vectTag.method_10549("x", this.prevLookAngle.method_10216());
        vectTag.method_10549("y", this.prevLookAngle.method_10214());
        vectTag.method_10549("z", this.prevLookAngle.method_10215());
        compoundTag.method_10566("prevLookAngle", (class_2520)vectTag);
        if (compoundTag.method_10545("noAi")) {
            compoundTag.method_10556("noAi", this.noAI);
        } else if (compoundTag.method_10545("noAI")) {
            compoundTag.method_10556("noAI", this.noAI);
        } else {
            compoundTag.method_10556("NoAI", this.noAI);
        }
    }

    public static boolean isOrFromHorizontalState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_SPINNING_ATTACK;
    }

    public static boolean isLaserState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.VERTICAL_LASER || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER;
    }

    public static boolean isTrackingState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_SMASHING_ATTACK || cosmicCrystalState == CosmicCrystalState.TRACKING_SPINNING_ATTACK || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER;
    }

    public static boolean isOrbitState(CosmicCrystalState cosmicCrystalState) {
        return cosmicCrystalState == CosmicCrystalState.NORMAL || cosmicCrystalState == CosmicCrystalState.HORIZONTAL_LASER || cosmicCrystalState == CosmicCrystalState.VERTICAL_LASER || cosmicCrystalState == CosmicCrystalState.TRACKING_LASER || cosmicCrystalState == CosmicCrystalState.SWEEP_LASER;
    }

    public boolean isLaserFiring() {
        boolean isLaserState = CosmicCrystalEntity.isLaserState(this.getCosmicCrystalState());
        return isLaserState && this.currentStateTimeTick > this.getLaserFireStartTime();
    }

    public void method_5773() {
        if (this.field_6012 == 1) {
            if (this.method_37908().method_8608()) {
                this.spawnLargeParticleCloud(3);
            }
            this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_SPAWN_EXPLOSION.get(), class_3419.field_15251, 1.0f, 1.0f);
        }
        if (this.method_29504() && this.method_37908().method_38989((class_1297)this)) {
            this.method_6108();
        }
        if (this.noAI) {
            return;
        }
        if (!this.method_37908().method_8608() && !this.checkIfStillInEvent()) {
            return;
        }
        if (this.getCosmicCrystalState() == CosmicCrystalState.NORMAL) {
            this.setTargetEntityUUID(null);
            this.targetEntity = null;
            if (this.getEssenceController() == null && this.currentStateTimeTick > 50) {
                CosmicCrystalState chosenAttack;
                while (this.pastStates.contains((Object)(chosenAttack = CosmicCrystalState.values()[this.method_6051().method_43048(CosmicCrystalState.values().length)])) || chosenAttack == CosmicCrystalState.NORMAL) {
                }
                this.setCosmicCrystalState(chosenAttack);
            }
        } else if (!this.method_37908().method_8608() && this.field_6012 % 5 == 0) {
            this.setSyncedCurrentStateTimeTick(this.currentStateTimeTick);
        }
        this.prevLookAngle = this.method_5720();
        this.orbitMovement();
        this.spinningTrackingBehaviour();
        super.method_5773();
        this.incrementAnimationAndRotationTicks();
        this.spawnFancyParticlesOnClient();
        this.laserBreakBlocks();
        this.smashingBehaviour();
        this.destroyTouchingBlocks();
        ++this.currentStateTimeTick;
        ++this.currentTickCount;
    }

    private boolean checkIfStillInEvent() {
        class_2338 essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null) {
            return false;
        }
        if (this.field_6012 % 20 != 0 && this.method_24515().method_19455((class_2382)essenceBlockPos) < 16) {
            return true;
        }
        UUID essenceUuid = this.getEssenceController();
        class_5321<class_1937> essenceDimension = this.getEssenceControllerDimension();
        if (essenceUuid == null || essenceDimension == null) {
            return false;
        }
        class_2338 blockPos = this.method_24515();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.method_37908(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            class_2338 arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.method_10263() - essenceBlockPos.method_10263()) > arenaSize.method_10263() / 2 || Math.abs(blockPos.method_10264() - essenceBlockPos.method_10264()) > arenaSize.method_10264() / 2 || Math.abs(blockPos.method_10260() - essenceBlockPos.method_10260()) > arenaSize.method_10260() / 2) {
                this.method_5650(class_1297.class_5529.field_26999);
                return false;
            }
        } else {
            this.method_5650(class_1297.class_5529.field_26999);
            return false;
        }
        return true;
    }

    private void orbitMovement() {
        if (this.getEssenceControllerBlockPos() != null) {
            class_243 orbitPosition;
            if (CosmicCrystalEntity.isOrbitState(this.getCosmicCrystalState())) {
                orbitPosition = this.getEssenceControllerBlockPos().method_46558().method_1031(0.0, -1.0, 0.0);
                if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER && this.targetEntity != null) {
                    class_243 targetPos = this.targetEntity.method_19538().method_1031(0.0, 0.25, 0.0);
                    class_243 diffFromNow = this.prevTargetPosition.method_1020(targetPos).method_1021(0.97);
                    this.prevTargetPosition = diffFromNow.method_1019(targetPos);
                    orbitPosition = new class_243(orbitPosition.method_10216(), this.prevTargetPosition.method_10214(), orbitPosition.method_10215());
                }
            } else {
                return;
            }
            float orbitOffsetDegrees = (float)this.getOrbitOffsetDegrees() * ((float)Math.PI / 180);
            float difficultyBoost = this.getDifficultyBoost();
            float radius = 4.0f;
            if (this.getCosmicCrystalState() == CosmicCrystalState.VERTICAL_LASER) {
                radius = (Math.max(-1.0f, Math.min(1.0f, class_3532.method_15374((float)((float)(this.currentTickCount * 3) * ((float)Math.PI / 180))) * 1.25f)) + 1.0f) * 13.0f;
            }
            float spinRadians = (float)((double)this.currentTickCount * Math.pow(difficultyBoost, 5.0) % 360.0 * 0.01745329238474369);
            Vector3f rotationOffset = POSITIVE_X_VECT.method_46409().rotateY(orbitOffsetDegrees + spinRadians);
            class_243 targetOrbitSpot = orbitPosition.method_1019(new class_243(rotationOffset).method_1021((double)radius));
            class_243 diffToTargetOrbitSpot = targetOrbitSpot.method_1020(this.method_19538());
            double xzScale = Math.abs(diffToTargetOrbitSpot.method_37267()) * 0.05 * (double)difficultyBoost;
            double yScale = Math.abs(diffToTargetOrbitSpot.method_10214()) * 0.1 * (double)difficultyBoost;
            this.method_18799(diffToTargetOrbitSpot.method_1029().method_18805(xzScale, yScale, xzScale));
        }
    }

    private void spawnFancyParticlesOnClient() {
        if (this.method_37908().method_8608()) {
            if (this.field_6012 % 5 == 0 || this.field_6235 > 0) {
                class_243 center = this.method_5829().method_1005();
                this.spawnFancyParticle(center);
                if (this.field_6235 == 8) {
                    for (int i = 0; i < 50; ++i) {
                        this.spawnFancyParticle(center);
                    }
                }
            }
            if (this.isLaserFiring()) {
                this.spawnFancyParticle(this.method_33571().method_1019(this.method_5720().method_1021((double)1.2f)));
            }
        }
    }

    private void incrementAnimationAndRotationTicks() {
        this.prevAnimationTick = this.animationTimeTick;
        if (this.animationTimeTick < this.getInitialRotationAnimationTimespan()) {
            ++this.animationTimeTick;
        } else if (this.getCosmicCrystalState() != CosmicCrystalState.NORMAL && this.currentStateTimeTick >= this.getStateTimespan()) {
            this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
        }
        this.method_18382();
        this.setupTargetForTrackingStates();
        float progress = this.getInitialRotationAnimationTimespan() == 0 ? 1.0f : (float)this.animationTimeTick / (float)this.getInitialRotationAnimationTimespan();
        this.setActualRotations((float)Math.pow(progress, 4.0));
    }

    private void setActualRotations(float progress) {
        class_243 currentLookAngle = this.method_5720();
        class_243 desiredLookPosition = this.method_33571().method_1031(0.0, -1.0, 0.0);
        class_243 currentLookPosition = this.method_33571().method_1019(currentLookAngle);
        if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
            if (this.getEssenceControllerBlockPos() != null) {
                class_243 anchorPoint = new class_243((double)this.getEssenceControllerBlockPos().method_10263() + 0.5, this.method_23320(), (double)this.getEssenceControllerBlockPos().method_10260() + 0.5);
                class_243 diff = this.method_33571().method_1020(anchorPoint);
                desiredLookPosition = this.method_33571().method_1019(diff);
            } else {
                desiredLookPosition = this.method_33571().method_1019(this.method_5631(0.0f, this.method_36454()));
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_LASER) {
            if (this.targetEntity != null) {
                class_243 targetPos = this.targetEntity.method_19538().method_1031(0.0, 0.25, 0.0);
                double difficultyMultiplier = (this.getDifficultyBoost() - 1.0f) / 3.0f;
                double targetStrength = 0.94 - difficultyMultiplier;
                class_243 diffFromNow = this.prevTargetPosition.method_1020(targetPos).method_1021(targetStrength);
                this.prevTargetPosition = diffFromNow.method_1019(targetPos);
                if (diffFromNow.method_1033() > 3.0) {
                    diffFromNow.method_1021(3.0 / diffFromNow.method_1033());
                }
                desiredLookPosition = diffFromNow.method_1019(targetPos);
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.SWEEP_LASER) {
            class_243 crossProduct;
            class_243 targetPos = null;
            class_243 directionToTarget = null;
            if (this.getEssenceControllerBlockPos() != null) {
                targetPos = this.getEssenceControllerBlockPos().method_46558();
                directionToTarget = this.method_19538().method_1020(targetPos).method_1029();
            } else if (this.targetEntity != null) {
                if (!this.getSecondPhase()) {
                    this.prevTargetPosition = this.targetEntity.method_19538().method_1031(0.0, 0.25, 0.0);
                    this.setSecondPhase(true);
                }
                targetPos = this.prevTargetPosition;
                directionToTarget = this.method_19538().method_1020(targetPos).method_1029();
            }
            if (directionToTarget != null && targetPos != null && (crossProduct = new class_243(UP_VECT.method_10214() * directionToTarget.method_10215() - UP_VECT.method_10215() * directionToTarget.method_10214(), UP_VECT.method_10215() * directionToTarget.method_10216() - UP_VECT.method_10216() * directionToTarget.method_10215(), UP_VECT.method_10216() * directionToTarget.method_10214() - UP_VECT.method_10214() * directionToTarget.method_10216()).method_1029()).method_1033() != 0.0) {
                double difficultyMultiplier = (double)(this.getDifficultyBoost() - 1.0f) * 1.5 + 1.0;
                float spinRadians = (float)((double)(this.currentStateTimeTick * 3) * difficultyMultiplier * 0.01745329238474369);
                Vector3f vectorToRotate = directionToTarget.method_46409();
                Vector3f axisToRotateAround = crossProduct.method_46409();
                Vector3f finalLookSpot = vectorToRotate.rotateAxis(spinRadians, axisToRotateAround.x(), axisToRotateAround.y(), axisToRotateAround.z());
                desiredLookPosition = new class_243(finalLookSpot).method_1019(this.method_33571());
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if ((this.currentStateTimeTick <= moveTime || this.getSecondPhase()) && this.targetEntity != null) {
                class_243 targetPos = this.targetEntity.method_19538().method_1031(0.0, 0.25, 0.0);
                class_243 diffFromNow = this.prevTargetPosition.method_1020(targetPos).method_1021(0.9);
                this.prevTargetPosition = diffFromNow.method_1019(targetPos);
                desiredLookPosition = diffFromNow.method_1019(targetPos);
            } else {
                desiredLookPosition = this.method_33571().method_1031(0.0, -1.0, 0.0);
            }
        } else if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK) {
            class_243 targetPos;
            float windDownDuration = 40.0f;
            int windDownPhase = (int)((float)this.getStateTimespan() - windDownDuration);
            if (this.currentStateTimeTick > windDownPhase) {
                double antiProgress = Math.min((float)(this.currentStateTimeTick - windDownPhase) / windDownDuration, 1.0f);
                float spinStrength = (float)(1.0 - antiProgress);
                targetPos = new class_243(class_3532.method_16436((double)antiProgress, (double)(class_3532.method_15374((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))) * spinStrength), (double)0.0), class_3532.method_16436((double)antiProgress, (double)1.0, (double)0.0), class_3532.method_16436((double)antiProgress, (double)(class_3532.method_15362((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))) * spinStrength), (double)0.0));
            } else {
                targetPos = new class_243((double)class_3532.method_15374((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))), (double)class_3532.method_16439((float)progress, (float)0.0f, (float)1.0f), (double)class_3532.method_15362((float)((float)(this.currentStateTimeTick * 40) * ((float)Math.PI / 180))));
            }
            desiredLookPosition = this.method_19538().method_1019(targetPos);
        }
        if (!currentLookPosition.equals((Object)desiredLookPosition)) {
            class_243 lerpedDesiredLook = new class_243(class_3532.method_16436((double)progress, (double)currentLookPosition.method_10216(), (double)desiredLookPosition.method_10216()), class_3532.method_16436((double)progress, (double)currentLookPosition.method_10214(), (double)desiredLookPosition.method_10214()), class_3532.method_16436((double)progress, (double)currentLookPosition.method_10215(), (double)desiredLookPosition.method_10215()));
            this.lookAtCurrent(lerpedDesiredLook);
        }
    }

    private void lookAtCurrent(class_243 vec3) {
        class_243 vec32 = class_2183.class_2184.field_9851.method_9302((class_1297)this);
        double d = vec3.field_1352 - vec32.field_1352;
        double e = vec3.field_1351 - vec32.field_1351;
        double f = vec3.field_1350 - vec32.field_1350;
        double g = Math.sqrt(d * d + f * f);
        this.method_36457(class_3532.method_15393((float)((float)(-(class_3532.method_15349((double)e, (double)g) * 57.2957763671875)))));
        this.method_36456(class_3532.method_15393((float)((float)(class_3532.method_15349((double)f, (double)d) * 57.2957763671875) - 90.0f)));
        this.method_5847(this.method_36454());
    }

    private void setupTargetForTrackingStates() {
        if (CosmicCrystalEntity.isTrackingState(this.getCosmicCrystalState()) && (this.getTargetEntityUUID() == null || this.targetEntity == null || !this.targetEntity.method_5667().equals(this.getTargetEntityUUID()))) {
            if (this.getTargetEntityUUID() != null) {
                this.targetEntity = this.method_37908().method_18470(this.getTargetEntityUUID());
            } else {
                this.targetEntity = this.method_37908().method_18460((class_1297)this, 30.0);
                if (this.targetEntity != null) {
                    this.setTargetEntityUUID(this.targetEntity.method_5667());
                    if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
                        this.prevTargetPosition = this.method_19538();
                    } else if (this.getCosmicCrystalState() != CosmicCrystalState.SWEEP_LASER) {
                        this.prevTargetPosition = this.targetEntity.method_19538();
                    }
                } else {
                    this.targetEntity = this.method_37908().method_21726(class_1309.class, TARGETING_CONDITIONS, (class_1309)this, this.method_23317(), this.method_23318(), this.method_23321(), this.method_5829().method_1014(30.0));
                    if (this.targetEntity != null) {
                        this.setTargetEntityUUID(this.targetEntity.method_5667());
                        if (this.getCosmicCrystalState() == CosmicCrystalState.HORIZONTAL_LASER) {
                            this.prevTargetPosition = this.method_19538();
                        } else if (this.getCosmicCrystalState() != CosmicCrystalState.SWEEP_LASER) {
                            this.prevTargetPosition = this.targetEntity.method_19538();
                        }
                    }
                }
            }
        }
    }

    private void laserBreakBlocks() {
        if (!this.method_37908().method_8608() && this.isLaserFiring()) {
            class_239 hitResult = class_1675.method_49998((class_1297)this, entity -> true, (double)50.0);
            if (hitResult instanceof class_3965) {
                class_3965 blockHitResult = (class_3965)hitResult;
                class_2680 state = this.method_37908().method_8320(blockHitResult.method_17777());
                if (state.method_26204().method_9520() < 1500.0f && !state.method_26164(class_3481.field_17754)) {
                    this.method_37908().method_22352(blockHitResult.method_17777(), true);
                }
            } else if (hitResult instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)hitResult;
                class_1297 entity2 = entityHitResult.method_17782();
                if (entity2 instanceof class_1542) {
                    class_1542 itemEntity = (class_1542)entity2;
                    itemEntity.method_5643(this.method_37908().method_48963().method_48796(BzDamageSources.COSMIC_CRYSTAL_TYPE, (class_1297)this), 10.0f);
                } else if (entity2 instanceof class_1676) {
                    class_1676 projectile = (class_1676)entity2;
                    projectile.method_5650(class_1297.class_5529.field_26998);
                } else if (entity2 instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)entity2;
                    if (!(entity2 instanceof CosmicCrystalEntity) && this.laserHurtAttack(livingEntity)) {
                        return;
                    }
                }
            }
            this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER.get(), class_3419.field_15251, 1.2f, 1.0f);
            this.method_37908().method_45445((class_1297)this, class_2338.method_49638((class_2374)hitResult.method_17784()), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER.get(), class_3419.field_15251, 1.2f, 1.0f);
        } else if (!this.laserChargeSoundPlayed && CosmicCrystalEntity.isLaserState(this.getCosmicCrystalState()) && this.currentStateTimeTick > this.getLaserStartDelay() - 10) {
            this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_LASER_CHARGE.get(), class_3419.field_15251, 1.2f, 1.0f);
            this.laserChargeSoundPlayed = true;
        }
    }

    private void smashingBehaviour() {
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if (this.currentStateTimeTick >= this.getStateTimespan() - 1) {
                this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
                this.method_18800(0.0, 0.0, 0.0);
                this.setCollided(false);
            } else if (this.currentStateTimeTick == moveTime) {
                this.setSecondPhase(true);
            } else if (this.currentStateTimeTick < moveTime) {
                this.method_45319(new class_243(0.0, (double)(1.0f - (float)this.currentStateTimeTick / (float)moveTime) * 0.005, 0.0));
            } else if (!this.getSecondPhase() && this.currentStateTimeTick > moveTime && this.currentStateTimeTick < this.getStateTimespan()) {
                this.setCosmicCrystalState(CosmicCrystalState.NORMAL);
                this.method_18800(0.0, 0.0, 0.0);
                this.setCollided(false);
            } else if (this.targetEntity != null) {
                double crashSpeed = 0.07 * (double)this.getDifficultyBoost();
                this.method_45319(this.method_5720().method_1021(crashSpeed));
                if (this.getCollided() || this.field_5976 || this.field_5992 || this.method_24828()) {
                    this.collidingAttackExplosion();
                }
            } else {
                this.setSecondPhase(false);
            }
        }
    }

    private void collidingAttackExplosion() {
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 3.0f, class_1937.class_7867.field_40890);
            this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_CRASHES.get(), class_3419.field_15251, 1.0f, 1.0f);
            for (class_2338 pos : class_2338.method_10097((class_2338)this.method_24515().method_10069(-2, -2, -2), (class_2338)this.method_24515().method_10069(2, 2, 2))) {
                this.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)this.method_37908().method_8320(pos)));
            }
            this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(16.0)).forEach(e -> {
                if (e instanceof class_1657) {
                    class_1657 player = (class_1657)e;
                    player.method_48761(0.0, 0.0);
                }
            });
            this.setCollided(true);
        } else {
            this.spawnLargeParticleCloud(5);
        }
        this.method_18800(0.0, 0.0, 0.0);
        this.setSecondPhase(false);
    }

    private void spinningTrackingBehaviour() {
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK) {
            int moveTime = this.getInitialRotationAnimationTimespan();
            if (this.currentStateTimeTick >= this.getStateTimespan() - 1) {
                this.method_18800(0.0, 0.0, 0.0);
            } else if (this.targetEntity != null) {
                double progress = this.getInitialRotationAnimationTimespan() == 0 ? 1.0 : (double)((float)this.animationTimeTick / (float)this.getInitialRotationAnimationTimespan());
                progress = Math.pow(progress, 4.0);
                double speedAdj = (double)Math.min(1.0f, (float)this.currentStateTimeTick / (float)moveTime) * progress;
                class_243 targetPos = this.targetEntity.method_19538().method_1031(0.0, 0.25, 0.0);
                class_243 diffFromNow = targetPos.method_1020(this.method_19538());
                class_243 diffFromPast = this.prevTargetPosition.method_1020(this.method_19538());
                float turnStrength = 0.0375f + (this.getDifficultyBoost() - 1.0f) / 30.0f;
                class_243 lerpedLookVector = new class_243(class_3532.method_16436((double)turnStrength, (double)diffFromPast.method_10216(), (double)diffFromNow.method_10216()), class_3532.method_16436((double)turnStrength, (double)diffFromPast.method_10214(), (double)diffFromNow.method_10214()), class_3532.method_16436((double)turnStrength, (double)diffFromPast.method_10215(), (double)diffFromNow.method_10215()));
                this.prevTargetPosition = lerpedLookVector.method_1019(targetPos);
                int hitDiff = this.currentStateTimeTick - this.lastPhysicalHit;
                double cappedSpeed = class_3532.method_16436((double)Math.min((float)hitDiff / 40.0f, 1.0f), (double)0.0, (double)0.65) * speedAdj;
                this.method_18799(lerpedLookVector.method_1029().method_1021(cappedSpeed));
                float inflatedSpeed = 2.0f;
                class_243 originalVect = this.method_18798();
                class_243 inflatedVect = originalVect.method_1021((double)inflatedSpeed);
                class_243 collideVect = ((EntityAccessor)((Object)this)).callCollide(inflatedVect);
                int xDirection = CosmicCrystalEntity.getDirection(inflatedVect.method_10216(), collideVect.method_10216());
                int yDirection = CosmicCrystalEntity.getDirection(inflatedVect.method_10214(), collideVect.method_10214());
                int zDirection = CosmicCrystalEntity.getDirection(inflatedVect.method_10215(), collideVect.method_10215());
                if (xDirection == -1 || yDirection == -1 || zDirection == -1) {
                    this.method_18800(originalVect.method_10216() * (double)xDirection, originalVect.method_10214() * (double)yDirection, originalVect.method_10215() * (double)zDirection);
                }
                if (this.field_6012 % 10 == 0) {
                    this.method_37908().method_45445((class_1297)this, this.method_24515(), BzSounds.COSMIC_CRYSTAL_ENTITY_SPIN.get(), class_3419.field_15251, (float)progress, 1.0f);
                }
            }
        }
    }

    private static int getDirection(double originalCoordinate, double collideCoordinate) {
        if (originalCoordinate > 0.0 ? originalCoordinate > collideCoordinate : originalCoordinate < 0.0 && originalCoordinate < collideCoordinate) {
            return -1;
        }
        return 1;
    }

    public void method_5670() {
        if (this.method_5765()) {
            this.method_5848();
        }
        this.field_6039 = this.field_5973;
        this.field_6004 = this.method_36455();
        this.field_5982 = this.method_36454();
        if (this.method_37908().field_9236) {
            this.method_5646();
        } else if (this.method_20802() > 0) {
            if (this.method_20802() > 25) {
                this.method_20803(25);
            }
            if (this.method_20802() == 1 && !this.method_5771()) {
                this.method_5643(this.method_48923().method_48813(), 1.0f);
            }
            this.method_20803(this.method_20802() - 1);
            if (this.method_32312() > 0) {
                this.method_32317(0);
                this.method_37908().method_8444(null, 1009, this.method_24515(), 1);
            }
        } else {
            this.method_20803(-1);
        }
        if (!this.method_37908().field_9236 && this.method_32312() > 0) {
            if (this.field_28628 && !this.field_27857 && this.method_32316()) {
                this.method_32317(39);
            } else if (this.field_27857 && this.method_32316()) {
                if (this.method_32312() > 39 && this.method_32312() < 70) {
                    if (this.method_32312() == 69) {
                        this.method_5643(this.method_48923().method_48836(), 1.0f);
                    }
                } else {
                    this.method_32317(40);
                }
            }
            if (this.method_32312() == 1 || this.method_32312() == 2) {
                this.method_5643(this.method_48923().method_48836(), 1.0f);
            }
        }
        this.field_28628 = this.field_27857;
        this.field_27857 = false;
        if (this.field_6235 > 0) {
            --this.field_6235;
        }
        if (this.field_6008 > 0) {
            --this.field_6008;
        }
        if (this.field_6238 > 0) {
            --this.field_6238;
        } else {
            this.field_6258 = null;
        }
        if (this.method_6052() != null && !this.method_6052().method_5805()) {
            this.method_6015(null);
        }
        if (this.method_6065() != null) {
            if (!this.method_6065().method_5805()) {
                this.method_6015(null);
            } else if (this.field_6012 - this.method_6117() > 100) {
                this.method_6015(null);
            }
        }
        this.field_6275 = this.field_6255;
        this.field_6220 = this.field_6283;
        this.field_6259 = this.field_6241;
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        for (class_1293 mobEffectInstance : new ArrayList(this.method_6026())) {
            int currentEffectTick;
            class_1291 mobEffect = mobEffectInstance.method_5579();
            int n = currentEffectTick = mobEffectInstance.method_48559() ? Integer.MAX_VALUE : mobEffectInstance.method_5584();
            if (mobEffect == class_1294.field_5899) {
                if (currentEffectTick <= 45) continue;
                this.method_26082(new class_1293(mobEffect, 45, mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)this);
                continue;
            }
            if (mobEffect == class_1294.field_5920) {
                if (currentEffectTick <= 80) continue;
                this.method_26082(new class_1293(mobEffect, 80, mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)this);
                continue;
            }
            if (currentEffectTick <= 30 || mobEffectInstance.method_5579().method_5573()) continue;
            this.method_26082(new class_1293(mobEffect, 30, mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)this);
        }
        this.method_6050();
        if (!this.method_37908().field_9236) {
            this.method_33572(this.method_20802() > 0);
        }
        this.field_5953 = false;
    }

    public void method_6091(class_243 vec3) {
        if (this.method_5787()) {
            boolean bl;
            double d = 0.08;
            boolean bl2 = bl = this.method_18798().field_1351 <= 0.0;
            if (bl && this.method_6059(class_1294.field_5906)) {
                d = 0.01;
            }
            class_2338 blockPos = this.method_23314();
            float p = this.method_37908().method_8320(blockPos).method_26204().method_9499();
            float f = this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SPINNING_ATTACK ? 0.93f : 0.91f;
            class_243 vec37 = this.method_26318(vec3, p);
            double q = vec37.field_1351;
            if (!this.method_37908().field_9236 || this.method_37908().method_22340(blockPos)) {
                if (!this.method_5740()) {
                    q -= d;
                }
            } else {
                q = this.method_23318() > (double)this.method_37908().method_31607() ? -0.1 : 0.0;
            }
            this.method_18800(vec37.field_1352 * (double)f, q * (double)0.98f, vec37.field_1350 * (double)f);
        }
        this.method_29242(true);
    }

    protected class_238 method_33332() {
        class_4048 entityDimensions = ((EntityAccessor)((Object)this)).getDimensions();
        float radius = entityDimensions.field_18067 / 2.0f;
        float heightRadius = entityDimensions.field_18068 / 2.0f;
        float yOffset = 1.0f;
        float progress = 1.0f - class_3532.method_15379((float)((90.0f - this.method_36455()) / 90.0f - 1.0f));
        if (CosmicCrystalEntity.isOrFromHorizontalState(this.getCosmicCrystalState()) || this.pastStates != null && !this.pastStates.isEmpty() && CosmicCrystalEntity.isOrFromHorizontalState(this.pastStates.getFirst())) {
            float yRotRadian = this.method_36454() * ((float)Math.PI / 180);
            double yRotSin = Math.abs(class_3532.method_15374((float)yRotRadian));
            double yRotCos = Math.abs(class_3532.method_15362((float)yRotRadian));
            double xRadius = (double)radius + yRotSin * 0.5 * (double)progress;
            double zRadius = (double)radius + yRotCos * 0.5 * (double)progress;
            double xMin = this.method_23317() - xRadius;
            double yMin = this.method_23318() + (double)yOffset - (double)(heightRadius -= 0.5f * progress);
            double zMin = this.method_23321() - zRadius;
            double xMax = this.method_23317() + xRadius;
            double yMax = this.method_23318() + (double)yOffset + (double)heightRadius;
            double zMax = this.method_23321() + zRadius;
            return new class_238(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        class_243 vec3 = new class_243(this.method_23317() - (double)radius, this.method_23318() + (double)yOffset - (double)heightRadius, this.method_23321() - (double)radius);
        class_243 vec32 = new class_243(this.method_23317() + (double)radius, this.method_23318() + (double)yOffset + (double)heightRadius, this.method_23321() + (double)radius);
        return new class_238(vec3, vec32);
    }

    protected void method_5852() {
        class_238 aABB = this.method_5829();
        class_2338 blockPos = class_2338.method_49637((double)(aABB.field_1323 + 1.0E-7), (double)(aABB.field_1322 + 1.0E-7), (double)(aABB.field_1321 + 1.0E-7));
        class_2338 blockPos2 = class_2338.method_49637((double)(aABB.field_1320 - 1.0E-7), (double)(aABB.field_1325 - 1.0E-7), (double)(aABB.field_1324 - 1.0E-7));
        if (this.method_37908().method_22343(blockPos, blockPos2)) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutableBlockPos.method_10103(i, j, k);
                        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
                        if (!(this.method_37908().method_8608() || blockState.method_26215() || blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutableBlockPos).method_1110() || !(blockState.method_26204().method_9520() < 1500.0f) || blockState.method_26164(class_3481.field_17754))) {
                            this.method_37908().method_22352((class_2338)mutableBlockPos, true);
                            continue;
                        }
                        try {
                            blockState.method_26178(this.method_37908(), (class_2338)mutableBlockPos, (class_1297)this);
                            this.method_5622(blockState);
                            continue;
                        }
                        catch (Throwable throwable) {
                            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Colliding entity with block");
                            class_129 crashReportCategory = crashReport.method_562("Block being collided with");
                            class_129.method_586((class_129)crashReportCategory, (class_5539)this.method_37908(), (class_2338)mutableBlockPos, (class_2680)blockState);
                            throw new class_148(crashReport);
                        }
                    }
                }
            }
        }
    }

    private void destroyTouchingBlocks() {
        if (this.method_37908().method_8608()) {
            return;
        }
        class_238 aABB = this.method_5829();
        class_2338 blockPos = class_2338.method_49637((double)(aABB.field_1323 - 1.0E-7), (double)(aABB.field_1322 - 1.0E-7), (double)(aABB.field_1321 - 1.0E-7));
        class_2338 blockPos2 = class_2338.method_49637((double)(aABB.field_1320 + 1.0E-7), (double)(aABB.field_1325 + 1.0E-7), (double)(aABB.field_1324 + 1.0E-7));
        if (this.method_37908().method_22343(blockPos, blockPos2)) {
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            for (int i = blockPos.method_10263(); i <= blockPos2.method_10263(); ++i) {
                for (int j = blockPos.method_10264(); j <= blockPos2.method_10264(); ++j) {
                    for (int k = blockPos.method_10260(); k <= blockPos2.method_10260(); ++k) {
                        mutableBlockPos.method_10103(i, j, k);
                        class_2680 blockState = this.method_37908().method_8320((class_2338)mutableBlockPos);
                        if (blockState.method_26215() || blockState.method_26220((class_1922)this.method_37908(), (class_2338)mutableBlockPos).method_1110() || !(blockState.method_26204().method_9520() < 1500.0f) || blockState.method_26164(class_3481.field_17754)) continue;
                        this.method_37908().method_22352((class_2338)mutableBlockPos, true);
                    }
                }
            }
        }
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_6070() {
        if (this.method_37908().method_8608()) {
            this.method_37908().method_18023(class_5575.method_31795(class_1657.class), this.method_5829(), class_1301.method_5911((class_1297)this)).forEach(x$0 -> this.method_6087((class_1297)x$0));
            return;
        }
        List list = this.method_37908().method_8333((class_1297)this, this.method_5829(), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            int entityIndex;
            int maxCrammingLimit = this.method_37908().method_8450().method_8356(class_1928.field_19405);
            if (maxCrammingLimit > 0 && list.size() > maxCrammingLimit - 1 && this.field_5974.method_43048(4) == 0) {
                entityIndex = 0;
                for (class_1297 entity : list) {
                    if (entity.method_5765()) continue;
                    ++entityIndex;
                }
            }
            for (entityIndex = 0; entityIndex < list.size(); ++entityIndex) {
                class_1297 entity = (class_1297)list.get(entityIndex);
                this.method_6087(entity);
                if (!(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                if (entity instanceof CosmicCrystalEntity || this.physicalHurtAttack(livingEntity)) continue;
                class_243 center = livingEntity.method_5829().method_1005();
                ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11207, center.method_10216() + this.field_5974.method_43059() / 5.0, center.method_10214() + this.field_5974.method_43059() / 2.5, center.method_10215() + this.field_5974.method_43059() / 5.0, 15, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * 0.035 + 0.085);
            }
        }
    }

    protected void method_6020(class_1293 mobEffectInstance, @Nullable class_1297 entity) {
        super.method_6020(mobEffectInstance, entity);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)new class_2783(this.method_5628(), mobEffectInstance)));
        }
    }

    protected void method_6129(class_1293 mobEffectInstance) {
        super.method_6129(mobEffectInstance);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_18456().forEach(p -> p.field_13987.method_14364((class_2596)new class_2718(this.method_5628(), mobEffectInstance.method_5579())));
        }
    }

    public boolean method_6049(class_1293 mobEffectInstance) {
        return mobEffectInstance.method_5579() != class_1294.field_5924 && mobEffectInstance.method_5579() != class_1294.field_5915 && mobEffectInstance.method_5579() != class_1294.field_5898;
    }

    public void method_5768() {
        this.method_6033(0.0f);
        this.method_6078(this.method_48923().method_51847());
    }

    public boolean method_5643(class_1282 damageSource, float damageAmount) {
        boolean dealtDamage;
        class_1297 entity2;
        if (damageAmount >= 30.0f) {
            damageAmount = 2.0f;
        } else if (damageAmount >= 10.0f && !damageSource.method_48790() && !damageSource.method_48789(BzTags.COSMIC_CRYSTAL_RESISTANT_TO)) {
            damageAmount = 2.0f;
        } else if (damageAmount > 1.0f) {
            damageAmount = 1.0f;
        }
        if (this.method_5679(damageSource)) {
            return false;
        }
        if (this.method_37908().field_9236) {
            return false;
        }
        if (damageSource.method_5529() instanceof CosmicCrystalEntity || damageSource.method_5526() instanceof CosmicCrystalEntity) {
            return false;
        }
        if (this.method_29504()) {
            return false;
        }
        if (damageSource.method_48789(class_8103.field_42246) && this.method_6059(class_1294.field_5918)) {
            return false;
        }
        if (this.method_6113() && !this.method_37908().field_9236) {
            this.method_18400();
        }
        this.field_6278 = 0;
        boolean bl = false;
        if (this.field_6008 > 0) {
            return false;
        }
        this.field_6253 = damageAmount;
        this.field_6008 = 10;
        this.method_6074(damageSource, damageAmount);
        this.field_6254 = 10;
        this.field_6235 = 10;
        if (damageSource.method_48789(class_8103.field_42240) && !this.method_6118(class_1304.field_6169).method_7960()) {
            this.method_36977(damageSource, damageAmount);
            damageAmount *= 0.75f;
        }
        if ((entity2 = damageSource.method_5529()) != null) {
            class_1321 tamableAnimal;
            if (entity2 instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)entity2;
                if (!damageSource.method_48789(class_8103.field_42254)) {
                    this.method_6015(livingEntity2);
                }
            }
            if (entity2 instanceof class_1657) {
                class_1657 player = (class_1657)entity2;
                this.field_6238 = 100;
                this.field_6258 = player;
            } else if (entity2 instanceof class_1321 && (tamableAnimal = (class_1321)entity2).method_6181()) {
                this.field_6238 = 100;
                class_1309 livingEntity = tamableAnimal.method_35057();
                this.field_6258 = livingEntity instanceof class_1657 ? (class_1657)livingEntity : null;
            }
        }
        this.method_37908().method_48760((class_1297)this, damageSource);
        if (!damageSource.method_48789(class_8103.field_42255)) {
            this.method_5785();
        }
        if (entity2 != null && !damageSource.method_48789(class_8103.field_42249)) {
            double xDiff = entity2.method_23317() - this.method_23317();
            double zDiff = entity2.method_23321() - this.method_23321();
            while (xDiff * xDiff + zDiff * zDiff < 1.0E-4) {
                xDiff = (Math.random() - Math.random()) * 0.01;
                zDiff = (Math.random() - Math.random()) * 0.01;
            }
            if (!bl) {
                this.method_48761(xDiff, zDiff);
            }
        }
        if (this.method_29504()) {
            class_2248 class_22482;
            class_3414 soundEvent = this.method_6002();
            if (soundEvent != null) {
                this.method_5783(soundEvent, this.method_6107(), this.method_6017());
            }
            this.method_6078(damageSource);
            EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.method_37908(), this.getEssenceControllerDimension(), this.getEssenceControllerBlockPos(), this.getEssenceController());
            if (essenceBlockEntity != null && (class_22482 = essenceBlockEntity.method_11010().method_26204()) instanceof EssenceBlockWhite) {
                EssenceBlockWhite essenceBlockWhite = (EssenceBlockWhite)class_22482;
                essenceBlockWhite.crystalKilled(this, essenceBlockEntity);
            }
        } else {
            this.method_6013(damageSource);
        }
        boolean bl2 = dealtDamage = damageAmount > 0.0f;
        if (dealtDamage) {
            ((LivingEntityAccessor)((Object)this)).setLastDamageSource(damageSource);
            ((LivingEntityAccessor)((Object)this)).setLastDamageStamp(this.method_37908().method_8510());
        }
        if (entity2 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity2;
            class_174.field_1199.method_9097(serverPlayer, (class_1297)this, damageSource, damageAmount, damageAmount, bl);
        }
        return damageAmount > 0.0f;
    }

    protected float method_18394(class_4050 pose, class_4048 entityDimensions) {
        return entityDimensions.field_18068 / 2.0f;
    }

    public boolean method_5740() {
        return true;
    }

    protected void method_23883() {
    }

    public class_1306 method_6068() {
        return null;
    }

    public Iterable<class_1799> method_5661() {
        return this.armorItems;
    }

    public class_1799 method_6118(class_1304 equipmentSlot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 equipmentSlot, class_1799 itemStack) {
    }

    public boolean method_5733() {
        return false;
    }

    public boolean method_42149() {
        return true;
    }

    public boolean method_30230() {
        return true;
    }

    public boolean method_5753() {
        return false;
    }

    public void method_5730() {
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_5757() {
        return false;
    }

    protected void method_18379() {
    }

    public boolean method_5851() {
        return true;
    }

    public boolean method_5822() {
        return super.method_5822() && this.getEssenceController() == null;
    }

    public int method_51848() {
        return this.getEssenceController() == null ? super.method_51848() : Integer.MAX_VALUE;
    }

    public class_1297 method_5731(class_3218 serverLevel) {
        return this;
    }

    private boolean laserHurtAttack(class_1309 livingEntity) {
        float damageAmount;
        float maxHealth = Math.max(livingEntity.method_6032(), livingEntity.method_6063());
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (serverPlayer.method_7337()) {
                return true;
            }
            damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 4.0f : maxHealth / 3.0f;
        } else {
            damageAmount = maxHealth / 4.0f;
        }
        livingEntity.method_5643(this.method_37908().method_48963().method_48796(BzDamageSources.COSMIC_CRYSTAL_TYPE, (class_1297)this), damageAmount);
        return false;
    }

    private boolean physicalHurtAttack(class_1309 livingEntity) {
        float damageAmount;
        float maxHealth = Math.max(livingEntity.method_6032(), livingEntity.method_6063());
        if (this.getCosmicCrystalState() == CosmicCrystalState.TRACKING_SMASHING_ATTACK && this.targetEntity == livingEntity) {
            this.collidingAttackExplosion();
        }
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (serverPlayer.method_7337()) {
                return true;
            }
            damageAmount = EssenceOfTheBees.hasEssence(serverPlayer) ? maxHealth / 6.0f : maxHealth / 4.0f;
        } else {
            damageAmount = maxHealth / 6.0f;
        }
        livingEntity.method_5643(this.method_37908().method_48963().method_48796(BzDamageSources.COSMIC_CRYSTAL_TYPE, (class_1297)this), damageAmount);
        this.lastPhysicalHit = this.currentStateTimeTick;
        for (class_1291 mobEffect : new HashSet(livingEntity.method_6088().keySet())) {
            if (!mobEffect.method_5573()) continue;
            livingEntity.method_6016(mobEffect);
        }
        return false;
    }

    public void method_6025(float f) {
    }

    private void spawnLargeParticleCloud(int radius) {
        int radiusSquared = radius * radius;
        for (int xParticle = -radius; xParticle <= radius; ++xParticle) {
            for (int zParticle = -radius; zParticle <= radius; ++zParticle) {
                for (int yParticle = -radius; yParticle <= radius; ++yParticle) {
                    int distanceSquared = xParticle * xParticle + yParticle * yParticle + zParticle * zParticle;
                    if (distanceSquared > radiusSquared) continue;
                    for (int i = 0; i <= radiusSquared / Math.max(1, distanceSquared) * 3; ++i) {
                        this.spawnFancyParticle(this.method_19538().method_1031((double)xParticle, (double)yParticle, (double)zParticle));
                    }
                }
            }
        }
    }

    private void spawnFancyParticle(class_243 center) {
        this.method_37908().method_8406((class_2394)class_2398.field_11207, center.method_10216() + this.field_5974.method_43059() / 5.0, center.method_10214() + this.field_5974.method_43059() / 2.5, center.method_10215() + this.field_5974.method_43059() / 5.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0);
        this.method_37908().method_8406((class_2394)BzParticles.SPARKLE_PARTICLE.get(), center.method_10216() + this.field_5974.method_43059() / 4.0, center.method_10214() + this.field_5974.method_43059() / 2.5, center.method_10215() + this.field_5974.method_43059() / 4.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0, (double)this.field_5974.method_43057() * this.field_5974.method_43059() / 15.0);
    }
}

