/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.mobs.VariantBeeEntity;
import com.telepathicgrunt.the_bumblezone.events.player.PlayerItemAttackBlockEvent;
import com.telepathicgrunt.the_bumblezone.menus.BuzzingBriefcaseMenuProvider;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3908;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4466;
import net.minecraft.class_5354;

public class BuzzingBriefcase
extends class_1792 {
    public static final String TAG_BEES = "BeesStored";
    public static final String TAG_VARANT_BEES = "VariantBeesStored";
    public static final int MAX_NUMBER_OF_BEES = 14;

    public BuzzingBriefcase(class_1792.class_1793 properties) {
        super(properties);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_7357().method_7904(stack.method_7909())) {
            return new class_1271(class_1269.field_5811, (Object)stack);
        }
        if (player.method_5715()) {
            player.method_17355((class_3908)new BuzzingBriefcaseMenuProvider(stack));
            player.method_7281(BzStats.INTERACT_WITH_BUZZING_BRIEFCASE_RL.get());
            return new class_1271(class_1269.field_5812, (Object)stack);
        }
        return new class_1271(class_1269.field_5811, (Object)stack);
    }

    public static class_1269 onLeftClickBlock(PlayerItemAttackBlockEvent event) {
        class_1657 player = event.user();
        class_1799 briefcaseItem = player.method_5998(event.hand());
        if (event.hand() != class_1268.field_5808 || !briefcaseItem.method_31574(BzItems.BUZZING_BRIEFCASE.get()) || player.method_7357().method_7904(briefcaseItem.method_7909())) {
            return null;
        }
        if (player.method_37908().method_8608()) {
            int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
            return numberOfBees > 0 ? class_1269.field_5812 : null;
        }
        List<class_1297> releasedBees = BuzzingBriefcase.dumpBees(player, player.method_18276() ? -1 : 0, false);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!releasedBees.isEmpty()) {
                BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.trigger(serverPlayer);
                player.method_7259(class_3468.field_15372.method_14956((Object)briefcaseItem.method_7909()));
                serverPlayer.method_7357().method_7906(briefcaseItem.method_7909(), 10);
                return class_1269.field_5812;
            }
        }
        return null;
    }

    public boolean method_7873(class_1799 stack, class_1309 victim, class_1309 attacker) {
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (player.method_7357().method_7904(stack.method_7909())) {
                return false;
            }
            boolean isVictimBeelike = BeeAggression.isBeelikeEntity((class_1297)victim);
            List<class_1297> releasedBees = BuzzingBriefcase.dumpBees(player, player.method_18276() ? -1 : 0, false);
            for (class_1297 entity : releasedBees) {
                if (!(entity instanceof class_5354)) continue;
                class_5354 neutralMob = (class_5354)entity;
                if (isVictimBeelike) continue;
                neutralMob.method_5980(victim);
                neutralMob.method_29514(400);
                neutralMob.method_29513(victim.method_5667());
            }
            if (!isVictimBeelike && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (!releasedBees.isEmpty()) {
                    BzCriterias.BUZZING_BRIEFCASE_RELEASE_TRIGGER.trigger(serverPlayer);
                    serverPlayer.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                    serverPlayer.method_7357().method_7906(stack.method_7909(), 10);
                }
            }
        }
        return true;
    }

    public class_1269 method_7847(class_1799 beeCannon, class_1657 player, class_1309 entity, class_1268 playerHand) {
        class_4466 bee;
        if (!(entity instanceof class_4466) || (bee = (class_4466)entity).method_5864().method_20210(BzTags.BUZZING_BRIEFCASE_DISALLOWED_BEE) || entity.method_29504()) {
            return class_1269.field_5811;
        }
        if (player.method_37908().method_8608()) {
            return class_1269.field_5812;
        }
        class_1799 briefcaseItem = player.method_5998(playerHand);
        if (player.method_7357().method_7904(briefcaseItem.method_7909())) {
            return class_1269.field_5811;
        }
        boolean addedBee = BuzzingBriefcase.tryAddBee(briefcaseItem, (class_1297)entity);
        if (addedBee) {
            class_3222 serverPlayer;
            player.method_7281(BzStats.BUZZING_BRIEFCASE_BEE_CAPTURE_RL.get());
            player.method_7259(class_3468.field_15372.method_14956((Object)briefcaseItem.method_7909()));
            player.method_23667(playerHand, true);
            if (player instanceof class_3222 && BuzzingBriefcase.getBeesStored((serverPlayer = (class_3222)player).method_37908(), briefcaseItem, false).size() == 14) {
                BzCriterias.BUZZING_BRIEFCASE_FULL_TRIGGER.trigger(serverPlayer);
            }
            int variantBeesCaught = briefcaseItem.method_7948().method_10550(TAG_VARANT_BEES);
            if (player instanceof class_3222) {
                class_3222 serverPlayer2 = (class_3222)player;
                if (variantBeesCaught > 0) {
                    BzCriterias.VARIANT_BEE_BRIEFCASE_CAPTURE_TRIGGER.trigger(serverPlayer2, variantBeesCaught);
                }
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static List<class_1297> dumpBees(class_1657 player, int beeIndex, boolean releaseAtPlayer) {
        class_1937 level = player.method_37908();
        class_1799 briefcaseItem = player.method_5998(class_1268.field_5808);
        int numberOfBees = BuzzingBriefcase.getNumberOfBees(briefcaseItem);
        if (numberOfBees > 0) {
            List<Object> bees = new ArrayList<class_1297>();
            if (beeIndex == -1) {
                bees = BuzzingBriefcase.getBeesStored(level, briefcaseItem, true);
            } else {
                bees.add(BuzzingBriefcase.getSpecificBeesStored(level, briefcaseItem, beeIndex, true));
            }
            if (!bees.isEmpty()) {
                player.method_7259(class_3468.field_15372.method_14956((Object)briefcaseItem.method_7909()));
                float maxDistance = 15.0f;
                class_243 playerEyePos = new class_243(player.method_23317(), player.method_23320() - 0.25, player.method_23321());
                class_243 maxDistanceDirection = player.method_5720().method_18805((double)maxDistance, (double)maxDistance, (double)maxDistance);
                class_243 finalPos = playerEyePos.method_1019(maxDistanceDirection.method_1029());
                if (!releaseAtPlayer) {
                    finalPos = playerEyePos.method_1019(maxDistanceDirection);
                    class_3966 entityHitResult = class_1675.method_37226((class_1937)level, (class_1297)player, (class_243)playerEyePos, (class_243)finalPos, (class_238)player.method_5829().method_18804(maxDistanceDirection), entity -> !entity.method_5756(player) && !BeeAggression.isBeelikeEntity(entity), (float)0.25f);
                    if (entityHitResult != null && entityHitResult.method_17783() != class_239.class_240.field_1333) {
                        finalPos = entityHitResult.method_17784();
                    } else {
                        class_3965 hitResult = level.method_17742(new class_3959(playerEyePos, finalPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
                        if (hitResult instanceof class_3965) {
                            class_3965 blockHitResult = hitResult;
                            class_243 locationClicked = hitResult.method_17784();
                            class_243 offset = class_243.method_24954((class_2382)blockHitResult.method_17780().method_10163());
                            if (blockHitResult.method_17780() == class_2350.field_11036) {
                                offset = offset.method_1021(0.35);
                            } else if (blockHitResult.method_17780() != class_2350.field_11033) {
                                offset = offset.method_1021(0.5);
                            }
                            finalPos = locationClicked.method_1019(offset);
                        }
                    }
                }
                class_243 finalPos1 = finalPos;
                bees.forEach(bee -> {
                    bee.method_5808(finalPos1.method_10216(), finalPos1.method_10214(), finalPos1.method_10215(), player.method_36454(), player.method_36455());
                    level.method_8649(bee);
                });
                level.method_8396(null, player.method_24515(), BzSounds.BUZZING_BRIEFCASE_RELEASES.get(), class_3419.field_15248, 1.0f, player.method_6051().method_43057() * 0.2f + 0.6f);
                return new ArrayList<Object>(bees);
            }
        }
        return new ArrayList<class_1297>();
    }

    public static List<class_1297> getBeesStored(class_1937 level, class_1799 briefcaseItem, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            class_2487 briefcaseTag = briefcaseItem.method_7948();
            class_2499 beeList = briefcaseTag.method_10554(TAG_BEES, 10);
            ObjectArrayList beesStored = new ObjectArrayList();
            if (removeFromList) {
                for (int i = beeList.size() - 1; i >= 0; --i) {
                    class_2487 beeTag = beeList.method_10602(0);
                    beeList.method_10536(0);
                    class_1297 entity = class_1299.method_17842((class_2487)beeTag, (class_1937)level, entityx -> entityx);
                    if (entity == null) continue;
                    if (entity instanceof VariantBeeEntity) {
                        briefcaseTag.method_10569(TAG_VARANT_BEES, Math.max(0, briefcaseTag.method_10550(TAG_VARANT_BEES) - 1));
                    }
                    if (!BuzzingBriefcase.addBeeToList((List<class_1297>)beesStored, beeTag, entity)) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < beeList.size(); ++i) {
                    class_2487 beeTag = beeList.method_10602(i);
                    class_1297 entity = class_1299.method_17842((class_2487)beeTag, (class_1937)level, entityx -> entityx);
                    if (entity != null) {
                        if (!BuzzingBriefcase.addBeeToList((List<class_1297>)beesStored, beeTag, entity)) continue;
                        break;
                    }
                    beeList.method_10536(i);
                    --i;
                }
            }
            return beesStored;
        }
        return new ObjectArrayList();
    }

    private static boolean addBeeToList(List<class_1297> beesStored, class_2487 beeTag, class_1297 entity) {
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (beeTag.method_10573("Attributes", 9)) {
                livingEntity.method_6127().method_26850(beeTag.method_10554("Attributes", 10));
            }
            if (beeTag.method_10573("Health", 99)) {
                livingEntity.method_6033(beeTag.method_10583("Health"));
            }
        }
        beesStored.add(entity);
        return beesStored.size() == 14;
    }

    public static class_1297 getSpecificBeesStored(class_1937 level, class_1799 briefcaseItem, int beeIndex, boolean removeFromList) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) > 0) {
            class_2487 briefcaseTag = briefcaseItem.method_7948();
            class_2499 beeList = briefcaseTag.method_10554(TAG_BEES, 10);
            if (beeIndex < beeList.size()) {
                class_1297 entity;
                class_2487 beeTag = beeList.method_10602(beeIndex);
                if (removeFromList) {
                    beeList.method_10536(beeIndex);
                }
                if ((entity = class_1299.method_17842((class_2487)beeTag, (class_1937)level, entityx -> entityx)) instanceof VariantBeeEntity && removeFromList) {
                    briefcaseTag.method_10569(TAG_VARANT_BEES, Math.max(0, briefcaseTag.method_10550(TAG_VARANT_BEES) - 1));
                }
                return entity;
            }
            return null;
        }
        return null;
    }

    public static void overrwriteBees(class_1799 briefcaseItem, List<class_1297> bees) {
        class_2487 briefcaseTag = briefcaseItem.method_7948();
        briefcaseTag.method_10551(TAG_BEES);
        briefcaseTag.method_10551(TAG_VARANT_BEES);
        bees.forEach(bee -> BuzzingBriefcase.tryAddBee(briefcaseItem, bee));
    }

    public static boolean tryAddBee(class_1799 briefcaseItem, class_1297 bee) {
        if (BuzzingBriefcase.getNumberOfBees(briefcaseItem) < 14) {
            class_2487 briefcaseTag = briefcaseItem.method_7948();
            class_2499 beeList = briefcaseTag.method_10554(TAG_BEES, 10);
            class_2487 beeTag = new class_2487();
            bee.method_5662(beeTag);
            bee.method_5848();
            bee.method_5772();
            beeTag.method_10551("UUID");
            beeList.add((Object)beeTag);
            bee.method_31472();
            if (bee instanceof VariantBeeEntity) {
                briefcaseTag.method_10569(TAG_VARANT_BEES, briefcaseTag.method_10550(TAG_VARANT_BEES) + 1);
            }
            return true;
        }
        return false;
    }

    public static int getNumberOfBees(class_1799 briefcaseItem) {
        class_2487 briefcaseTag = briefcaseItem.method_7948();
        if (briefcaseTag.method_10545(TAG_BEES)) {
            class_2499 beeList = briefcaseTag.method_10554(TAG_BEES, 10);
            return beeList.size();
        }
        class_2499 listTag = new class_2499();
        briefcaseTag.method_10566(TAG_BEES, (class_2520)listTag);
        return 0;
    }

    public int getBurnTime(class_1799 briefcaseItem, class_3956 recipeType) {
        return 150 + BuzzingBriefcase.getNumberOfBees(briefcaseItem) * 1500;
    }
}

