/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_7260;

public class CalmingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.calmingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.calmingEssenceAbilityUse;

    public CalmingEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    public void decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer, int decreaseAmount) {
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, false);
        }
    }

    @Override
    public int getColor() {
        return 44525;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_calming_description_1").method_27692(class_124.field_1078).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_calming_description_2").method_27692(class_124.field_1078).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_calming_description_3").method_27692(class_124.field_1078).method_27692(class_124.field_1056));
    }

    @Override
    public void applyAbilityEffects(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
        if (CalmingEssence.getIsActive(stack)) {
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 12L == 0L) {
                CalmingEssence.spawnParticles(serverPlayer.method_51469(), serverPlayer.method_19538(), serverPlayer.method_6051());
            }
            if (((long)serverPlayer.field_6012 + serverPlayer.method_5667().getLeastSignificantBits()) % 20L == 0L) {
                serverPlayer.method_14248().method_15023((class_1657)serverPlayer, class_3468.field_15419.method_14956((Object)class_3468.field_15429), 0);
                for (class_1297 entity : level.method_8335((class_1297)serverPlayer, serverPlayer.method_5829().method_1014(60.0))) {
                    class_7260 warden;
                    class_5354 neutralMob;
                    class_1308 mob;
                    if (entity.method_5864().method_20210(BzTags.CALMING_ALLOW_ANGER_THROUGH)) continue;
                    if (entity instanceof class_1308 && (mob = (class_1308)entity).method_5968() == serverPlayer) {
                        mob.method_5980(null);
                    }
                    if (entity instanceof class_5354 && (neutralMob = (class_5354)entity).method_29508() == serverPlayer.method_5667()) {
                        neutralMob.method_29922();
                    }
                    if (!(entity instanceof class_7260) || (warden = (class_7260)entity).method_42216().method_42181().orElse(null) != serverPlayer) continue;
                    warden.method_42211((class_1297)serverPlayer);
                }
                if (serverPlayer.method_6016(BzEffects.WRATH_OF_THE_HIVE.get())) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, this.getAbilityUseRemaining(stack));
                } else if (serverPlayer.method_5624()) {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 60);
                } else {
                    this.decrementAbilityUseRemaining(stack, serverPlayer, 1);
                }
            }
        }
    }

    private void depleteEssence(class_1799 stack, class_3222 serverPlayer) {
        this.setAbilityUseRemaining(stack, 0);
        this.setDepleted(stack, serverPlayer, false);
    }

    public static boolean IsCalmingEssenceActive(class_1657 player) {
        if (player != null) {
            class_1799 offHandItem = player.method_6079();
            return offHandItem.method_31574(BzItems.ESSENCE_CALMING.get()) && CalmingEssence.getIsActive(offHandItem);
        }
        return false;
    }

    public static void OnAttack(EntityHurtEvent event) {
        class_1297 class_12972;
        class_1282 damageSource = event.source();
        class_1309 livingEntity = event.entity();
        if (livingEntity instanceof class_1308 && (class_12972 = damageSource.method_5529()) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_12972;
            offHandItem = serverPlayer.method_6079();
            class_1792 class_17922 = offHandItem.method_7909();
            if (class_17922 instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)class_17922;
                if (CalmingEssence.IsCalmingEssenceActive((class_1657)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        } else if (livingEntity instanceof class_3222) {
            class_1792 class_17923;
            class_3222 serverPlayer = (class_3222)livingEntity;
            if (damageSource.method_5529() instanceof class_1308 && (class_17923 = (offHandItem = serverPlayer.method_6079()).method_7909()) instanceof CalmingEssence) {
                CalmingEssence calmingEssence = (CalmingEssence)class_17923;
                if (CalmingEssence.IsCalmingEssenceActive((class_1657)serverPlayer)) {
                    calmingEssence.depleteEssence(offHandItem, serverPlayer);
                }
            }
        }
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random) {
        world.method_14199((class_2394)BzParticles.SPARKLE_PARTICLE.get(), location.method_10216(), location.method_10214() + 1.0, location.method_10215(), 1, random.method_43059() * 0.2, random.method_43059() * 0.25 + 0.1, random.method_43059() * 0.2, 0.0);
    }
}

