/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.BzWorldSavedData;
import com.telepathicgrunt.the_bumblezone.events.entity.EntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ServerPlayerAccessor;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_2767;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4081;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8112;
import net.minecraft.server.MinecraftServer;

public class ContinuityEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.continuityEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> 1;
    private static final ConcurrentLinkedQueue<TickCapsule> NEXT_TICK_BEHAVIORS = new ConcurrentLinkedQueue();
    private static final class_2583 INTENTIONAL_GAME_DESIGN_STYLE = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://bugs.mojang.com/browse/MCPE-28723")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"MCPE-28723")));

    public ContinuityEssence(class_1792.class_1793 properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    void addDescriptionComponents(List<class_2561> components) {
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_continuity_description_1").method_27692(class_124.field_1068).method_27692(class_124.field_1056));
        components.add((class_2561)class_2561.method_43471((String)"item.the_bumblezone.essence_continuity_description_2").method_27692(class_124.field_1068).method_27692(class_124.field_1056));
    }

    public void decrementAbilityUseRemaining(class_1799 stack, class_3222 serverPlayer, int decreaseAmount) {
        int getRemainingUse = Math.max(this.getAbilityUseRemaining(stack) - decreaseAmount, 0);
        this.setAbilityUseRemaining(stack, getRemainingUse);
        if (getRemainingUse == 0) {
            this.setDepleted(stack, serverPlayer, true);
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 level, class_1297 entity, int i, boolean bl) {
        TickCapsule tickCapsule = NEXT_TICK_BEHAVIORS.poll();
        if (tickCapsule != null) {
            if (level.method_8510() > tickCapsule.tickTarget) {
                tickCapsule.runnable().run();
            } else {
                NEXT_TICK_BEHAVIORS.add(tickCapsule);
            }
        }
        super.method_7888(stack, level, entity, i, bl);
    }

    @Override
    void applyAbilityEffects(class_1799 stack, class_1937 level, class_3222 serverPlayer) {
    }

    public static boolean CancelledDeath(EntityDeathEvent event) {
        class_1309 livingEntity = event.entity();
        if (livingEntity instanceof class_3222) {
            class_1792 class_17922;
            class_3222 player = (class_3222)livingEntity;
            class_1282 source = event.source();
            class_2378 damageTypeRegistry = player.method_37908().method_30349().method_30530(class_7924.field_42534);
            if (damageTypeRegistry.method_29107(class_8111.field_44869) == event.source().method_48792() && source.method_5529() == null && source.method_5526() == null && source.method_5510() == null) {
                return false;
            }
            class_1799 stack = player.method_6079();
            if (player.method_29504() && (class_17922 = stack.method_7909()) instanceof ContinuityEssence) {
                ContinuityEssence continuityEssence = (ContinuityEssence)class_17922;
                if (ContinuityEssence.getIsActive(stack) && !player.method_7357().method_7904(stack.method_7909())) {
                    ContinuityEssence.playerReset(player);
                    ArrayList mobEffectInstances = new ArrayList(player.method_6026());
                    for (class_1293 mobEffectInstance : mobEffectInstances) {
                        if (mobEffectInstance.method_5579().method_5573()) continue;
                        player.method_6016(mobEffectInstance.method_5579());
                    }
                    MinecraftServer server = player.method_37908().method_8503();
                    if (server != null) {
                        ContinuityEssence.spawnParticles(player.method_51469(), player.method_19538(), player.method_6051());
                        ContinuityEssence.respawn(stack, continuityEssence, player, server, event.source());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void respawn(class_1799 stack, ContinuityEssence continuityEssence, class_3222 serverPlayer, MinecraftServer server, class_1282 damageSource) {
        boolean isRespawnAnchor;
        class_2338 playerRespawnBlockPos;
        class_243 playerRespawnPosition;
        class_3218 finalDestination;
        class_5321 oldDimension = serverPlayer.method_37908().method_27983();
        class_2338 oldPosition = serverPlayer.method_24515();
        class_5321 respawnDimension = serverPlayer.method_26281();
        class_2338 respawningLinkedPosition = serverPlayer.method_26280();
        float respawnAngle = serverPlayer.method_30631();
        boolean forcedRespawn = serverPlayer.method_26282();
        class_3218 desiredDestination = server.method_3847(respawnDimension);
        Optional optionalRespawnPoint = desiredDestination != null && respawningLinkedPosition != null ? class_1657.method_26091((class_3218)desiredDestination, (class_2338)respawningLinkedPosition, (float)respawnAngle, (boolean)forcedRespawn, (boolean)true) : Optional.empty();
        class_3218 class_32182 = finalDestination = desiredDestination != null && optionalRespawnPoint.isPresent() ? desiredDestination : server.method_30002();
        if (optionalRespawnPoint.isEmpty() && respawningLinkedPosition != null) {
            serverPlayer.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25645, 0.0f));
        }
        if (optionalRespawnPoint.isPresent()) {
            playerRespawnPosition = (class_243)optionalRespawnPoint.get();
            playerRespawnBlockPos = class_2338.method_49638((class_2374)playerRespawnPosition);
            class_2680 blockState = finalDestination.method_8320(respawningLinkedPosition);
            isRespawnAnchor = blockState.method_27852(class_2246.field_23152);
        } else {
            playerRespawnPosition = finalDestination.method_43126().method_46558();
            playerRespawnBlockPos = finalDestination.method_43126();
            isRespawnAnchor = false;
        }
        BzWorldSavedData.queueEntityToGenericTeleport((class_1297)serverPlayer, (class_5321<class_1937>)finalDestination.method_27983(), playerRespawnBlockPos, () -> {
            if (isRespawnAnchor) {
                serverPlayer.field_13987.method_14364((class_2596)new class_2767((class_6880)class_3417.field_23117, class_3419.field_15245, (double)respawningLinkedPosition.method_10263(), (double)respawningLinkedPosition.method_10264(), (double)respawningLinkedPosition.method_10260(), 1.0f, 1.0f, finalDestination.method_8409().method_43055()));
            }
            ContinuityEssence.playerReset(serverPlayer);
            class_1799 respawnedPlayerStack = serverPlayer.method_6079();
            class_1792 patt9510$temp = respawnedPlayerStack.method_7909();
            if (patt9510$temp instanceof ContinuityEssence) {
                ContinuityEssence continuityEssenceRespawnedPlayer = (ContinuityEssence)patt9510$temp;
                continuityEssenceRespawnedPlayer.decrementAbilityUseRemaining(respawnedPlayerStack, serverPlayer, 1);
            }
            NEXT_TICK_BEHAVIORS.add(new TickCapsule(() -> {
                ContinuityEssence.spawnParticles(finalDestination, playerRespawnPosition, finalDestination.method_8409());
                serverPlayer.method_7357().method_7906((class_1792)continuityEssence, continuityEssence.getCooldownTickLength());
            }, serverPlayer.method_51469().method_8510() + 5L));
        });
        ContinuityEssence.spawnBook(serverPlayer, damageSource, (class_5321<class_1937>)oldDimension, oldPosition, finalDestination, playerRespawnPosition);
    }

    private static void spawnBook(class_3222 serverPlayer, class_1282 damageSource, class_5321<class_1937> oldDimension, class_2338 oldPosition, class_3218 finalDestination, class_243 playerRespawnPosition) {
        class_1799 newBook = class_1802.field_8360.method_7854();
        class_2487 compoundTag = newBook.method_7948();
        compoundTag.method_10582("title", "Essence of Continuity Record");
        compoundTag.method_10582("author", serverPlayer.method_5477().getString());
        class_2499 listTag = new class_2499();
        class_1297 causer = damageSource.method_5529();
        if (causer == null) {
            listTag.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_continuity_written_book_body_no_causer", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.method_10263(), oldPosition.method_10264(), oldPosition.method_10260(), oldDimension.method_29177().toString(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)}))));
        } else {
            listTag.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43469((String)"item.the_bumblezone.essence_continuity_written_book_body", (Object[])new Object[]{LocalDate.now().toString(), oldPosition.method_10263(), oldPosition.method_10264(), oldPosition.method_10260(), oldDimension.method_29177().toString(), causer.method_5477(), ContinuityEssence.getDeathMessage(finalDestination, damageSource, serverPlayer)}))));
        }
        compoundTag.method_10566("pages", (class_2520)listTag);
        class_1542 itementity = new class_1542((class_1937)finalDestination, playerRespawnPosition.method_10216(), playerRespawnPosition.method_10214(), playerRespawnPosition.method_10215(), newBook);
        itementity.method_6988();
        finalDestination.method_8649((class_1297)itementity);
    }

    public static class_2561 getDeathMessage(class_3218 serverLevel, class_1282 damageSource, class_3222 serverPlayer) {
        if (damageSource.method_48792() == serverLevel.method_48963().method_48830().method_48792()) {
            return class_2561.method_43469((String)"death.attack.generic", (Object[])new Object[]{serverPlayer.method_5476()});
        }
        class_8112 deathMessageType = damageSource.method_48792().comp_1246();
        if (deathMessageType == class_8112.field_42362 && damageSource.method_5529() != null) {
            return ContinuityEssence.getFallMessage(damageSource.method_5529(), serverPlayer);
        }
        if (deathMessageType == class_8112.field_42363) {
            String string = "death.attack." + damageSource.method_5525();
            class_5250 component = class_2564.method_10885((class_2561)class_2561.method_43471((String)(string + ".link"))).method_27696(INTENTIONAL_GAME_DESIGN_STYLE);
            return class_2561.method_43469((String)(string + ".message"), (Object[])new Object[]{serverPlayer.method_5476(), component});
        }
        return damageSource.method_5506((class_1309)serverPlayer);
    }

    private static class_2561 getFallMessage(class_1297 entity, class_3222 serverPlayer) {
        class_2561 component = entity.method_5476();
        if (component != null) {
            return ContinuityEssence.getMessageForAssistedFall(serverPlayer, entity, component, "death.fell.finish.item", "death.fell.finish");
        }
        return class_2561.method_43469((String)"death.fell.killer", (Object[])new Object[]{entity.method_5476()});
    }

    private static class_2561 getMessageForAssistedFall(class_3222 serverPlayer, class_1297 entity, class_2561 component, String string, String string2) {
        class_1799 itemStack;
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            itemStack = livingEntity.method_6047();
        } else {
            itemStack = class_1799.field_8037;
        }
        if (!itemStack.method_7960() && itemStack.method_7938()) {
            return class_2561.method_43469((String)string, (Object[])new Object[]{serverPlayer.method_5476(), component, itemStack.method_7954()});
        }
        return class_2561.method_43469((String)string2, (Object[])new Object[]{serverPlayer.method_5476(), component});
    }

    public static void spawnParticles(class_3218 world, class_243 location, class_5819 random) {
        world.method_14199((class_2394)class_2398.field_11248, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), 100, random.method_43059() * 0.1, random.method_43059() * 0.1 + 0.1, random.method_43059() * 0.1, (double)random.method_43057() * 0.4 + (double)0.2f);
        world.method_14199((class_2394)class_2398.field_11215, location.method_10216(), location.method_10214() + 1.0, location.method_10215(), 400, 1.0, 1.0, 1.0, (double)random.method_43057() * 0.5 + (double)1.2f);
    }

    private static void playerReset(class_3222 player) {
        player.method_6033(player.method_6063());
        player.method_7344().method_35218(0.0f);
        player.method_7344().method_7585(20, 20.0f);
        player.method_5646();
        player.method_5855(player.method_5748());
        ((ServerPlayerAccessor)player).setStartingToFallPosition(null);
        player.field_6008 = 40;
        player.field_6213 = 0;
        player.field_6017 = 0.0f;
        player.method_18400();
        player.method_29239();
        player.method_5772();
        player.method_30229();
        player.method_18799(new class_243(0.0, 0.0, 0.0));
        player.method_22862();
        for (class_1293 effect : new ArrayList(player.method_6026())) {
            if (effect.method_5579().method_18792() != class_4081.field_18272) continue;
            player.method_6016(effect.method_5579());
        }
    }

    private record TickCapsule(Runnable runnable, long tickTarget) {
    }
}

