/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.structures.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzStructurePlacementType;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7059;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class AdvancedRandomSpread
extends class_6872 {
    public static final Codec<AdvancedRandomSpread> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_6874.class_7152.field_37781.optionalFieldOf("exclusion_zone").forGetter(rec$ -> ((AdvancedRandomSpread)((Object)((Object)((Object)rec$)))).method_41646()), (App)SuperExclusionZone.CODEC.optionalFieldOf("super_exclusion_zone").forGetter(AdvancedRandomSpread::superExclusionZone), (App)class_5699.field_33441.fieldOf("spacing").forGetter(AdvancedRandomSpread::method_41632), (App)class_5699.field_33441.fieldOf("separation").forGetter(AdvancedRandomSpread::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(AdvancedRandomSpread::method_41634), (App)class_5699.field_33441.optionalFieldOf("min_distance_from_world_origin").forGetter(AdvancedRandomSpread::minDistanceFromWorldOrigin)).apply((Applicative)instance, instance.stable(AdvancedRandomSpread::new)));
    private final int spacing;
    private final int separation;
    private final class_6873 spreadType;
    private final Optional<Integer> minDistanceFromWorldOrigin;
    private final Optional<SuperExclusionZone> superExclusionZone;

    public AdvancedRandomSpread(class_2382 locationOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, Optional<class_6874.class_7152> exclusionZone, Optional<SuperExclusionZone> superExclusionZone, int spacing, int separation, class_6873 spreadType, Optional<Integer> minDistanceFromWorldOrigin) {
        super(locationOffset, frequencyReductionMethod, frequency, salt, exclusionZone, spacing, separation, spreadType);
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
        this.minDistanceFromWorldOrigin = minDistanceFromWorldOrigin;
        this.superExclusionZone = superExclusionZone;
        if (spacing <= separation) {
            throw new RuntimeException("    Repurposed Structures: Spacing cannot be less or equal to separation.\n    Please correct this error as there's no way to spawn this structure properly\n        Spacing: %s\n        Separation: %s.\n".formatted(spacing, separation));
        }
    }

    public int method_41632() {
        return this.spacing;
    }

    public int method_41633() {
        return this.separation;
    }

    public class_6873 method_41634() {
        return this.spreadType;
    }

    public Optional<Integer> minDistanceFromWorldOrigin() {
        return this.minDistanceFromWorldOrigin;
    }

    public Optional<SuperExclusionZone> superExclusionZone() {
        return this.superExclusionZone;
    }

    public boolean method_41639(class_7869 chunkGeneratorStructureState, int i, int j) {
        if (!super.method_41639(chunkGeneratorStructureState, i, j)) {
            return false;
        }
        return this.superExclusionZone.isEmpty() || !this.superExclusionZone.get().isPlacementForbidden(chunkGeneratorStructureState, i, j);
    }

    public class_1923 method_40169(long seed, int x, int z) {
        int regionX = Math.floorDiv(x, this.spacing);
        int regionZ = Math.floorDiv(z, this.spacing);
        class_2919 worldgenrandom = new class_2919((class_5819)new class_5820(0L));
        worldgenrandom.method_12665(seed, regionX, regionZ, this.method_41645());
        int diff = this.spacing - this.separation;
        int offsetX = this.spreadType.method_40173((class_5819)worldgenrandom, diff);
        int offsetZ = this.spreadType.method_40173((class_5819)worldgenrandom, diff);
        return new class_1923(regionX * this.spacing + offsetX, regionZ * this.spacing + offsetZ);
    }

    protected boolean method_40168(class_7869 chunkGeneratorStructureState, int x, int z) {
        int zBlockPos;
        int xBlockPos;
        if (this.minDistanceFromWorldOrigin.isPresent() && (xBlockPos = x * 16) * xBlockPos + (zBlockPos = z * 16) * zBlockPos < this.minDistanceFromWorldOrigin.get() * this.minDistanceFromWorldOrigin.get()) {
            return false;
        }
        class_1923 chunkpos = this.method_40169(chunkGeneratorStructureState.method_46714(), x, z);
        return chunkpos.field_9181 == x && chunkpos.field_9180 == z;
    }

    public class_6875<?> method_40166() {
        return BzStructurePlacementType.ADVANCED_RANDOM_SPREAD.get();
    }

    public record SuperExclusionZone(List<AvoidData> avoidStructureData) {
        public static final Codec<SuperExclusionZone> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list(AvoidData.CODEC).fieldOf("list_of_avoids").forGetter(SuperExclusionZone::avoidStructureData)).apply((Applicative)builder, SuperExclusionZone::new));

        boolean isPlacementForbidden(class_7869 chunkGeneratorStructureState, int l, int j) {
            for (AvoidData avoidData : this.avoidStructureData) {
                for (class_6880 holder : avoidData.otherSet()) {
                    if (!chunkGeneratorStructureState.method_46709(holder, l, j, avoidData.chunkCount())) continue;
                    return true;
                }
                if (!avoidData.allowedChunkCount().isPresent() || avoidData.allowedChunkCount().get() <= avoidData.chunkCount()) continue;
                boolean isAnyInRange = false;
                for (class_6880 holder : avoidData.otherSet()) {
                    if (!chunkGeneratorStructureState.method_46709(holder, l, j, avoidData.allowedChunkCount().get().intValue())) continue;
                    isAnyInRange = true;
                }
                if (isAnyInRange) continue;
                return false;
            }
            return false;
        }

        private record AvoidData(class_6885<class_7059> otherSet, int chunkCount, Optional<Integer> allowedChunkCount) {
            public static final Codec<AvoidData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_6895.method_40341((class_5321)class_7924.field_41248, (Codec)class_7059.field_37195).fieldOf("other_set").forGetter(AvoidData::otherSet), (App)class_5699.field_33442.fieldOf("chunk_count").forGetter(AvoidData::chunkCount), (App)class_5699.field_33442.optionalFieldOf("allowed_chunk_count").forGetter(AvoidData::allowedChunkCount)).apply((Applicative)builder, AvoidData::new));
        }
    }
}

