/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.temperature.effects;

import com.github.thedeathlycow.thermoo.api.ThermooRegistries;
import com.github.thedeathlycow.thermoo.api.temperature.effects.TemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5270;
import net.minecraft.class_5341;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ConfiguredTemperatureEffect<C> {
    private final TemperatureEffect<C> type;
    private final C config;
    @Nullable
    private final class_5341 predicate;
    @Nullable
    private final class_1299<?> entityType;
    private final class_2096.class_2099 temperatureScaleRange;

    @ApiStatus.Internal
    ConfiguredTemperatureEffect(TemperatureEffect<C> type, C config, @Nullable class_5341 predicate, @Nullable class_1299<?> entityType, class_2096.class_2099 temperatureScaleRange) {
        this.type = type;
        this.config = config;
        this.predicate = predicate;
        this.entityType = entityType;
        this.temperatureScaleRange = temperatureScaleRange;
    }

    public static <C> ConfiguredTemperatureEffect<C> fromJson(TemperatureEffect<C> type, JsonElement configJson, JsonDeserializationContext context, @Nullable class_5341 predicate, @Nullable class_1299<?> entityType, class_2096.class_2099 temperatureScaleRange) throws JsonSyntaxException {
        return new ConfiguredTemperatureEffect<C>(type, type.configFromJson(configJson, context), predicate, entityType, temperatureScaleRange);
    }

    public void applyIfPossible(class_1309 victim) {
        boolean shouldApply;
        class_1937 world = victim.method_37908();
        if (world.field_9236) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        boolean bl = shouldApply = this.type.shouldApply(victim, this.config) && this.temperatureScaleRange.method_9047((double)victim.thermoo$getTemperatureScale()) && this.testPredicate(victim, serverWorld);
        if (shouldApply) {
            this.type.apply(victim, serverWorld, this.config);
        }
    }

    private boolean testPredicate(class_1309 victim, class_3218 world) {
        return this.predicate == null || this.predicate.test((Object)new class_47.class_48(new class_8567.class_8568(world).method_51874(class_181.field_1226, (Object)victim).method_51874(class_181.field_24424, (Object)victim.method_19538()).method_51875(class_173.field_20761)).method_309(null));
    }

    @Nullable
    public class_1299<?> getEntityType() {
        return this.entityType;
    }

    public static class Serializer
    implements JsonDeserializer<ConfiguredTemperatureEffect<?>> {
        public static final Gson GSON = class_5270.method_27860().registerTypeAdapter(ConfiguredTemperatureEffect.class, (Object)new Serializer()).create();

        public ConfiguredTemperatureEffect<?> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject json = jsonElement.getAsJsonObject();
            class_2960 typeID = new class_2960(json.get("type").getAsString());
            if (!ThermooRegistries.TEMPERATURE_EFFECTS.method_10250(typeID)) {
                throw new JsonParseException("Unknown temperature effect type: " + typeID);
            }
            TemperatureEffect effectType = (TemperatureEffect)ThermooRegistries.TEMPERATURE_EFFECTS.method_10223(typeID);
            class_5341 predicate = (class_5341)class_3518.method_15283((JsonObject)json, (String)"entity", null, (JsonDeserializationContext)jsonDeserializationContext, class_5341.class);
            class_2096.class_2099 temperatureScaleRange = class_2096.class_2099.field_9705;
            if (json.has("temperature_scale_range")) {
                temperatureScaleRange = class_2096.class_2099.method_9051((JsonElement)json.get("temperature_scale_range"));
            }
            class_1299 entityType = null;
            if (json.has("entity_type")) {
                class_2960 entityTypeId = new class_2960(json.get("entity_type").getAsString());
                if (class_7923.field_41177.method_10250(entityTypeId)) {
                    entityType = (class_1299)class_7923.field_41177.method_10223(entityTypeId);
                } else {
                    Thermoo.LOGGER.warn("Unknown entity type: {}. Defaulting to NULL.", (Object)entityTypeId);
                }
            }
            return ConfiguredTemperatureEffect.fromJson(effectType, json.get("config"), jsonDeserializationContext, predicate, entityType, temperatureScaleRange);
        }
    }
}

