/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog;

import com.hidoni.transmog.Constants;
import com.hidoni.transmog.RenderUtils;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.registry.ModItems;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class TransmogUtils {
    private static boolean notInPvP = true;
    private static Thread pvpTimerThread = null;
    private static final int MAX_CACHE_ENTRIES = 100;
    private static final Map<Integer, class_1799> TRANSMOG_ITEM_CACHE = new LinkedHashMap<Integer, class_1799>(100, 0.75f, true){

        @Override
        public boolean removeEldestEntry(Map.Entry<Integer, class_1799> eldest) {
            return this.size() > 101;
        }
    };

    public static void startPvP() {
        if (Config.pvpDisableDuration > 0) {
            TransmogUtils.setNotInPvP(false);
            if (pvpTimerThread != null) {
                Constants.LOG.info("Client player still involved in PvP, Extending transmog disable for another {} seconds", (Object)Config.pvpDisableDuration);
                Constants.LOG.debug("Interrupting existing PvP timer thread: {}", (Object)pvpTimerThread);
                pvpTimerThread.interrupt();
            } else {
                Constants.LOG.info("Client player involved in PvP, Disabling transmogs for {} seconds", (Object)Config.pvpDisableDuration);
            }
            pvpTimerThread = new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(Config.pvpDisableDuration);
                    TransmogUtils.setNotInPvP(true);
                    Constants.LOG.info("PvP Timer finished, Transmog re-enabled.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            pvpTimerThread.start();
            Constants.LOG.debug("Created new PvP timer thread: {}", (Object)pvpTimerThread);
        }
    }

    private static synchronized void setNotInPvP(boolean notInPvP) {
        TransmogUtils.notInPvP = notInPvP;
    }

    public static boolean isItemStackTransmogged(class_1799 itemStack) {
        return itemStack.method_7941("transmog:transmogItem") != null;
    }

    public static boolean isHiddenItem(class_1799 appearanceItem) {
        return appearanceItem.method_31574((class_1792)ModItems.VOID_FRAGMENT.get());
    }

    public static class_1799 getAppearanceStackFromTag(@NotNull class_2487 transmogTag) {
        return class_1799.method_7915((class_2487)transmogTag);
    }

    public static void transmogAppearanceOntoItemStack(class_1799 appearanceItem, class_1799 itemToTransmog) {
        itemToTransmog.method_7959("transmog:transmogItem", (class_2520)appearanceItem.method_7953(new class_2487()));
    }

    public static class_1799 getAppearanceItemStack(class_1799 itemStack, boolean keepHiddenItem) {
        class_2487 transmogTag = itemStack.method_7941("transmog:transmogItem");
        if (transmogTag == null || itemStack.method_7960()) {
            return itemStack;
        }
        class_1799 appearanceItem = TRANSMOG_ITEM_CACHE.computeIfAbsent(transmogTag.hashCode(), unused -> TransmogUtils.getAppearanceStackFromTag(transmogTag));
        if (!keepHiddenItem && TransmogUtils.isHiddenItem(appearanceItem)) {
            return class_1799.field_8037;
        }
        return appearanceItem;
    }

    public static class_1799 getAppearanceStackOrOriginal(class_1799 itemStack) {
        if (notInPvP && Config.renderOption.renderInWorld && TransmogUtils.isItemStackTransmogged(itemStack)) {
            if (!RenderUtils.isCalledForInventory()) {
                return TransmogUtils.getAppearanceItemStack(itemStack, false);
            }
            if (Config.renderOption.renderInInventory) {
                class_1799 appearanceItemStack = TransmogUtils.getAppearanceItemStack(itemStack, true);
                if (TransmogUtils.isHiddenItem(appearanceItemStack)) {
                    return itemStack;
                }
                appearanceItemStack.method_7939(itemStack.method_7947());
                return appearanceItemStack;
            }
        }
        return itemStack;
    }
}

