/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.RenderHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import org.apache.commons.lang3.tuple.Triple;

@Environment(value=EnvType.CLIENT)
public class BackpackLayer
extends class_3887<class_742, class_591<class_742>> {
    public BackpackLayer(class_3883<class_742, class_591<class_742>> renderer) {
        super(renderer);
    }

    public void render(class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_742 clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpack.enableIntegration()) {
            return;
        }
        if (ComponentUtils.isWearingBackpack((class_1657)clientPlayer)) {
            class_1799 stack = ComponentUtils.getWearingBackpack((class_1657)clientPlayer);
            BackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (class_572)this.method_17165(), poseStack, bufferIn, packedLightIn, (class_1309)clientPlayer, stack);
        }
    }

    public static void renderBackpackLayer(BackpackLayerModel model, class_572 humanoidModel, class_4587 poseStack, class_4597 bufferIn, int packedLightIn, class_1309 entity, class_1799 stack) {
        class_1792 class_17922;
        if (!NbtHelper.getOrDefault(stack, "IsVisible", true).booleanValue()) {
            return;
        }
        model.setLivingEntity(entity);
        model.setMultiBufferSource(bufferIn);
        if (entity.method_6118(class_1304.field_6174).method_7960() && !stack.method_7960()) {
            model.setBackpackStack(stack);
        }
        if (!((class_17922 = stack.method_7909()) instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)class_17922;
        boolean translucentType = travelersBackpackItem == ModItems.QUARTZ_TRAVELERS_BACKPACK || travelersBackpackItem == ModItems.SNOW_TRAVELERS_BACKPACK;
        boolean cutoutType = travelersBackpackItem == ModItems.WARDEN_TRAVELERS_BACKPACK;
        class_2960 loc = travelersBackpackItem.getBackpackTexture();
        class_4588 vertexConsumer = bufferIn.getBuffer(translucentType ? class_1921.method_23689((class_2960)loc) : class_1921.method_23572((class_2960)loc));
        if (cutoutType) {
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        }
        poseStack.method_22903();
        BackpackLayer.alignModel(poseStack, humanoidModel, model, entity);
        if (NbtHelper.has(stack, "Color") && stack.method_7909() == ModItems.STANDARD_TRAVELERS_BACKPACK) {
            loc = new class_2960("travelersbackpack", "textures/model/dyed.png");
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23572((class_2960)loc));
            Triple<Float, Float, Float> rgb = RenderHelper.intToRGB(BackpackDyeRecipe.getColor(stack));
            model.mainBody.method_22699(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new class_2960("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        }
        model.method_2828(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        loc = BackpackBlockModel.getSleepingBagTexture(NbtHelper.getOrDefault(stack, "SleepingBagColor", class_1767.field_7964.method_7789()));
        vertexConsumer = bufferIn.getBuffer(class_1921.method_23576((class_2960)loc));
        model.sleepingBag.method_22698(poseStack, vertexConsumer, packedLightIn, class_4608.field_21444);
        poseStack.method_22909();
    }

    public static void alignModel(class_4587 poseStack, class_572 parent, BackpackLayerModel backpackModel, class_1309 entity) {
        if (entity.method_18276()) {
            poseStack.method_22904(0.0, -0.155, 0.025);
        }
        parent.method_2818((class_572)backpackModel);
        backpackModel.setupAngles(parent);
        poseStack.method_22904(0.0, 0.175, 0.325);
        poseStack.method_22905(0.85f, 0.85f, 0.85f);
        if (entity.method_6109()) {
            poseStack.method_46416(0.0f, 0.8f, -0.165f);
            float scaleFactor = entity.method_17825();
            poseStack.method_22905(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

