/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.UpgradeSlot;
import com.tiviacz.travelersbackpack.client.screens.buttons.AbilitySliderButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.EquipButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.SleepingBagButton;
import com.tiviacz.travelersbackpack.client.screens.buttons.UnequipButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortingButtons;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.IUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.items.upgrades.TanksUpgradeItem;
import com.tiviacz.travelersbackpack.network.ServerboundSorterPacket;
import com.tiviacz.travelersbackpack.util.BackpackDeathHelper;
import com.tiviacz.travelersbackpack.util.FluidTypeHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BackpackScreen
extends class_465<BackpackBaseMenu>
implements class_3936<BackpackBaseMenu>,
IBackpackScreen {
    public static final class_2960 BACKGROUND_11 = new class_2960("travelersbackpack", "textures/gui/background_11.png");
    public static final class_2960 BACKGROUND_9 = new class_2960("travelersbackpack", "textures/gui/background_9.png");
    public static final class_2960 SLOTS = new class_2960("travelersbackpack", "textures/gui/slots.png");
    public static final class_2960 TANKS = new class_2960("travelersbackpack", "textures/gui/tanks.png");
    public static final class_2960 ICONS = new class_2960("travelersbackpack", "textures/gui/icons.png");
    public static final class_2960 TABS = new class_2960("travelersbackpack", "textures/gui/tabs.png");
    public static final int TOP_BAR_OFFSET = 7;
    public int slotCount;
    public boolean tanksVisible;
    public int upgradeSlotCount;
    public List<UpgradeSlot> upgradeSlots = new ArrayList<UpgradeSlot>();
    boolean upgradesInitialized = false;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SortingButtons sortingButtons;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    private final BackpackWrapper wrapper;
    public int warningTicks = 0;

    public BackpackScreen(BackpackBaseMenu backpackMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)backpackMenu, inventory, component);
        this.wrapper = backpackMenu.getWrapper();
        this.recalculate();
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public class_1657 getScreenPlayer() {
        return ((BackpackBaseMenu)this.method_17577()).player;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    protected void method_25426() {
        super.method_25426();
        this.initButtons();
        this.initWidgets();
    }

    protected void method_37432() {
        super.method_37432();
        if (this.warningTicks > 0) {
            --this.warningTicks;
        }
    }

    public void recalculate() {
        boolean wideTexture;
        this.method_37067();
        this.upgradeSlots.clear();
        this.slotCount = this.getWrapper().getStorage().getSlots();
        this.tanksVisible = this.getWrapper().tanksVisible();
        this.upgradeSlotCount = this.getWrapper().getUpgrades().getSlots();
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.wider = wideTexture = this.slotCount > 81;
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? (this.tanksVisible ? 256 : 212) : (this.tanksVisible ? 220 : 176);
        this.field_2779 = 7 + this.calculateSlotHeight(wideTexture) + playerInventoryHeight;
        this.field_25270 = this.field_2779 - 93;
        this.field_25269 = 8;
        if (this.tanksVisible) {
            this.field_25269 += 22;
        }
        if (wideTexture) {
            this.field_25269 += 18;
        }
    }

    public int getImageHeight() {
        return this.field_2779;
    }

    public int getWidthAdditions() {
        int addition = 0;
        if (this.tanksVisible) {
            addition += 22;
        }
        if (this.wider) {
            addition += 18;
        }
        return addition;
    }

    public void updateScreen() {
        this.recalculate();
        this.method_25426();
    }

    public void renderInventoryBackground(class_332 guiGraphics, int x, int y, class_2960 texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.method_25302(texture, x, y, 0, 0, xSize, 7 + halfSlotHeight);
        int playerInventoryHeight = 97;
        guiGraphics.method_25302(texture, x, y + 7 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(class_332 guiGraphics, int x, int y, int slotCount, int slotsInRow) {
        int lastSlotRow = slotCount % slotsInRow;
        int fullRows = slotCount / slotsInRow;
        guiGraphics.method_25302(SLOTS, x, y, 0, 0, slotsInRow * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            guiGraphics.method_25302(SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
        }
    }

    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.renderUpgradeSlots(guiGraphics, x, y);
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        int inventoryXOffset = this.tanksVisible ? 22 : 0;
        this.renderInventoryBackground(guiGraphics, x + inventoryXOffset, y, wideTexture ? BACKGROUND_11 : BACKGROUND_9, this.field_2792, this.calculateSlotHeight(wideTexture));
        int slotsXOffset = 7;
        if (this.tanksVisible) {
            slotsXOffset = 29;
            int halfTankHeight = this.calculateSlotHeight(wideTexture) / 2;
            int tanksHeight = 90;
            int uOffset = 56;
            int posOffset = 193;
            if (wideTexture) {
                uOffset = 0;
                posOffset = 229;
            }
            guiGraphics.method_25302(TANKS, x, y, 0, 0, 27, 7 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x, y + 7 + halfTankHeight, uOffset, 256 - (tanksHeight + halfTankHeight + 7), 27, tanksHeight + halfTankHeight + 7);
            guiGraphics.method_25302(TANKS, x + posOffset, y, uOffset + 28, 0, 27, 7 + halfTankHeight);
            guiGraphics.method_25302(TANKS, x + posOffset, y + 7 + halfTankHeight, uOffset + 28, 256 - (tanksHeight + halfTankHeight + 7), 27, tanksHeight + halfTankHeight + 7);
        }
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 7, this.slotCount, wideTexture ? 11 : 9);
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    public void renderUpgradeSlots(class_332 guiGraphics, int x, int y) {
        for (UpgradeSlot slot : this.upgradeSlots) {
            slot.render(guiGraphics, x, y);
        }
    }

    public void initializeUpgradeSlots() {
        for (int i = 0; i < this.upgradeSlotCount; ++i) {
            int x = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7873 - 4;
            int y = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).field_7872 - 4;
            this.upgradeSlots.add(new UpgradeSlot(this.getWrapper().getUpgrades(), new Point(this.getGuiLeft() + x, this.getGuiTop() + y), i, x, y, ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)i).isHidden));
        }
        this.upgradesInitialized = true;
    }

    @Override
    public class_327 getFont() {
        return this.field_22793;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), false);
        this.method_37063(this.settingsWidget);
        int xPos = this.field_2776 + (this.wider ? 27 : 9) + (this.tanksVisible ? 22 : (this.wider ? 0 : 18));
        this.sortingButtons = new SortingButtons(this, new Point(xPos, this.field_2800 - 10), 50, 13);
        this.method_37063(this.sortingButtons);
        this.toolSlotsWidget = new ToolSlotsWidget(this, new Point(this.field_2776 + 7, this.field_2800 - 15));
        this.method_37063(this.toolSlotsWidget);
        UpgradeManager manager = this.getWrapper().getUpgradeManager();
        for (Optional<? extends IUpgrade> upgrade : manager.mappedUpgrades.values()) {
            upgrade.ifPresent(loadedUpgrade -> {
                int x = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)this.getWrapper().getUpgradeManager().slotMappedUpgrades.get((Object)upgrade).intValue()).field_7873 - 4;
                int y = ((BackpackBaseMenu)this.field_2797).upgradeSlot.get((int)this.getWrapper().getUpgradeManager().slotMappedUpgrades.get((Object)upgrade).intValue()).field_7872 - 4;
                this.method_37063(loadedUpgrade.createWidget(this, x, y));
            });
        }
        this.initializeUpgradeSlots();
    }

    public void initButtons() {
        this.buttons.clear();
        if (this.getWrapper().getScreenID() == 1) {
            this.buttons.add(new EquipButton(this));
        }
        if (this.getWrapper().getScreenID() == 2 && this.getWrapper().isOwner(((BackpackBaseMenu)this.method_17577()).player)) {
            this.buttons.add(new UnequipButton(this));
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, false));
            }
        }
        if (this.getWrapper().getScreenID() == 3) {
            this.buttons.add(new SleepingBagButton(this));
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.getWrapper().getBackpackStack())) {
                this.buttons.add(new AbilitySliderButton(this, true));
            }
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
        if (this.warningTicks > 0) {
            if (!(((BackpackBaseMenu)this.field_2797).method_34255().method_7909() instanceof TanksUpgradeItem)) {
                this.warningTicks = 0;
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            tooltip.add(class_2561.method_43471((String)"screen.travelersbackpack.cant_apply_upgrade"));
            tooltip.add(class_2561.method_43471((String)"screen.travelersbackpack.too_much_fluid"));
            FluidVariantWrapper leftFluidStack = TanksUpgradeItem.getLeftFluidStack(((BackpackBaseMenu)this.field_2797).method_34255());
            FluidVariantWrapper rightFluidStack = TanksUpgradeItem.getRightFluidStack(((BackpackBaseMenu)this.field_2797).method_34255());
            if (!leftFluidStack.isEmpty() && leftFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(leftFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            if (!rightFluidStack.isEmpty() && rightFluidStack.getAmount() > this.getWrapper().getBackpackTankCapacity()) {
                tooltip.add(this.crateFluidWarning(rightFluidStack, this.getWrapper().getBackpackTankCapacity()));
            }
            guiGraphics.method_51437(this.getFont(), tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public class_2561 crateFluidWarning(FluidVariantWrapper fluidStack, long backpackCapacity) {
        return class_2561.method_43470((String)(FluidTypeHelper.getFluidVariantName(fluidStack.fluidVariant()).getString() + " " + fluidStack.getAmount() + "/" + backpackCapacity + "mB")).method_27692(class_124.field_1061);
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(class_332 guiGraphics) {
        if (!this.getWrapper().getUnsortableSlots().isEmpty()) {
            this.getWrapper().getUnsortableSlots().forEach(i -> guiGraphics.method_25302(ICONS, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(class_332 guiGraphics) {
        if (!this.getWrapper().getMemorySlots().isEmpty()) {
            this.getWrapper().getMemorySlots().forEach(pair -> {
                if (((BackpackBaseMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                    guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackBaseMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected boolean method_2381(double pMouseX, double pMouseY, int pGuiLeft, int pGuiTop, int pMouseButton) {
        if (!((BackpackBaseMenu)this.field_2797).method_34255().method_7960()) {
            for (class_364 widget : this.method_25396()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).method_25405(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return pMouseX < (double)pGuiLeft || pMouseY < (double)pGuiTop || pMouseX >= (double)(pGuiLeft + this.field_2792) || pMouseY >= (double)(pGuiTop + this.field_2779);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.buttons.forEach(b -> b.mouseClicked(mouseX, mouseY, button));
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackBaseMenu)this.field_2797).getPlayerInventory().field_7546.method_37908().method_8396(((BackpackBaseMenu)this.field_2797).getPlayerInventory().field_7546, ((BackpackBaseMenu)this.field_2797).getPlayerInventory().field_7546.method_24515(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.25f, 1.0f);
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (KeybindHandler.SORT_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            PacketDistributorHelper.sendToServer(new ServerboundSorterPacket(this.getWrapper().getScreenID(), 0, BackpackDeathHelper.isShiftPressed()));
            this.playUIClickSound();
            return true;
        }
        if (KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public static void displayTanksUpgradeWarning(class_1657 player) {
        class_437 class_4372;
        if (player.method_37908().field_9236 && (class_4372 = class_310.method_1551().field_1755) instanceof BackpackScreen) {
            BackpackScreen screen = (BackpackScreen)class_4372;
            screen.warningTicks = 60;
        }
    }
}

