/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.IBackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.buttons.IButton;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.SettingsWidgetBase;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.UnsortablesWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.settings.VisibilityWidget;
import com.tiviacz.travelersbackpack.handlers.KeybindHandler;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackSettingsMenu;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_364;
import net.minecraft.class_3936;
import net.minecraft.class_465;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BackpackSettingsScreen
extends class_465<BackpackSettingsMenu>
implements class_3936<BackpackSettingsMenu>,
IBackpackScreen {
    public static final int TOP_BAR_OFFSET = 7;
    public int slotCount;
    boolean wider = false;
    public List<IButton> buttons = new ArrayList<IButton>();
    public SettingsWidget settingsWidget;
    public UnsortablesWidget unsortablesWidget;
    public MemoryWidget memoryWidget;
    public VisibilityWidget visibilityWidget;
    private final BackpackWrapper wrapper;
    public List<Integer> lastUnsortableSlots;
    public List<Integer> unsortableSlots = new ArrayList<Integer>();
    public List<Pair<Integer, Pair<class_1799, Boolean>>> lastMemorySlots;
    public List<Pair<Integer, Pair<class_1799, Boolean>>> memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>();
    public boolean visibility;

    public BackpackSettingsScreen(BackpackSettingsMenu backpackSettingsMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)backpackSettingsMenu, inventory, component);
        this.wrapper = backpackSettingsMenu.getWrapper();
        this.recalculate();
        this.lastUnsortableSlots = new ArrayList<Integer>(this.wrapper.getUnsortableSlots());
        this.unsortableSlots = new ArrayList<Integer>(this.lastUnsortableSlots);
        this.lastMemorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.wrapper.getMemorySlots());
        this.memorySlots = new ArrayList<Pair<Integer, Pair<class_1799, Boolean>>>(this.lastMemorySlots);
        this.visibility = NbtHelper.getOrDefault(this.wrapper.getBackpackStack(), "IsVisible", true);
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public class_1657 getScreenPlayer() {
        return ((BackpackSettingsMenu)this.method_17577()).player;
    }

    public int getGuiLeft() {
        return this.field_2776;
    }

    public int getGuiTop() {
        return this.field_2800;
    }

    @Override
    public void sendDataToServer() {
        this.unsortablesWidget.sendDataToServer();
        this.memoryWidget.sendDataToServer();
    }

    protected void method_25426() {
        super.method_25426();
        this.initButtons();
        this.initWidgets();
    }

    protected void renderSlotContents(class_332 guiGraphics, class_1799 itemstack, class_1735 slot, String countString) {
        class_332 p_281607_ = guiGraphics;
        class_1735 p_282613_ = slot;
        String s = countString;
        int i = slot.field_7873;
        int j = slot.field_7872;
        int j1 = p_282613_.field_7873 + p_282613_.field_7872 * this.field_2792;
    }

    public void recalculate() {
        boolean wideTexture;
        this.method_37067();
        this.slotCount = this.getWrapper().getStorage().getSlots();
        this.field_2776 = 0;
        this.field_2800 = 0;
        this.wider = wideTexture = this.slotCount > 81;
        int playerInventoryHeight = 96;
        this.field_2792 = wideTexture ? 212 : 176;
        this.field_2779 = 7 + this.calculateSlotHeight(wideTexture) + playerInventoryHeight;
        this.field_25270 = this.field_2779 - 93;
        this.field_25269 = 8;
        if (wideTexture) {
            this.field_25269 += 18;
        }
    }

    public void renderInventoryBackground(class_332 guiGraphics, int x, int y, class_2960 texture, int xSize, int slotsHeight) {
        int halfSlotHeight = slotsHeight / 2;
        guiGraphics.method_25302(texture, x, y, 0, 0, xSize, 7 + halfSlotHeight);
        int playerInventoryHeight = 97;
        guiGraphics.method_25302(texture, x, y + 7 + halfSlotHeight, 0, 256 - (playerInventoryHeight + halfSlotHeight), xSize, playerInventoryHeight + halfSlotHeight);
    }

    public void renderSlots(class_332 guiGraphics, int x, int y, int slotCount, int slotsInRow) {
        int lastSlotRow = slotCount % slotsInRow;
        int fullRows = slotCount / slotsInRow;
        guiGraphics.method_25302(BackpackScreen.SLOTS, x, y, 0, 0, slotsInRow * 18, fullRows * 18);
        if (lastSlotRow > 0) {
            guiGraphics.method_25302(BackpackScreen.SLOTS, x, y + fullRows * 18, 0, fullRows * 18, lastSlotRow * 18, 18);
        }
    }

    public void renderScreen(class_332 guiGraphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderBg(guiGraphics, x, y, mouseX, mouseY));
        boolean wideTexture = this.slotCount > 81;
        this.renderInventoryBackground(guiGraphics, x, y, wideTexture ? BackpackScreen.BACKGROUND_11 : BackpackScreen.BACKGROUND_9, this.field_2792, this.calculateSlotHeight(wideTexture));
        int slotsXOffset = 7;
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderAboveBg(guiGraphics, x, y, mouseX, mouseY, partialTicks));
        this.renderSlots(guiGraphics, x + slotsXOffset, y + 7, this.slotCount, wideTexture ? 11 : 9);
    }

    public int calculateSlotHeight(boolean wider) {
        int rowSlots = wider ? 11 : 9;
        int rows = (int)Math.ceil((double)this.slotCount / (double)rowSlots);
        return rows * 18;
    }

    @Override
    public class_327 getFont() {
        return this.field_22793;
    }

    public void initWidgets() {
        this.settingsWidget = new SettingsWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4), true);
        this.method_37063(this.settingsWidget);
        this.unsortablesWidget = new UnsortablesWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1));
        this.method_37063(this.unsortablesWidget);
        this.memoryWidget = new MemoryWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1), false);
        this.method_37063(this.memoryWidget);
        if (this.getWrapper().getScreenID() == 2) {
            this.visibilityWidget = new VisibilityWidget(this, new Point(this.field_2776 + this.field_2792 - 3, this.field_2800 + 4 + 24 + 1 + 24 + 1 + 24 + 1));
            this.method_37063(this.visibilityWidget);
        }
    }

    public void initButtons() {
        this.buttons.clear();
    }

    public void closeTabs(SettingsWidgetBase openedWidget) {
        this.method_25396().stream().filter(widget -> widget instanceof SettingsWidgetBase && widget != openedWidget).forEach(widget -> {
            ((SettingsWidgetBase)widget).tabOpened = false;
        });
    }

    public void updateWidgetsPosition(SettingsWidgetBase openedWidget) {
        this.closeTabs(openedWidget);
        List<class_364> widgets = this.method_25396().stream().filter(w -> w instanceof SettingsWidgetBase).toList();
        for (int i = 0; i < widgets.size(); ++i) {
            SettingsWidgetBase previousWidget = null;
            SettingsWidgetBase currentWidget = (SettingsWidgetBase)widgets.get(i);
            if (i > 0) {
                previousWidget = (SettingsWidgetBase)widgets.get(i - 1);
            }
            if (previousWidget == null) continue;
            int[] previousWidgetPosAndSize = previousWidget.getWidgetSizeAndPos();
            currentWidget.updatePos(previousWidgetPosAndSize[1], previousWidgetPosAndSize[3] + 1);
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.buttons.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTicks));
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        this.buttons.forEach(button -> button.renderTooltip(guiGraphics, mouseX, mouseY));
        this.method_25396().stream().filter(w -> w instanceof WidgetBase).forEach(w -> ((WidgetBase)w).renderTooltip(guiGraphics, mouseX, mouseY));
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderScreen(guiGraphics, x, y, mouseX, mouseY, partialTicks);
        this.drawUnsortableSlots(guiGraphics);
        this.drawMemorySlots(guiGraphics);
    }

    public void drawUnsortableSlots(class_332 guiGraphics) {
        if (this.unsortablesWidget.isTabOpened()) {
            if (!this.unsortableSlots.isEmpty()) {
                this.unsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
            }
        } else if (!this.lastUnsortableSlots.isEmpty()) {
            this.lastUnsortableSlots.forEach(i -> guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)i.intValue()).field_7872, 25, 55, 16, 16));
        }
    }

    public void drawMemorySlots(class_332 guiGraphics) {
        if (this.memoryWidget.isTabOpened()) {
            if (!this.memorySlots.isEmpty()) {
                this.memorySlots.forEach(pair -> {
                    if (((Boolean)((Pair)pair.getSecond()).getSecond()).booleanValue()) {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25, 73, 16, 16);
                    } else {
                        guiGraphics.method_25302(BackpackScreen.ICONS, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, 25, 91, 16, 16);
                    }
                    if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                        class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                        guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                        guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                    }
                });
            }
        } else if (!this.lastMemorySlots.isEmpty()) {
            this.lastMemorySlots.forEach(pair -> {
                if (((BackpackSettingsMenu)this.method_17577()).method_7611((Integer)pair.getFirst()).method_7677().method_7960()) {
                    class_1799 itemstack = (class_1799)((Pair)pair.getSecond()).getFirst();
                    guiGraphics.method_51445(itemstack, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872);
                    guiGraphics.method_51739(class_1921.method_51787(), this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872, this.getGuiLeft() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7873 + 16, this.getGuiTop() + ((BackpackSettingsMenu)this.method_17577()).method_7611((int)((Integer)pair.getFirst()).intValue()).field_7872 + 16, 0x30FFFFFF);
                }
            });
        }
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 type) {
        if (this.selectSlots(slot, button)) {
            return;
        }
        super.method_2383(slot, slotId, button, type);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        class_1735 slot = this.field_2787;
        if (this.selectSlots(slot, pButton)) {
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean selectSlots(class_1735 slot, int button) {
        if (slot != null && slot.field_7874 >= 0 && slot.field_7874 < this.wrapper.getStorage().getSlots()) {
            if (this.unsortablesWidget.isTabOpened()) {
                if (button == 0 && !this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.add(slot.field_7874);
                    return true;
                }
                if (button == 1 && this.unsortableSlots.contains(slot.field_7874)) {
                    this.unsortableSlots.remove((Object)slot.field_7874);
                    return true;
                }
            }
            if (this.memoryWidget.isTabOpened()) {
                if (button == 0 && !this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    if (slot.method_7677().method_7960()) {
                        return false;
                    }
                    this.memorySlots.add((Pair<Integer, Pair<class_1799, Boolean>>)Pair.of((Object)slot.field_7874, (Object)Pair.of((Object)(this.memoryWidget.matchComponents ? slot.method_7677() : slot.method_7677().method_7909().method_7854()), (Object)this.memoryWidget.matchComponents)));
                    return true;
                }
                if (button == 1 && this.memoryWidget.contains(slot.field_7874, this.memorySlots)) {
                    this.memorySlots.removeIf(p -> (Integer)p.getFirst() == slot.field_7874);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void playUIClickSound() {
        ((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546.method_37908().method_8396(((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546, ((BackpackSettingsMenu)this.field_2797).getPlayerInventory().field_7546.method_24515(), (class_3414)class_3417.field_15015.comp_349(), class_3419.field_15250, 0.25f, 1.0f);
    }

    public void method_25419() {
        this.sendDataToServer();
        super.method_25419();
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (KeybindHandler.OPEN_BACKPACK.method_1417(pKeyCode, pScanCode)) {
            class_746 playerEntity = this.field_22787.field_1724;
            if (playerEntity != null) {
                this.method_25419();
            }
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }
}

