/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.tiviacz.travelersbackpack.blockentity.BackpackBlockEntity;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.fluids.EffectFluidRegistry;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.FluidTank;
import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackItemMenu;
import com.tiviacz.travelersbackpack.inventory.sorter.ContainerSorter;
import com.tiviacz.travelersbackpack.items.HoseItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncItemStackPacket;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ServerActions {
    public static void swapTool(class_1657 player, double scrollDelta) {
        if (ComponentUtils.isWearingBackpack(player)) {
            int i;
            ItemStackHandler inv = ComponentUtils.getBackpackWrapper(player).getTools();
            if (InventoryHelper.isEmpty(inv)) {
                return;
            }
            int toolSlots = inv.getSlots();
            int lastSlot = toolSlots - 1;
            int j = 0;
            for (int i2 = 0; i2 <= lastSlot; ++i2) {
                if (inv.getStackInSlot(i2).method_7960()) continue;
                ++j;
            }
            class_1799[] tools = new class_1799[j];
            int slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                tools[slot] = inv.getStackInSlot(i).method_7972();
                ++slot;
            }
            ServerActions.swapTool(scrollDelta, tools, player);
            slot = 0;
            for (i = 0; i <= j - 1; ++i) {
                inv.setStackInSlot(i, tools[slot]);
                ++slot;
            }
            ComponentUtils.getBackpackWrapper(player).sendDataToClients("ToolsInventory");
        }
    }

    public static void swapTool(double delta, class_1799[] tools, class_1657 player) {
        int i;
        class_1799 tempStack;
        if (delta > 0.0) {
            tempStack = tools[0];
            for (i = 0; i <= tools.length - 1; ++i) {
                if (i + 1 > tools.length - 1) {
                    tools[tools.length - 1] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                    continue;
                }
                tools[i] = tools[i + 1];
            }
        }
        if (delta < 0.0) {
            tempStack = tools[tools.length - 1];
            for (i = tools.length - 1; i >= 0; --i) {
                if (i - 1 < 0) {
                    tools[0] = player.method_6047();
                    player.method_6122(class_1268.field_5808, tempStack);
                    continue;
                }
                tools[i] = tools[i - 1];
            }
        }
    }

    public static void equipBackpack(class_1657 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236) {
            if (!ComponentUtils.isWearingBackpack(player)) {
                if (player.field_7512 instanceof BackpackItemMenu) {
                    ((class_3222)player).method_7346();
                }
                class_1799 stack = player.method_6047().method_7972();
                ComponentUtils.getComponentOptional(player).ifPresent(attachment -> {
                    attachment.equipBackpack(stack);
                    attachment.synchronise();
                });
                player.method_6047().method_7934(1);
                level.method_8396(null, player.method_24515(), class_3417.field_14581, class_3419.field_15248, 1.0f, (1.0f + (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.2f) * 0.7f);
            } else {
                ((class_3222)player).method_7346();
                player.method_43496((class_2561)class_2561.method_43471((String)"action.travelersbackpack.equip_otherbackpack"));
            }
        }
    }

    public static void unequipBackpack(class_1657 player) {
        class_1937 level = player.method_37908();
        if (!level.field_9236 && ComponentUtils.isWearingBackpack(player)) {
            if (player.field_7512 instanceof BackpackItemMenu) {
                ((class_3222)player).method_7346();
            }
            class_1799 backpack = ComponentUtils.getWearingBackpack(player).method_7972();
            if (!player.method_31548().method_7394(backpack)) {
                player.method_43496((class_2561)class_2561.method_43471((String)"action.travelersbackpack.unequip_nospace"));
                return;
            }
            ComponentUtils.getComponentOptional(player).ifPresent(attachment -> {
                attachment.equipBackpack(new class_1799((class_1935)class_1802.field_8162, 0));
                attachment.synchronise();
            });
            level.method_8396(null, player.method_24515(), class_3417.field_14581, class_3419.field_15248, 1.05f, (1.0f + (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.2f) * 0.7f);
        }
    }

    public static void switchAbilitySlider(BackpackWrapper wrapper, boolean sliderValue) {
        wrapper.setAbilityEnabled(sliderValue);
        if (wrapper.getBackpackOwner() != null) {
            if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, wrapper.getBackpackStack()) && !sliderValue) {
                BackpackAbilities.ABILITIES.abilityRemoval(wrapper.getBackpackStack(), wrapper.getBackpackOwner());
            }
            if (wrapper.getBackpackStack().method_7909() == ModItems.CHICKEN_TRAVELERS_BACKPACK && wrapper.getCooldown() <= 0) {
                BackpackAbilities.ABILITIES.chickenAbilityNew(wrapper.getBackpackStack(), wrapper.getBackpackOwner(), true);
            }
        }
    }

    public static void sortBackpack(class_1657 player, byte screenID, byte button, boolean shiftPressed) {
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof BackpackBaseMenu) {
            BackpackBaseMenu menu = (BackpackBaseMenu)class_17032;
            ContainerSorter.selectSort(menu.getWrapper(), player, button, shiftPressed);
        }
    }

    public static void toggleVisibility(class_1657 player) {
        BackpackWrapper wrapper;
        boolean visibility = NbtHelper.getOrDefault((wrapper = ComponentUtils.getBackpackWrapper(player)).getBackpackStack(), "IsVisible", true);
        wrapper.setVisibility(!visibility);
    }

    public static void toggleSleepingBag(class_1657 player, class_2338 pos) {
        class_1937 level = player.method_37908();
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof BackpackBlockEntity) {
            BackpackBlockEntity blockEntity = (BackpackBlockEntity)class_25862;
            if (!blockEntity.isSleepingBagDeployed()) {
                if (!blockEntity.deploySleepingBag(level, pos)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"action.travelersbackpack.deploy_sleeping_bag"));
                }
            } else {
                blockEntity.removeSleepingBag(level, blockEntity.getBlockDirection());
            }
            if (!level.field_9236) {
                ((class_3222)player).method_7346();
            }
        }
    }

    public static boolean setFluidEffect(class_1937 level, class_1657 player, FluidTank tank) {
        FluidVariantWrapper fluidStack = tank.getFluid();
        boolean done = false;
        if (EffectFluidRegistry.hasExecutableEffects(fluidStack, level, (class_1297)player)) {
            done = EffectFluidRegistry.executeEffects(fluidStack, (class_1297)player, level);
        }
        return done;
    }

    public static void switchHoseMode(class_1657 player, double scrollDelta) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (scrollDelta > 0.0) {
                int nextMode = settings.get(0) + 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 4 ? 1 : nextMode), settings.get(1)));
            } else if (scrollDelta < 0.0) {
                int nextMode = settings.get(0) - 1;
                NbtHelper.set(hose, "HoseModes", List.of(Integer.valueOf(nextMode == 0 ? 3 : nextMode), settings.get(1)));
            }
        }
        if (!player.method_37908().field_9236) {
            class_2487 builder = new class_2487();
            if (hose.method_7985() && hose.method_7969().method_10545("HoseModes")) {
                builder.method_10566("HoseModes", (class_2520)hose.method_7969().method_10554("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().field_7545, hose, builder));
        }
    }

    public static void toggleHoseTank(class_1657 player) {
        class_1799 hose = player.method_6047();
        if (hose.method_7909() instanceof HoseItem) {
            List<Integer> settings = NbtHelper.getOrDefault(hose, "HoseModes", List.of(Integer.valueOf(1), Integer.valueOf(1)));
            if (settings.get(1) == 1) {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(2)));
            } else {
                NbtHelper.set(hose, "HoseModes", List.of(settings.get(0), Integer.valueOf(1)));
            }
        }
        if (!player.method_37908().field_9236) {
            class_2487 builder = new class_2487();
            if (hose.method_7985() && hose.method_7969().method_10545("HoseModes")) {
                builder.method_10566("HoseModes", (class_2520)hose.method_7969().method_10554("HoseModes", 3));
            }
            PacketDistributorHelper.sendToPlayer((class_3222)player, new ClientboundSyncItemStackPacket(player.method_5628(), player.method_31548().field_7545, hose, builder));
        }
    }
}

