/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tiviacz.travelersbackpack.components.RenderInfo;
import com.tiviacz.travelersbackpack.init.ModRecipeSerializers;
import com.tiviacz.travelersbackpack.inventory.SlotPositioner;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_8060;

public class BackpackUpgradeRecipe
extends class_8060 {
    final class_1856 template;
    final class_1856 base;
    final class_1856 addition;
    final class_1799 result;

    public BackpackUpgradeRecipe(class_2960 id, class_1856 pTemplate, class_1856 pBase, class_1856 pAddition, class_1799 pResult) {
        super(id, pTemplate, pBase, pAddition, pResult);
        this.template = pTemplate;
        this.base = pBase;
        this.addition = pAddition;
        this.result = pResult;
    }

    public class_1799 method_8116(class_1263 pInput, class_5455 pRegistryAccess) {
        int tier;
        class_1799 result = this.result.method_7972();
        class_2487 compoundtag = pInput.method_5438(1).method_7969();
        if (compoundtag != null) {
            result.method_7980(compoundtag.method_10553());
        }
        class_1799 base = pInput.method_5438(1);
        class_1799 addition = pInput.method_5438(2);
        if (addition.method_31574(Tiers.of(tier = NbtHelper.getOrDefault(base, "Tier", 0).intValue()).getTierUpgradeIngredient())) {
            this.upgradeInventory(result, Tiers.of(tier).getNextTier());
            return result;
        }
        return class_1799.field_8037;
    }

    public void upgradeInventory(class_1799 stack, Tiers.Tier nextTier) {
        NbtHelper.set(stack, "Tier", nextTier.getOrdinal());
        NbtHelper.set(stack, "StorageSlots", nextTier.getStorageSlots());
        NbtHelper.set(stack, "UpgradeSlots", nextTier.getUpgradeSlots());
        NbtHelper.set(stack, "ToolSlots", nextTier.getToolSlots());
        if (NbtHelper.has(stack, "RenderInfo")) {
            NbtHelper.set(stack, "RenderInfo", this.getUpgradedTanksCapacity(stack, nextTier.getStorageSlots()));
        }
    }

    public RenderInfo getUpgradedTanksCapacity(class_1799 stack, int storageSlots) {
        SlotPositioner pos = new SlotPositioner(storageSlots);
        int rows = pos.getRows() + (pos.isExtended() ? 2 : 0);
        RenderInfo infoTag = (RenderInfo)NbtHelper.get(stack, "RenderInfo");
        RenderInfo newInfo = new RenderInfo(infoTag.compoundTag().method_10553());
        newInfo.updateCapacity(Tiers.of(NbtHelper.getOrDefault(stack, "Tier", 0)).getTankCapacityPerRow() * (long)rows);
        return newInfo;
    }

    public class_1865<?> method_8119() {
        return ModRecipeSerializers.BACKPACK_UPGRADE;
    }

    public static class Serializer
    implements class_1865<BackpackUpgradeRecipe> {
        public BackpackUpgradeRecipe fromJson(class_2960 p_266953_, JsonObject p_266720_) {
            class_1856 ingredient = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)p_266720_, (String)"template"));
            class_1856 ingredient1 = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)p_266720_, (String)"base"));
            class_1856 ingredient2 = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)p_266720_, (String)"addition"));
            class_1799 itemstack = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)p_266720_, (String)"result"));
            return new BackpackUpgradeRecipe(p_266953_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public BackpackUpgradeRecipe fromNetwork(class_2960 p_267117_, class_2540 p_267316_) {
            class_1856 ingredient = class_1856.method_8086((class_2540)p_267316_);
            class_1856 ingredient1 = class_1856.method_8086((class_2540)p_267316_);
            class_1856 ingredient2 = class_1856.method_8086((class_2540)p_267316_);
            class_1799 itemstack = p_267316_.method_10819();
            return new BackpackUpgradeRecipe(p_267117_, ingredient, ingredient1, ingredient2, itemstack);
        }

        public void toNetwork(class_2540 p_266746_, BackpackUpgradeRecipe p_266927_) {
            p_266927_.template.method_8088(p_266746_);
            p_266927_.base.method_8088(p_266746_);
            p_266927_.addition.method_8088(p_266746_);
            p_266746_.method_10793(p_266927_.result);
        }
    }
}

