/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.component;

import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.component.ITravelersBackpack;
import com.tiviacz.travelersbackpack.component.ITravelersBackpackComponent;
import com.tiviacz.travelersbackpack.component.TravelersBackpackComponent;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketsApi;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class ComponentUtils
implements EntityComponentInitializer {
    public static final ComponentKey<ITravelersBackpack> WEARABLE = ComponentRegistry.getOrCreate((class_2960)new class_2960("travelersbackpack", "travelersbackpack"), ITravelersBackpack.class);

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(WEARABLE, TravelersBackpackComponent::new, RespawnCopyStrategy.ALWAYS_COPY);
    }

    public static ITravelersBackpackComponent getComponent(class_1657 player) {
        return ComponentUtils.getComponentOptional(player).get();
    }

    public static Optional<ITravelersBackpack> getComponentOptional(class_1657 player) {
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of((ITravelersBackpack)player.getComponent(WEARABLE));
    }

    public static void synchronise(class_1657 player) {
        if (player instanceof class_3222) {
            ComponentUtils.getComponentOptional(player).ifPresent(ITravelersBackpack::synchronise);
        }
    }

    public static boolean isWearingBackpack(class_1657 player) {
        if (TravelersBackpack.enableIntegration()) {
            if (TravelersBackpack.enableTrinkets() && TrinketsApi.getTrinketComponent((class_1309)player).isPresent()) {
                return ((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).isEquipped(t -> t.method_7909() instanceof TravelersBackpackItem);
            }
            return false;
        }
        if (ComponentUtils.getComponentOptional(player).isPresent()) {
            return ComponentUtils.getComponentOptional(player).get().hasBackpack() && ComponentUtils.getComponentOptional(player).get().getBackpack().method_7909() instanceof TravelersBackpackItem;
        }
        return false;
    }

    public static class_1799 getWearingBackpack(class_1657 player) {
        if (TravelersBackpack.enableIntegration()) {
            if (TravelersBackpack.enableTrinkets()) {
                return ComponentUtils.isWearingBackpack(player) ? (class_1799)((class_3545)((TrinketComponent)TrinketsApi.getTrinketComponent((class_1309)player).get()).getEquipped(t -> t.method_7909() instanceof TravelersBackpackItem).get(0)).method_15441() : class_1799.field_8037;
            }
            return class_1799.field_8037;
        }
        return ComponentUtils.isWearingBackpack(player) ? ComponentUtils.getComponentOptional(player).get().getBackpack() : class_1799.field_8037;
    }

    public static void equipBackpack(class_1657 player, class_1799 stack) {
        if (ComponentUtils.getComponentOptional(player).isPresent() && !ComponentUtils.isWearingBackpack(player)) {
            ComponentUtils.getComponentOptional(player).ifPresent(attachment -> attachment.equipBackpack(stack));
            player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14581, class_3419.field_15248, 1.0f, (1.0f + (player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
            ComponentUtils.synchronise(player);
        }
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player, class_1799 stack) {
        if (TravelersBackpack.enableIntegration()) {
            if (ComponentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, stack);
            }
            return null;
        }
        if (ComponentUtils.isWearingBackpack(player)) {
            return ComponentUtils.getComponentOptional(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }

    @Nullable
    public static BackpackWrapper getBackpackWrapper(class_1657 player) {
        if (TravelersBackpack.enableIntegration()) {
            if (ComponentUtils.isWearingBackpack(player)) {
                return BackpackWrapper.getBackpackWrapper(player, ComponentUtils.getWearingBackpack(player));
            }
            return null;
        }
        if (ComponentUtils.isWearingBackpack(player)) {
            return ComponentUtils.getComponentOptional(player).map(ITravelersBackpack::getWrapper).orElse(null);
        }
        return null;
    }
}

