/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.config;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfigData;
import java.util.Arrays;
import java.util.NoSuchElementException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class TravelersBackpackConfig {
    public static TravelersBackpackConfigData getConfig() {
        return (TravelersBackpackConfigData)AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).getConfig();
    }

    public static void saveConfig() {
        AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).save();
    }

    public static void register() {
        AutoConfig.register(TravelersBackpackConfigData.class, JanksonConfigSerializer::new);
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((s, m) -> AutoConfig.getConfigHolder(TravelersBackpackConfigData.class).load());
    }

    public static boolean isToolAllowed(class_1799 value) {
        return TravelersBackpackConfig.isOnItemList(value, TravelersBackpackConfig.getConfig().backpackSettings.toolSlotsAcceptableItems);
    }

    public static boolean isItemBlacklisted(class_1799 value) {
        return TravelersBackpackConfig.isOnItemList(value, TravelersBackpackConfig.getConfig().backpackSettings.blacklistedItems);
    }

    public static boolean isAbilityAllowed(class_1799 value) {
        if (!TravelersBackpackConfig.getConfig().backpackAbilities.enableBackpackAbilities) {
            return false;
        }
        return TravelersBackpackConfig.isOnItemList(value, TravelersBackpackConfig.getConfig().backpackAbilities.allowedAbilities);
    }

    public static boolean isOverworldEntityTypePossible(class_1297 value) {
        return TravelersBackpackConfig.isOnEntityList(value, TravelersBackpackConfig.getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isNetherEntityTypePossible(class_1297 value) {
        return TravelersBackpackConfig.isOnEntityList(value, TravelersBackpackConfig.getConfig().world.possibleOverworldEntityTypes);
    }

    public static boolean isOnEntityList(class_1297 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41177.method_10221((Object)value.method_5864()).toString()));
    }

    public static boolean isOnItemList(class_1799 value, String[] list) {
        return Arrays.stream(list).anyMatch(p -> p.equals(class_7923.field_41178.method_10221((Object)value.method_7909()).toString()));
    }

    public static class_1792 getRandomCompatibleOverworldBackpackEntry(class_5819 random) {
        String[] backpacks = TravelersBackpackConfig.getConfig().world.overworldBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];
        return (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_1792 getRandomCompatibleNetherBackpackEntry(class_5819 random) {
        String[] backpacks = TravelersBackpackConfig.getConfig().world.netherBackpacks;
        String selectedBackpack = backpacks[random.method_43048(backpacks.length)];
        return (class_1792)class_7923.field_41178.method_17966(class_2960.method_12829((String)selectedBackpack)).orElseThrow(() -> new NoSuchElementException("Wrong backpack registry name specified in the config!"));
    }

    public static class_2487 writeToNbt() {
        TravelersBackpackConfigData data = TravelersBackpackConfig.getConfig();
        class_2487 nbt = new class_2487();
        nbt.method_10556("backpackUpgrades.enableTanksUpgrade", data.backpackUpgrades.enableTanksUpgrade);
        nbt.method_10556("backpackUpgrades.enableCraftingUpgrade", data.backpackUpgrades.enableCraftingUpgrade);
        nbt.method_10556("backpackUpgrades.enableJukeboxUpgrade", data.backpackUpgrades.enableJukeboxUpgrade);
        nbt.method_10556("backpackUpgrades.pickupUpgradeSettings.enableUpgrade", data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.pickupUpgradeSettings.filterSlotCount", data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount);
        nbt.method_10556("backpackUpgrades.magnetUpgradeSettings.enableUpgrade", data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.filterSlotCount", data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackUpgrades.magnetUpgradeSettings.pullRange", data.backpackUpgrades.magnetUpgradeSettings.pullRange);
        nbt.method_10556("backpackUpgrades.feedingUpgradeSettings.enableUpgrade", data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.feedingUpgradeSettings.filterSlotCount", data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount);
        nbt.method_10556("backpackUpgrades.voidUpgradeSettings.enableUpgrade", data.backpackUpgrades.voidUpgradeSettings.enableUpgrade);
        nbt.method_10569("backpackUpgrades.voidUpgradeSettings.filterSlotCount", data.backpackUpgrades.voidUpgradeSettings.filterSlotCount);
        nbt.method_10569("backpackSettings.leather.inventorySlotCount", data.backpackSettings.leather.inventorySlotCount);
        nbt.method_10569("backpackSettings.leather.upgradeSlotCount", data.backpackSettings.leather.upgradeSlotCount);
        nbt.method_10569("backpackSettings.leather.toolSlotCount", data.backpackSettings.leather.toolSlotCount);
        nbt.method_10544("backpackSettings.leather.tankCapacityPerRow", data.backpackSettings.leather.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.iron.inventorySlotCount", data.backpackSettings.iron.inventorySlotCount);
        nbt.method_10569("backpackSettings.iron.upgradeSlotCount", data.backpackSettings.iron.upgradeSlotCount);
        nbt.method_10569("backpackSettings.iron.toolSlotCount", data.backpackSettings.iron.toolSlotCount);
        nbt.method_10544("backpackSettings.iron.tankCapacityPerRow", data.backpackSettings.iron.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.gold.inventorySlotCount", data.backpackSettings.gold.inventorySlotCount);
        nbt.method_10569("backpackSettings.gold.upgradeSlotCount", data.backpackSettings.gold.upgradeSlotCount);
        nbt.method_10569("backpackSettings.gold.toolSlotCount", data.backpackSettings.gold.toolSlotCount);
        nbt.method_10544("backpackSettings.gold.tankCapacityPerRow", data.backpackSettings.gold.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.diamond.inventorySlotCount", data.backpackSettings.diamond.inventorySlotCount);
        nbt.method_10569("backpackSettings.diamond.upgradeSlotCount", data.backpackSettings.diamond.upgradeSlotCount);
        nbt.method_10569("backpackSettings.diamond.toolSlotCount", data.backpackSettings.diamond.toolSlotCount);
        nbt.method_10544("backpackSettings.diamond.tankCapacityPerRow", data.backpackSettings.diamond.tankCapacityPerRow);
        nbt.method_10569("backpackSettings.netherite.inventorySlotCount", data.backpackSettings.netherite.inventorySlotCount);
        nbt.method_10569("backpackSettings.netherite.upgradeSlotCount", data.backpackSettings.netherite.upgradeSlotCount);
        nbt.method_10569("backpackSettings.netherite.toolSlotCount", data.backpackSettings.netherite.toolSlotCount);
        nbt.method_10544("backpackSettings.netherite.tankCapacityPerRow", data.backpackSettings.netherite.tankCapacityPerRow);
        nbt.method_10556("backpackSettings.rightClickEquip", data.backpackSettings.rightClickEquip);
        nbt.method_10556("backpackSettings.rightClickUnequip", data.backpackSettings.rightClickUnequip);
        nbt.method_10556("backpackSettings.allowOnlyEquippedBackpack", data.backpackSettings.allowOnlyEquippedBackpack);
        nbt.method_10556("backpackSettings.invulnerableBackpack", data.backpackSettings.invulnerableBackpack);
        nbt.method_10582("backpackSettings.toolSlotsAcceptableItems", String.join((CharSequence)",", data.backpackSettings.toolSlotsAcceptableItems));
        nbt.method_10582("backpackSettings.blacklistedItems", String.join((CharSequence)",", data.backpackSettings.blacklistedItems));
        nbt.method_10556("backpackSettings.toolSlotsAcceptEverything", data.backpackSettings.toolSlotsAcceptEverything);
        nbt.method_10556("backpackSettings.allowShulkerBoxes", data.backpackSettings.allowShulkerBoxes);
        nbt.method_10556("backpackSettings.voidProtection", data.backpackSettings.voidProtection);
        nbt.method_10556("backpackSettings.backpackDeathPlace", data.backpackSettings.backpackDeathPlace);
        nbt.method_10556("backpackSettings.backpackForceDeathPlace", data.backpackSettings.backpackForceDeathPlace);
        nbt.method_10556("backpackSettings.enableSleepingBagSpawnPoint", data.backpackSettings.enableSleepingBagSpawnPoint);
        nbt.method_10556("backpackSettings.backSlotIntegration", data.backpackSettings.trinketsIntegration);
        nbt.method_10556("world.enableLoot", data.world.enableLoot);
        nbt.method_10548("world.chance", data.world.chance);
        nbt.method_10556("world.spawnEntitiesWithBackpack", data.world.spawnEntitiesWithBackpack);
        nbt.method_10582("world.possibleOverworldEntityTypes", String.join((CharSequence)",", data.world.possibleOverworldEntityTypes));
        nbt.method_10582("world.possibleNetherEntityTypes", String.join((CharSequence)",", data.world.possibleNetherEntityTypes));
        nbt.method_10582("world.overworldBackpacks", String.join((CharSequence)",", data.world.overworldBackpacks));
        nbt.method_10582("world.netherBackpacks", String.join((CharSequence)",", data.world.netherBackpacks));
        nbt.method_10556("world.enableVillagerTrade", data.world.enableVillagerTrade);
        nbt.method_10556("backpackAbilities.enableBackpackAbilities", data.backpackAbilities.enableBackpackAbilities);
        nbt.method_10556("backpackAbilities.forceAbilityEnabled", data.backpackAbilities.forceAbilityEnabled);
        nbt.method_10582("backpackAbilities.allowedAbilities", String.join((CharSequence)",", data.backpackAbilities.allowedAbilities));
        nbt.method_10556("slownessDebuff.tooManyBackpacksSlowness", data.slownessDebuff.tooManyBackpacksSlowness);
        nbt.method_10569("slownessDebuff.maxNumberOfBackpacks", data.slownessDebuff.maxNumberOfBackpacks);
        nbt.method_10569("slownessDebuff.slownessPerExcessedBackpack", data.slownessDebuff.slownessPerExcessedBackpack);
        return nbt;
    }

    public static TravelersBackpackConfigData readFromNbt(class_2487 nbt) {
        TravelersBackpackConfigData client = TravelersBackpackConfig.getConfig();
        TravelersBackpackConfigData data = new TravelersBackpackConfigData();
        data.client.overlay.enableOverlay = client.client.overlay.enableOverlay;
        data.client.overlay.offsetX = client.client.overlay.offsetX;
        data.client.overlay.offsetY = client.client.overlay.offsetY;
        data.client.showBackpackIconInInventory = client.client.showBackpackIconInInventory;
        data.client.sendBackpackCoordinatesMessage = client.client.sendBackpackCoordinatesMessage;
        data.client.enableToolCycling = client.client.enableToolCycling;
        data.client.disableScrollWheel = client.client.disableScrollWheel;
        data.client.obtainTips = client.client.obtainTips;
        data.client.renderTools = client.client.renderTools;
        if (nbt == null) {
            return data;
        }
        data.backpackUpgrades.enableTanksUpgrade = nbt.method_10577("backpackUpgrades.enableTanksUpgrade");
        data.backpackUpgrades.enableCraftingUpgrade = nbt.method_10577("backpackUpgrades.enableCraftingUpgrade");
        data.backpackUpgrades.enableJukeboxUpgrade = nbt.method_10577("backpackUpgrades.enableJukeboxUpgrade");
        data.backpackUpgrades.pickupUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.pickupUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.pickupUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.pickupUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.magnetUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.magnetUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.magnetUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.magnetUpgradeSettings.pullRange = nbt.method_10550("backpackUpgrades.magnetUpgradeSettings.pullRange");
        data.backpackUpgrades.feedingUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.feedingUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.feedingUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.feedingUpgradeSettings.filterSlotCount");
        data.backpackUpgrades.voidUpgradeSettings.enableUpgrade = nbt.method_10577("backpackUpgrades.voidUpgradeSettings.enableUpgrade");
        data.backpackUpgrades.voidUpgradeSettings.filterSlotCount = nbt.method_10550("backpackUpgrades.voidUpgradeSettings.filterSlotCount");
        data.backpackSettings.leather.inventorySlotCount = nbt.method_10550("backpackSettings.leather.inventorySlotCount");
        data.backpackSettings.leather.upgradeSlotCount = nbt.method_10550("backpackSettings.leather.upgradeSlotCount");
        data.backpackSettings.leather.toolSlotCount = nbt.method_10550("backpackSettings.leather.toolSlotCount");
        data.backpackSettings.leather.tankCapacityPerRow = nbt.method_10537("backpackSettings.leather.tankCapacityPerRow");
        data.backpackSettings.iron.inventorySlotCount = nbt.method_10550("backpackSettings.iron.inventorySlotCount");
        data.backpackSettings.iron.upgradeSlotCount = nbt.method_10550("backpackSettings.iron.upgradeSlotCount");
        data.backpackSettings.iron.toolSlotCount = nbt.method_10550("backpackSettings.iron.toolSlotCount");
        data.backpackSettings.iron.tankCapacityPerRow = nbt.method_10537("backpackSettings.iron.tankCapacityPerRow");
        data.backpackSettings.gold.inventorySlotCount = nbt.method_10550("backpackSettings.gold.inventorySlotCount");
        data.backpackSettings.gold.upgradeSlotCount = nbt.method_10550("backpackSettings.gold.upgradeSlotCount");
        data.backpackSettings.gold.toolSlotCount = nbt.method_10550("backpackSettings.gold.toolSlotCount");
        data.backpackSettings.gold.tankCapacityPerRow = nbt.method_10537("backpackSettings.gold.tankCapacityPerRow");
        data.backpackSettings.diamond.inventorySlotCount = nbt.method_10550("backpackSettings.diamond.inventorySlotCount");
        data.backpackSettings.diamond.upgradeSlotCount = nbt.method_10550("backpackSettings.diamond.upgradeSlotCount");
        data.backpackSettings.diamond.toolSlotCount = nbt.method_10550("backpackSettings.diamond.toolSlotCount");
        data.backpackSettings.diamond.tankCapacityPerRow = nbt.method_10537("backpackSettings.diamond.tankCapacityPerRow");
        data.backpackSettings.netherite.inventorySlotCount = nbt.method_10550("backpackSettings.netherite.inventorySlotCount");
        data.backpackSettings.netherite.upgradeSlotCount = nbt.method_10550("backpackSettings.netherite.upgradeSlotCount");
        data.backpackSettings.netherite.toolSlotCount = nbt.method_10550("backpackSettings.netherite.toolSlotCount");
        data.backpackSettings.netherite.tankCapacityPerRow = nbt.method_10537("backpackSettings.netherite.tankCapacityPerRow");
        data.backpackSettings.rightClickEquip = nbt.method_10577("backpackSettings.rightClickEquip");
        data.backpackSettings.rightClickUnequip = nbt.method_10577("backpackSettings.rightClickUnequip");
        data.backpackSettings.allowOnlyEquippedBackpack = nbt.method_10577("backpackSettings.allowOnlyEquippedBackpack");
        data.backpackSettings.invulnerableBackpack = nbt.method_10577("backpackSettings.invulnerableBackpack");
        data.backpackSettings.toolSlotsAcceptableItems = nbt.method_10558("backpackSettings.toolSlotsAcceptableItems").split(",");
        data.backpackSettings.blacklistedItems = nbt.method_10558("backpackSettings.blacklistedItems").split(",");
        data.backpackSettings.toolSlotsAcceptEverything = nbt.method_10577("backpackSettings.toolSlotsAcceptEverything");
        data.backpackSettings.allowShulkerBoxes = nbt.method_10577("backpackSettings.allowShulkerBoxes");
        data.backpackSettings.voidProtection = nbt.method_10577("backpackSettings.voidProtection");
        data.backpackSettings.backpackDeathPlace = nbt.method_10577("backpackSettings.backpackDeathPlace");
        data.backpackSettings.backpackForceDeathPlace = nbt.method_10577("backpackSettings.backpackForceDeathPlace");
        data.backpackSettings.enableSleepingBagSpawnPoint = nbt.method_10577("backpackSettings.enableSleepingBagSpawnPoint");
        data.backpackSettings.trinketsIntegration = nbt.method_10577("backpackSettings.backSlotIntegration");
        data.world.enableLoot = nbt.method_10577("world.enableLoot");
        data.world.chance = nbt.method_10583("world.chance");
        data.world.spawnEntitiesWithBackpack = nbt.method_10577("world.spawnEntitiesWithBackpack");
        data.world.possibleOverworldEntityTypes = nbt.method_10558("world.possibleOverworldEntityTypes").split(",");
        data.world.possibleNetherEntityTypes = nbt.method_10558("world.possibleNetherEntityTypes").split(",");
        data.world.overworldBackpacks = nbt.method_10558("world.overworldBackpacks").split(",");
        data.world.netherBackpacks = nbt.method_10558("world.netherBackpacks").split(",");
        data.world.enableVillagerTrade = nbt.method_10577("world.enableVillagerTrade");
        data.backpackAbilities.enableBackpackAbilities = nbt.method_10577("backpackAbilities.enableBackpackAbilities");
        data.backpackAbilities.forceAbilityEnabled = nbt.method_10577("backpackAbilities.forceAbilityEnabled");
        data.backpackAbilities.allowedAbilities = nbt.method_10558("backpackAbilities.allowedAbilities").split(",");
        data.slownessDebuff.tooManyBackpacksSlowness = nbt.method_10577("slownessDebuff.tooManyBackpacksSlowness");
        data.slownessDebuff.maxNumberOfBackpacks = nbt.method_10550("slownessDebuff.maxNumberOfBackpacks");
        data.slownessDebuff.slownessPerExcessedBackpack = nbt.method_10550("slownessDebuff.slownessPerExcessedBackpack");
        return data;
    }
}

