/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.inventory.FluidVariantWrapper;
import java.util.Optional;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2487;

public class FluidTank
extends SingleVariantStorage<FluidVariant> {
    protected Predicate<FluidVariantWrapper> validator;
    protected FluidVariantWrapper fluidVariant = FluidVariantWrapper.blank();
    protected long capacity;

    public FluidTank(long capacity) {
        this(capacity, e -> true);
    }

    public FluidTank(long capacity, Predicate<FluidVariantWrapper> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public FluidTank setCapacity(long capacity) {
        this.capacity = capacity;
        return this;
    }

    public FluidTank setValidator(Predicate<FluidVariantWrapper> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidVariantWrapper stack) {
        return this.validator.test(stack);
    }

    protected FluidVariant getBlankVariant() {
        return FluidVariant.blank();
    }

    protected long getCapacity(FluidVariant variant) {
        return this.capacity;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public FluidVariantWrapper getFluid() {
        return this.fluidVariant;
    }

    public long getFluidAmount() {
        return this.fluidVariant.getAmount();
    }

    public FluidTank readFromNBT(class_2487 nbt) {
        this.fluidVariant = FluidVariantWrapper.parseOptional(nbt.method_10562("Fluid"));
        return this;
    }

    public class_2487 writeToNBT(class_2487 nbt) {
        if (!this.fluidVariant.fluidVariant().isBlank()) {
            nbt.method_10566("Fluid", this.fluidVariant.saveOptional());
        }
        return nbt;
    }

    public int getTanks() {
        return 1;
    }

    public FluidVariantWrapper getFluidInTank(int tank) {
        return this.getFluid();
    }

    public long getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, FluidVariantWrapper stack) {
        return this.isFluidValid(stack);
    }

    public long fill(FluidVariantWrapper resource, boolean simulate) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0L;
        }
        if (simulate) {
            if (this.fluidVariant.isEmpty()) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluidVariant.fluidVariant().isOf((Object)resource.fluidVariant().getFluid())) {
                return 0L;
            }
            return Math.min(this.capacity - this.fluidVariant.getAmount(), resource.getAmount());
        }
        if (this.fluidVariant.isEmpty()) {
            this.fluidVariant = resource.copyWithAmount(Math.min(this.capacity, resource.getAmount()));
            this.onContentsChanged();
            return this.fluidVariant.getAmount();
        }
        if (!this.fluidVariant.fluidVariant().isOf((Object)resource.fluidVariant().getFluid())) {
            return 0L;
        }
        long filled = this.capacity - this.fluidVariant.getAmount();
        if (resource.getAmount() < filled) {
            this.fluidVariant = this.fluidVariant.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            this.fluidVariant = this.fluidVariant.setAmount(this.capacity);
        }
        if (filled > 0L) {
            this.onContentsChanged();
        }
        return filled;
    }

    public FluidVariantWrapper drain(FluidVariantWrapper resource, boolean simulate) {
        if (resource.isEmpty() || !resource.fluidVariant().isOf((Object)this.fluidVariant.fluidVariant().getFluid())) {
            return FluidVariantWrapper.blank();
        }
        return this.drain(resource.getAmount(), simulate);
    }

    public FluidVariantWrapper drain(long maxDrain, boolean simulate) {
        long drained = maxDrain;
        if (this.fluidVariant.getAmount() < drained) {
            drained = this.fluidVariant.getAmount();
        }
        FluidVariantWrapper stack = this.fluidVariant.copyWithAmount(drained);
        if (!simulate && drained > 0L) {
            this.fluidVariant = this.fluidVariant.shrink(drained);
            if (this.fluidVariant.amount() <= 0L) {
                this.fluidVariant = FluidVariantWrapper.blank();
            }
            this.onContentsChanged();
        }
        return stack;
    }

    public long insert(FluidVariant insertedVariant, long maxAmount, TransactionContext transaction) {
        long insertedAmount;
        StoragePreconditions.notBlankNotNegative((TransferVariant)insertedVariant, (long)maxAmount);
        if ((insertedVariant.equals((Object)this.fluidVariant.fluidVariant()) || this.fluidVariant.fluidVariant().isBlank()) && this.canInsert((TransferVariant)insertedVariant) && (insertedAmount = Math.min(maxAmount, this.getCapacity(insertedVariant) - this.fluidVariant.amount())) > 0L) {
            this.updateSnapshots(transaction);
            if (this.fluidVariant.fluidVariant().isBlank()) {
                this.fill(new FluidVariantWrapper(insertedVariant, insertedAmount), false);
            } else {
                this.fill(new FluidVariantWrapper(insertedVariant, insertedAmount), false);
            }
            return insertedAmount;
        }
        return 0L;
    }

    public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
        long extractedAmount;
        StoragePreconditions.notBlankNotNegative((TransferVariant)extractedVariant, (long)maxAmount);
        if (extractedVariant.equals((Object)this.fluidVariant.fluidVariant()) && this.canExtract((TransferVariant)extractedVariant) && (extractedAmount = Math.min(maxAmount, this.fluidVariant.amount())) > 0L) {
            this.updateSnapshots(transaction);
            this.drain(extractedAmount, false);
            return extractedAmount;
        }
        return 0L;
    }

    protected void onContentsChanged() {
    }

    public void setFluid(FluidVariantWrapper stack) {
        this.fluidVariant = stack;
    }

    public boolean isEmpty() {
        return this.fluidVariant.isEmpty();
    }

    public long getSpace() {
        return Math.max(0L, this.capacity - this.fluidVariant.getAmount());
    }

    public boolean isResourceBlank() {
        return this.fluidVariant.fluidVariant().isBlank();
    }

    public FluidVariant getResource() {
        return this.fluidVariant.fluidVariant();
    }

    public long getAmount() {
        return this.fluidVariant.amount();
    }

    protected ResourceAmount<FluidVariant> createSnapshot() {
        return new ResourceAmount((Object)this.fluidVariant.fluidVariant(), this.fluidVariant.amount());
    }

    protected void readSnapshot(ResourceAmount<FluidVariant> snapshot) {
        this.fluidVariant = new FluidVariantWrapper((FluidVariant)snapshot.resource(), snapshot.amount());
    }

    public String toString() {
        return "SingleVariantStorage[%d %s]".formatted(this.fluidVariant.amount(), this.fluidVariant.fluidVariant());
    }

    public FluidTank readNbtOld(class_2487 nbt) {
        this.variant = FluidTank.readOptional(nbt.method_10562("variant"));
        this.capacity = nbt.method_10573("capacity", 3) ? nbt.method_10537("capacity") : this.capacity;
        this.amount = nbt.method_10537("amount");
        return this;
    }

    public static Optional<FluidVariant> read(class_2487 tag) {
        return Optional.of(FluidVariantWrapper.parseOptional(tag).fluidVariant());
    }

    public static FluidVariant readOptional(class_2487 tag) {
        return tag.method_33133() ? FluidVariant.blank() : FluidTank.read(tag).orElse(FluidVariant.blank());
    }
}

