/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

public class SlotPositioner {
    private final int storageSlotCount;
    private final boolean isWider;

    public SlotPositioner(int storageSlotCount) {
        this.storageSlotCount = storageSlotCount;
        this.isWider = storageSlotCount > 81;
    }

    public int getSlotsInRow() {
        if (this.isWider) {
            return 11;
        }
        return 9;
    }

    public int getFullRows() {
        return this.storageSlotCount / this.getSlotsInRow();
    }

    public int getLastRowSlots() {
        return this.storageSlotCount - this.getSlotsInRow() * this.getFullRows();
    }

    public int getRows() {
        return (int)Math.ceil((double)this.storageSlotCount / (double)this.getSlotsInRow());
    }

    public boolean isExtended() {
        return this.isWider;
    }
}

